/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.PrimitiveData;
import java.util.HashMap;

final class Classes {
    public static final String BOOLEAN = "boolean";
    public static final String BYTE = "byte";
    public static final String CHAR = "char";
    public static final String DOUBLE = "double";
    public static final String FLOAT = "float";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String SHORT = "short";
    public static final Class<?> booleanWrapperClass = Boolean.TRUE.getClass();
    public static final Class<?> byteWrapperClass = new Byte(0).getClass();
    public static final Class<?> charWrapperClass = new Character('\u0000').getClass();
    public static final Class<?> doubleWrapperClass = new Double(0.0).getClass();
    public static final Class<?> floatWrapperClass = new Float(0.0f).getClass();
    public static final Class<?> intWrapperClass = new Integer(0).getClass();
    public static final Class<?> longWrapperClass = new Long(0L).getClass();
    public static final Class<?> shortWrapperClass = new Short(0).getClass();
    private static final HashMap<Class<?>, Class<?>> wrapperClass2primitiveClass = new HashMap();
    private static final HashMap<Class<?>, Class<?>> primitiveClass2wrapperClass = new HashMap();
    public static final Classes FAIL = new Classes(false, null);
    private static final HashMap<String, Character> shortNames = new HashMap();
    public final boolean isPrimitive;
    public final Class classObject;

    public Classes(boolean bl, Class clazz) {
        this.isPrimitive = bl;
        this.classObject = clazz;
    }

    public String toString() {
        return String.format("<%s, %s>", this.isPrimitive, this.classObject);
    }

    public static final Classes parseString(String string) {
        if (string == null) {
            return FAIL;
        }
        int n = string.length();
        if (n == 0) {
            return FAIL;
        }
        if (string.charAt(n - 1) == ']') {
            return Classes.fromReadableString(string);
        }
        return Classes.fromString(string);
    }

    private static Classes fromString(String string) {
        Class<?> clazz = Classes.toClass(string);
        if (clazz != null) {
            return new Classes(true, clazz);
        }
        try {
            clazz = Class.forName(string);
            return new Classes(false, clazz);
        }
        catch (Exception exception) {
            return FAIL;
        }
    }

    private static Classes fromReadableString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Classes classes = FAIL;
        assert (string != null);
        int n = string.length();
        assert (n != 0);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            String string2;
            if (string.charAt(i) == '[') {
                if (string.charAt(n - 1 - i) != ']') break;
                stringBuilder.append('[');
                continue;
            }
            String string3 = string.substring(i, n - i);
            Character c = shortNames.get(string3);
            if (c != null) {
                stringBuilder.append(c);
                string2 = stringBuilder.toString();
                bl = i == 0;
            } else {
                if (i == 0) {
                    stringBuilder.append(string3);
                } else {
                    stringBuilder.append('L').append(string3).append(';');
                }
                string2 = stringBuilder.toString();
                bl = false;
            }
            try {
                Class<?> clazz = bl ? Classes.toClass(string) : Class.forName(string2);
                classes = new Classes(bl, clazz);
            }
            catch (Exception exception) {}
            break;
        }
        return classes;
    }

    public static Class<?> unwrap(Class<?> clazz) {
        Class<?> clazz2 = wrapperClass2primitiveClass.get(clazz);
        return clazz2 == null ? clazz : clazz2;
    }

    public static Class<?> unwrapClass(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof PrimitiveData) {
            return ((PrimitiveData)object).unwrapClass();
        }
        return object.getClass();
    }

    public static Object unwrapValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof PrimitiveData) {
            return ((PrimitiveData)object).unwrapValue();
        }
        return object;
    }

    public static Class<?> toWrapperClass(String string) {
        if (string == null) {
            return null;
        }
        switch (string.charAt(0)) {
            case 'b': {
                if (string.equalsIgnoreCase(BOOLEAN)) {
                    return booleanWrapperClass;
                }
                if (!string.equalsIgnoreCase(BYTE)) break;
                return byteWrapperClass;
            }
            case 'c': {
                if (!string.equalsIgnoreCase(CHAR)) break;
                return charWrapperClass;
            }
            case 'd': {
                if (!string.equalsIgnoreCase(DOUBLE)) break;
                return doubleWrapperClass;
            }
            case 'f': {
                if (!string.equalsIgnoreCase(FLOAT)) break;
                return floatWrapperClass;
            }
            case 'i': {
                if (!string.equalsIgnoreCase(INT)) break;
                return intWrapperClass;
            }
            case 'l': {
                if (!string.equalsIgnoreCase(LONG)) break;
                return longWrapperClass;
            }
            case 's': {
                if (!string.equalsIgnoreCase(SHORT)) break;
                return shortWrapperClass;
            }
        }
        return null;
    }

    public static Class<?> toWrapperClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return primitiveClass2wrapperClass.get(clazz);
    }

    public static Class<?> toClass(String string) {
        if (string == null) {
            return null;
        }
        switch (string.charAt(0)) {
            case 'b': {
                if (string.equalsIgnoreCase(BOOLEAN)) {
                    return Boolean.TYPE;
                }
                if (!string.equalsIgnoreCase(BYTE)) break;
                return Byte.TYPE;
            }
            case 'c': {
                if (!string.equalsIgnoreCase(CHAR)) break;
                return Character.TYPE;
            }
            case 'd': {
                if (!string.equalsIgnoreCase(DOUBLE)) break;
                return Double.TYPE;
            }
            case 'f': {
                if (!string.equalsIgnoreCase(FLOAT)) break;
                return Float.TYPE;
            }
            case 'i': {
                if (!string.equalsIgnoreCase(INT)) break;
                return Integer.TYPE;
            }
            case 'l': {
                if (!string.equalsIgnoreCase(LONG)) break;
                return Long.TYPE;
            }
            case 's': {
                if (!string.equalsIgnoreCase(SHORT)) break;
                return Short.TYPE;
            }
        }
        return null;
    }

    public static Class<?> widen(Class<?> clazz) {
        assert (clazz.isPrimitive());
        if (clazz == Boolean.TYPE) {
            return null;
        }
        if (clazz == Byte.TYPE) {
            return Short.TYPE;
        }
        if (clazz == Character.TYPE) {
            return Integer.TYPE;
        }
        if (clazz == Double.TYPE) {
            return null;
        }
        if (clazz == Float.TYPE) {
            return Double.TYPE;
        }
        if (clazz == Integer.TYPE) {
            return Long.TYPE;
        }
        if (clazz == Long.TYPE) {
            return Float.TYPE;
        }
        if (clazz == Short.TYPE) {
            return Integer.TYPE;
        }
        return null;
    }

    public static boolean strictlyWidensTo(Class<?> clazz, Class<?> clazz2) {
        assert (clazz.isPrimitive() && clazz2.isPrimitive());
        if (clazz == Boolean.TYPE) {
            return false;
        }
        if (clazz == Byte.TYPE) {
            return clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE;
        }
        if (clazz == Character.TYPE) {
            return clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE;
        }
        if (clazz == Double.TYPE) {
            return false;
        }
        if (clazz == Float.TYPE) {
            return clazz2 == Double.TYPE;
        }
        if (clazz == Integer.TYPE) {
            return clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE;
        }
        if (clazz == Long.TYPE) {
            return clazz2 == Float.TYPE || clazz2 == Double.TYPE;
        }
        if (clazz == Short.TYPE) {
            return clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE;
        }
        return false;
    }

    public static boolean wrapperWidensTo(Object object, Class<?> clazz) {
        Class<?> clazz2 = object.getClass();
        clazz2 = Classes.unwrap(clazz2);
        clazz = Classes.unwrap(clazz);
        assert (clazz2.isPrimitive() && clazz.isPrimitive());
        if (clazz2 == clazz) {
            return true;
        }
        return Classes.strictlyWidensTo(clazz2, clazz);
    }

    public static String toString(Class<?>[] classArray) {
        String string = "[";
        for (int i = 0; i < classArray.length; ++i) {
            string = string + classArray[i];
            if (i == classArray.length - 1) continue;
            string = string + " ";
        }
        string = string + "]";
        return string;
    }

    public static void display(Class<?>[] classArray) {
        System.err.println(Classes.toString(classArray));
    }

    static {
        shortNames.put(BYTE, Character.valueOf('B'));
        shortNames.put(CHAR, Character.valueOf('C'));
        shortNames.put(DOUBLE, Character.valueOf('D'));
        shortNames.put(FLOAT, Character.valueOf('F'));
        shortNames.put(INT, Character.valueOf('I'));
        shortNames.put(LONG, Character.valueOf('J'));
        shortNames.put(SHORT, Character.valueOf('S'));
        shortNames.put(BOOLEAN, Character.valueOf('Z'));
        wrapperClass2primitiveClass.put(booleanWrapperClass, Boolean.TYPE);
        wrapperClass2primitiveClass.put(byteWrapperClass, Byte.TYPE);
        wrapperClass2primitiveClass.put(charWrapperClass, Character.TYPE);
        wrapperClass2primitiveClass.put(doubleWrapperClass, Double.TYPE);
        wrapperClass2primitiveClass.put(floatWrapperClass, Float.TYPE);
        wrapperClass2primitiveClass.put(intWrapperClass, Integer.TYPE);
        wrapperClass2primitiveClass.put(longWrapperClass, Long.TYPE);
        wrapperClass2primitiveClass.put(shortWrapperClass, Short.TYPE);
        primitiveClass2wrapperClass.put(Boolean.TYPE, booleanWrapperClass);
        primitiveClass2wrapperClass.put(Byte.TYPE, byteWrapperClass);
        primitiveClass2wrapperClass.put(Character.TYPE, charWrapperClass);
        primitiveClass2wrapperClass.put(Double.TYPE, doubleWrapperClass);
        primitiveClass2wrapperClass.put(Float.TYPE, floatWrapperClass);
        primitiveClass2wrapperClass.put(Integer.TYPE, intWrapperClass);
        primitiveClass2wrapperClass.put(Long.TYPE, longWrapperClass);
        primitiveClass2wrapperClass.put(Short.TYPE, shortWrapperClass);
    }
}

