/*
 * Decompiled with CFR 0.152.
 */
package g2d.jlambda;

import g2d.jlambda.AnalysisEnv;
import g2d.jlambda.Code;
import g2d.jlambda.Evaluate;
import g2d.jlambda.LexicalAddress;
import g2d.jlambda.List;
import g2d.jlambda.SyntaxError;

public final class Analyse {
    private Analyse() {
    }

    public static Object analyse(Object object, AnalysisEnv analysisEnv) throws SyntaxError {
        Object object2 = null;
        if (object == null) {
            String string = "analyse: null expression. ";
            throw new SyntaxError(string, null);
        }
        if (object instanceof String) {
            LexicalAddress lexicalAddress = analysisEnv.lookup((String)object);
            object2 = lexicalAddress != null ? lexicalAddress : object;
        } else if (!(object instanceof List)) {
            object2 = object;
        } else {
            if (!(object instanceof Code)) {
                String string = "form a List not Code";
                throw new SyntaxError(string, (List)object);
            }
            object2 = Analyse.analyseCode((Code)object, analysisEnv);
        }
        return object2;
    }

    public static Object analyseCode(Code code, AnalysisEnv analysisEnv) throws SyntaxError {
        if (code.size() < 1) {
            String string = "form length < 1";
            throw new SyntaxError(string, code);
        }
        Object object = code.car();
        if (!(object instanceof String)) {
            String string = "operator not String";
            throw new SyntaxError(string, code);
        }
        String string = (String)object;
        if (code.size() < 2 && !Analyse.canBeNullaryForm(string)) {
            String string2 = "form length < 2";
            throw new SyntaxError(string2, code);
        }
        if (string.length() < 1) {
            String string3 = "null string operator";
            throw new SyntaxError(string3, code);
        }
        if (!(code.cdr() instanceof Code)) {
            String string4 = "form.cdr() a List not Code";
            throw new SyntaxError(string4, code.cdr());
        }
        Code code2 = (Code)code.cdr();
        if (Analyse.isPrimitiveForm(string)) {
            return Analyse.analysePrimitiveForm(code, string, code2, analysisEnv);
        }
        if (string == "quote") {
            Analyse.checkExactArity(code, 1);
            return code;
        }
        if (Analyse.isUnaryForm(string)) {
            Analyse.checkExactArity(code, 1);
            return Analyse.analyseForm(code, string, code2, analysisEnv);
        }
        if (string == "object") {
            return Analyse.analyseObjectForm(code, string, code2, analysisEnv);
        }
        if (string == "-") {
            if (code2.size() != 1 && code2.size() != 2) {
                String string5 = "wrong number of arguments";
                throw new SyntaxError(string5, code);
            }
            return Analyse.analyseForm(code, string, code2, analysisEnv);
        }
        if (Analyse.isBinaryForm(string)) {
            Analyse.checkExactArity(code, 2);
            return Analyse.analyseForm(code, string, code2, analysisEnv);
        }
        if (Analyse.isTernaryForm(string)) {
            Analyse.checkExactArity(code, 3);
            return Analyse.analyseForm(code, string, code2, analysisEnv);
        }
        if (string == "let") {
            return Analyse.analyseLetForm(code, string, code2, analysisEnv);
        }
        if (string == "lambda") {
            return Analyse.analyseLambdaForm(code, string, code2, analysisEnv);
        }
        if (string == "catch") {
            String string6 = "'catch' not component of `try' form";
            throw new SyntaxError(string6, code);
        }
        if (string == "try") {
            return Analyse.analyseTryForm(code, string, code2, analysisEnv);
        }
        if (string == "getattr" || string == "if") {
            if (code2.size() != 2 && code2.size() != 3) {
                String string7 = "wrong number of arguments";
                throw new SyntaxError(string7, code);
            }
            return Analyse.analyseForm(code, string, code2, analysisEnv);
        }
        if (string == "concat") {
            return Analyse.analysePossiblyNullaryForm(code, string, code2, analysisEnv, Code.clist("quote", ""));
        }
        if (string == "tuple") {
            return Analyse.analyseTupleForm(code, string, code2, analysisEnv);
        }
        if (string == "seq") {
            return Analyse.analysePossiblyNullaryForm(code, string, code2, analysisEnv, Code.clist("object", "null"));
        }
        if (string == "and" || string == "apply" || string == "or") {
            if (code2.size() == 0) {
                String string8 = "wrong number of arguments";
                throw new SyntaxError(string8, code);
            }
            return Analyse.analyseForm(code, string, code2, analysisEnv);
        }
        if (string == "nreduce") {
            if (code2.size() < 3) {
                String string9 = "wrong number of arguments";
                throw new SyntaxError(string9, code);
            }
            return Analyse.analyseForm(code, string, code2, analysisEnv);
        }
        if (string == "mkarray") {
            Analyse.checkExactArity(code, 2);
            Analyse.checkArgOneString(code, code2, "type not string: ");
            return Analyse.analyseForm(code, string, code2, analysisEnv);
        }
        if (string == "for") {
            return Analyse.analyseForForm(code, string, code2, analysisEnv);
        }
        if (string == "array") {
            return Analyse.analyseArrayForm(code, string, code2, analysisEnv);
        }
        if (string == "define") {
            return Analyse.analyseDefineForm(code, string, code2, analysisEnv);
        }
        if (string == "object") {
            return Analyse.analyseObjectForm(code, string, code2, analysisEnv);
        }
        if (string == "invoke" || string == "sinvoke") {
            if (code2.size() < 2) {
                String string10 = "wrong number of arguments";
                throw new SyntaxError(string10, code);
            }
            return Analyse.analyseForm(code, string, code2, analysisEnv);
        }
        if (string == "do") {
            return Analyse.analyseDoForm(code, string, code2, analysisEnv);
        }
        String string11 = "Invalid operator " + string;
        throw new SyntaxError(string11, code);
    }

    private static void checkArgOneString(Code code, Code code2, String string) throws SyntaxError {
        Object object = code2.car();
        if (!(object instanceof String)) {
            throw new SyntaxError(string + object, code);
        }
    }

    private static void checkExactArity(Code code, int n) throws SyntaxError {
        if (code.size() != n + 1) {
            throw new SyntaxError("wrong number of arguments", code);
        }
    }

    private static Object analysePossiblyNullaryForm(Code code, String string, Code code2, AnalysisEnv analysisEnv, Code code3) throws SyntaxError {
        if (code2.size() == 0) {
            Code.augmentSpine(code, code3);
            return code3;
        }
        return Analyse.analyseForm(code, string, code2, analysisEnv);
    }

    private static Object analyseTupleForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        if (code2.size() == 0) {
            return code;
        }
        return Analyse.analyseForm(code, string, code2, analysisEnv);
    }

    private static Code analyseFormList(Code code, AnalysisEnv analysisEnv) throws SyntaxError {
        Code code2;
        List list = code2 = new Code();
        List list2 = code;
        do {
            Code.augmentCell(list2, list);
            list = ((List)list).snoc(Analyse.analyse(list2.car, analysisEnv));
            list2 = list2.cdr;
        } while (!list2.empty);
        Code.augmentCell(list2, list);
        return code2;
    }

    public static Code analyseForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        Code code3 = new Code((Object)string, Analyse.analyseFormList(code2, analysisEnv));
        Code.augmentCell(code, code3);
        return code3;
    }

    public static Code analyseDefineForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        int n = code2.size();
        if (n != 2 && n != 3) {
            String string2 = "wrong number of arguments";
            throw new SyntaxError(string2, code);
        }
        if (!(code2.car() instanceof String)) {
            String string3 = "name not a string " + code2.car();
            throw new SyntaxError(string3, code);
        }
        String string4 = (String)code2.car();
        if (n == 2) {
            Code code3 = (Code)code2.cdr();
            try {
                Evaluate.addVirgin(string4, code);
            }
            catch (Exception exception) {
                System.err.println("Analyse.analyseDefineForm: " + string4 + " in " + code.filename + " lineno " + code.lineno);
            }
            Code code4 = new Code((Object)string4, Analyse.analyseFormList(code3, analysisEnv));
            Code code5 = new Code((Object)string, code4);
            Code.augmentSpine(2, code, code5);
            return code5;
        }
        if (!(code2.cadr() instanceof Code)) {
            String string5 = "parameters not code" + code2.cadr();
            throw new SyntaxError(string5, code);
        }
        Code code6 = (Code)code2.cadr();
        Code code7 = (Code)code2.cddr();
        try {
            Evaluate.addVirgin(string4, code);
        }
        catch (Exception exception) {
            System.err.println("Analyse.analyseDefineForm: " + string4 + " in " + code.filename + " lineno " + code.lineno);
        }
        String[] stringArray = Analyse.checkParams(code, string, code6);
        Code code8 = new Code((Object)code6, Analyse.analyseFormList(code7, analysisEnv.extend(stringArray)));
        code8 = new Code((Object)string4, code8);
        Code code9 = new Code((Object)string, code8);
        Code.augmentSpine(3, code, code9);
        return code9;
    }

    public static Code analyseArrayForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        Code code3;
        if (code2.size() < 1) {
            String string2 = "wrong number of arguments";
            throw new SyntaxError(string2, code);
        }
        Object object = code2.car();
        if (!(object instanceof String)) {
            String string3 = "invalid type specifier " + object;
            throw new SyntaxError(string3, code);
        }
        if (code2.size() == 1) {
            code3 = Code.clist("mkarray", object, Code.clist("int", "0"));
            Code.augmentSpine(code, code3);
        } else {
            Code code4 = Analyse.analyseFormList((Code)code2.cdr(), analysisEnv);
            code3 = new Code((Object)string, new Code(object, code4));
            Code.augmentSpine(2, code, code3);
        }
        return code3;
    }

    public static Code analyseLambdaForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        Analyse.checkExactArity(code, 2);
        Object object = code2.car();
        if (!(object instanceof Code)) {
            throw new SyntaxError("parameters not code", code);
        }
        Code code3 = (Code)object;
        String[] stringArray = Analyse.checkParams(code, string, code3);
        Object object2 = Analyse.analyse(code2.cadr(), analysisEnv.extend(stringArray));
        Code code4 = Code.clist(string, code3, object2);
        Code.augmentSpine(code, code4);
        return code4;
    }

    public static Code analysePrimitiveForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        Analyse.checkExactArity(code, 1);
        if (!(code2.car() instanceof String)) {
            throw new SyntaxError("argument is not a String", code);
        }
        return code;
    }

    public static Code analyseObjectForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        Analyse.checkExactArity(code, 1);
        if (!(code2.car instanceof Code)) {
            if (!(code2.car() instanceof String) || !((String)code2.car()).equals("null")) {
                throw new SyntaxError("argument neither code nor null", code);
            }
            return code;
        }
        Code code3 = (Code)code2.car();
        code3 = Analyse.analyseFormList(code3, analysisEnv);
        Code code4 = new Code((Object)string, Code.clist(code3));
        Code.augmentSpine(2, code, code4);
        return code4;
    }

    public static Code analyseTryForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        Analyse.checkExactArity(code, 2);
        Object object = code2.cadr();
        if (!(object instanceof Code)) {
            String string2 = "catch expr not code";
            throw new SyntaxError(string2, code);
        }
        List list = (List)object;
        if (list.size() != 3) {
            String string3 = "wrong number of arguments in catch expression";
            throw new SyntaxError(string3, list);
        }
        object = list.car();
        if (object != "catch") {
            String string4 = "invalid catch expression";
            throw new SyntaxError(string4, list);
        }
        Object object2 = list.cadr();
        if (!(object2 instanceof String)) {
            String string5 = "catch parameter not string " + object2;
            throw new SyntaxError(string5, code);
        }
        String string6 = (String)object2;
        Object object3 = list.nth(2);
        Object object4 = Analyse.analyse(code2.car(), analysisEnv);
        AnalysisEnv analysisEnv2 = analysisEnv.extend(new String[]{string6});
        Object object5 = Analyse.analyse(object3, analysisEnv2);
        Code code3 = Code.clist(string, object4, object5);
        Code.augmentSpine(code, code3);
        return code3;
    }

    public static Code analyseDoForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        Object object;
        int n;
        Code code3;
        Object object2;
        Code code4;
        if (code2.size() < 2) {
            String string2 = "wrong number of arguments";
            throw new SyntaxError(string2, code);
        }
        Object object3 = code2.car();
        if (!(object3 instanceof Code)) {
            String string3 = "bindings not code";
            throw new SyntaxError(string3, code);
        }
        Code code5 = code4 = (Code)object3;
        int n2 = code4.size();
        if (n2 == 0) {
            String string4 = "empty bindings";
            throw new SyntaxError(string4, code);
        }
        Code[] codeArray = new Code[n2];
        Object[] objectArray = new Object[n2];
        Object[] objectArray2 = new Object[n2];
        AnalysisEnv analysisEnv2 = analysisEnv;
        for (int i = 0; i < n2; ++i) {
            object2 = code4.car();
            if (!(object2 instanceof Code)) {
                String string5 = "binding form not list " + object2;
                throw new SyntaxError(string5, code);
            }
            code3 = (Code)object2;
            codeArray[i] = (Code)code3.cdr;
            n = code3.size();
            if (n != 3) {
                String string6 = "binding form wrong length " + object2;
                throw new SyntaxError(string6, code);
            }
            object = code3.car();
            if (!(object instanceof String)) {
                String string7 = "variable not a String " + object;
                throw new SyntaxError(string7, code);
            }
            analysisEnv2 = analysisEnv2.extend((String)object);
            objectArray[i] = Analyse.analyse(code3.cadr(), analysisEnv);
            objectArray2[i] = code3.caddr();
            code4 = (Code)code4.cdr();
        }
        Code code6 = new Code();
        object2 = code6;
        code3 = code5;
        for (n = 0; n < n2; ++n) {
            object = Code.clist(objectArray[n], Analyse.analyse(objectArray2[n], analysisEnv2));
            Code.augmentSpine(2, codeArray[n], (List)object);
            Code.augmentCell(code3, (List)object2);
            object2 = ((Code)object2).snoc(object);
            code3 = (Code)code3.cdr;
            Code.augmentCell(code3, (List)object2);
        }
        Object object4 = code2.cadr();
        if (!(object4 instanceof Code)) {
            String string8 = "termination not code";
            throw new SyntaxError(string8, code);
        }
        object = (Code)object4;
        if (((List)object).size() < 2) {
            String string9 = "termination form wrong length";
            throw new SyntaxError(string9, (List)object);
        }
        Code code7 = Analyse.analyseFormList((Code)object, analysisEnv2);
        Code code8 = Analyse.analyseFormList((Code)code2.cddr(), analysisEnv2);
        Code code9 = new Code((Object)code6, new Code((Object)code7, code8));
        Code.augmentSpine(2, code2, code9);
        Code code10 = new Code((Object)string, code9);
        Code.augmentCell(code, code10);
        return code10;
    }

    public static Code analyseLetForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        Object object;
        Analyse.checkExactArity(code, 2);
        if (!(code2.car() instanceof Code)) {
            throw new SyntaxError("bindings not code", code);
        }
        Code code3 = (Code)code2.car();
        int n = code3.size();
        Code code4 = new Code();
        String[] stringArray = new String[n];
        AnalysisEnv analysisEnv2 = analysisEnv;
        Code code5 = code4;
        Code code6 = code3;
        for (int i = 0; i < n; ++i) {
            object = code3.nth(i);
            if (!(object instanceof List)) {
                String string2 = "binding not code";
                throw new SyntaxError(string2, code);
            }
            Code code7 = (Code)object;
            if (code7.size() != 2) {
                String string3 = "binding not of length 2: " + code7;
                throw new SyntaxError(string3, code);
            }
            if (!(code7.car() instanceof String)) {
                String string4 = "invalid variable name " + code7.car();
                throw new SyntaxError(string4, code);
            }
            Object object2 = Analyse.analyse(code7.cadr(), analysisEnv2);
            stringArray[i] = (String)code7.car();
            Code code8 = Code.clist(stringArray[i], object2);
            Code.augmentSpine(code7, code8);
            Code.augmentCell(code6, code5);
            code5 = code5.snoc(code8);
            code6 = (Code)code6.cdr;
            analysisEnv2 = analysisEnv.extend(stringArray);
        }
        Object object3 = Analyse.analyse(code2.cadr(), analysisEnv2);
        object = Code.clist(string, code4, object3);
        Code.augmentSpine(code, (List)object);
        return object;
    }

    public static Code analyseForForm(Code code, String string, Code code2, AnalysisEnv analysisEnv) throws SyntaxError {
        Analyse.checkExactArity(code, 3);
        Analyse.checkArgOneString(code, code2, "type not string: ");
        String string2 = (String)code2.car();
        Object object = Analyse.analyse(code2.cadr(), analysisEnv);
        Object object2 = Analyse.analyse(code2.caddr(), analysisEnv.extend(string2));
        Code code3 = Code.clist(string2, object, object2);
        Code code4 = new Code((Object)string, code3);
        Code.augmentSpine(code, code4);
        return code4;
    }

    public static String[] checkParams(Code code, String string, Code code2) throws SyntaxError {
        String[] stringArray = new String[code2.size()];
        for (int i = 0; i < code2.size(); ++i) {
            Object object = code2.nth(i);
            if (!(object instanceof String)) {
                String string2 = "parameter not a string " + object;
                throw new SyntaxError(string2, code);
            }
            stringArray[i] = (String)object;
        }
        return stringArray;
    }

    public static boolean isPrimitiveForm(String string) {
        return string == "boolean" || string == "byte" || string == "char" || string == "double" || string == "float" || string == "int" || string == "long" || string == "short";
    }

    public static boolean canBeNullaryForm(String string) {
        return string == "concat" || string == "seq" || string == "tuple";
    }

    public static boolean isUnaryForm(String string) {
        return string == "fetch" || string == "load" || string == "isnull" || string == "isobject" || string == "istuple" || string == "getuid" || string == "mktuple" || string == "not" || string == "throw";
    }

    public static boolean isBinaryForm(String string) {
        return string == "aget" || string == "/" || string == "==" || string == "=" || string == "<=" || string == "<" || string == "instanceof" || string == ">=" || string == "lookup" || string == ">" || string == "%" || string == "narrow" || string == "!=" || string == "nth" || string == "+" || string == "setuid" || string == "*";
    }

    public static boolean isTernaryForm(String string) {
        return string == "aset" || string == "reduce" || string == "setattr" || string == "supdate" || string == "setnth" || string == "update";
    }
}

