/*
 * Decompiled with CFR 0.152.
 */
package g2d.graphviewer;

import g2d.graphviewer.SEPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class TabMenu
extends JPanel {
    private JLabel label;
    private List<Component> components = new ArrayList<Component>();
    private Font font;
    private JButton escape;
    private JPanel buttons;

    public TabMenu(Font font, SEPanel sEPanel) {
        this.setOpaque(false);
        this.font = font;
        this.setLayout(new BorderLayout(0, 6));
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.label = new JLabel(" ");
        this.label.setFont(this.font);
        this.add((Component)this.label, "First");
        this.buttons = new JPanel();
        this.buttons.setLayout(new BoxLayout(this.buttons, 3));
        JScrollPane jScrollPane = new JScrollPane(this.buttons);
        this.add((Component)jScrollPane, "Center");
        this.escape = new JButton("Close Context Menu");
        this.escape.setToolTipText("Close this menu and return to last (enabled) tab [ESC]");
        this.escape.setOpaque(false);
        final SEPanel sEPanel2 = sEPanel;
        this.escape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                sEPanel2.clearMenu();
            }
        });
        this.add((Component)this.escape, "Last");
    }

    public void displayMenu(String string, List<AbstractButton> list) {
        this.displayMenu(string, list, true);
    }

    public void displayMenu(String string, List<AbstractButton> list, boolean bl) {
        if (bl) {
            this.clearMenu();
            this.label.setText(string);
        }
        if (list != null) {
            for (final AbstractButton abstractButton : list) {
                this.addButton(abstractButton);
                int n = abstractButton.getDisplayedMnemonicIndex();
                if (n == -1) continue;
                this.getInputMap(2).put(KeyStroke.getKeyStroke(abstractButton.getText().toLowerCase().charAt(n)), abstractButton.toString() + "!doClick");
                this.getActionMap().put(abstractButton.toString() + "!doClick", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        abstractButton.doClick();
                    }
                });
            }
            this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), this.escape.toString() + "!doClick");
            this.getActionMap().put(this.escape.toString() + "!doClick", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TabMenu.this.escape.doClick();
                }
            });
            this.revalidate();
            this.repaint();
        }
    }

    public void clearMenu() {
        this.label.setText(" ");
        for (Component serializable2 : this.components) {
            this.buttons.remove(serializable2);
        }
        this.components.clear();
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        KeyStroke[] keyStrokeArray = inputMap.keys();
        for (int i = 0; keyStrokeArray != null && i < keyStrokeArray.length; ++i) {
            Object object = inputMap.get(keyStrokeArray[i]);
            if (!(object instanceof String) || !((String)object).endsWith("!doClick")) continue;
            inputMap.remove(keyStrokeArray[i]);
            actionMap.remove(object);
        }
    }

    private void addButton(AbstractButton abstractButton) {
        abstractButton.setOpaque(false);
        abstractButton.setHorizontalAlignment(10);
        abstractButton.setFont(this.font);
        abstractButton.setAlignmentX(0.0f);
        abstractButton.revalidate();
        abstractButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, abstractButton.getPreferredSize().height));
        this.components.add(this.buttons.add(abstractButton));
        this.components.add(this.buttons.add(Box.createRigidArea(new Dimension(0, 5))));
    }
}

