/*
 * Decompiled with CFR 0.152.
 */
package g2d.graphviewer;

import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graphviewer.GraphPanel;
import g2d.graphviewer.Textual;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class GraphMenu
extends JMenu {
    private final GraphPanel graphPanel;
    private final Textual sePanel;

    public GraphMenu(JFrame jFrame, GraphPanel graphPanel, Textual textual) {
        super("Graph");
        this.graphPanel = graphPanel;
        this.sePanel = textual;
        this.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Show Info", 73);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                IOPGraph iOPGraph = GraphMenu.this.graphPanel.getGraph();
                if (iOPGraph != null) {
                    stringBuffer.append("Graph ID: ").append(iOPGraph.getUID()).append("\n");
                    String[] stringArray = iOPGraph.getKeys();
                    stringBuffer.append("      attributes: " + stringArray.length + "\n");
                    for (String objectArray : stringArray) {
                        stringBuffer.append("        " + objectArray + " = " + iOPGraph.getAttribute(objectArray) + "\n");
                    }
                    Object[] objectArray = iOPGraph.getNodesInArray();
                    int n = 0;
                    int n2 = 0;
                    for (Object object : objectArray) {
                        IOPNode.NodeType nodeType = ((IOPNode)object).type;
                        if (nodeType == IOPNode.NodeType.RULE) {
                            ++n;
                        }
                        if (nodeType != IOPNode.NodeType.OCC) continue;
                        ++n2;
                    }
                    if (n2 != 0 && n != 0) {
                        stringBuffer.append("No. of rules: ").append(n).append("\n");
                        stringBuffer.append("No. of occurences: ").append(n2).append("\n");
                    } else {
                        stringBuffer.append("No. of nodes: ").append(objectArray.length).append("\n");
                    }
                }
                GraphMenu.this.sePanel.displayText("Info about this graph:", stringBuffer.toString());
            }
        });
        this.add(jMenuItem);
        this.addSeparator();
    }
}

