/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Json2Dot {
    private static final String[] NODE_ATTRIBUTES = new String[]{"label", "color", "shape", "style", "fontsize"};
    private static final String[] EDGE_ATTRIBUTES = new String[]{"color", "lhead", "ltail", "style", "arrowhead", "penwidth"};
    private static final String[] SUBGRAPH_ATTRIBUTES = new String[]{"color", "label", "style"};
    private static final String[] GRAPH_ATTRIBUTES = new String[]{"size", "newrank", "compound", "ranksep"};
    private static final String[] GRAPH_CONFIGURATION_ATTRIBUTES = new String[]{"timeline_edge", "timeline_node", "default_node"};
    private JSONObject graph;
    private ArrayList<JSONObject> nodes = new ArrayList();
    private HashMap<String, JSONObject> id2node = new HashMap();
    private ArrayList<JSONObject> edges = new ArrayList();
    private ArrayList<JSONObject> subgraphs = new ArrayList();
    private HashMap<String, JSONObject> id2subgraph = new HashMap();
    private HashSet<String> nested = new HashSet();
    private boolean isranked;
    private String[] ranks;
    private HashMap<Long, ArrayList<JSONObject>> levels = new HashMap();

    public static boolean parse(String string, String string2) {
        JSONObject jSONObject = Json2Dot.file2JObj(string);
        if (jSONObject != null) {
            return Json2Dot.json2Dot(jSONObject, string2);
        }
        return false;
    }

    public static boolean json2Dot(JSONObject jSONObject, String string) {
        try {
            File file = new File(string);
            if (!file.exists() && !file.createNewFile()) {
                System.err.format("Json2Dot.json2Dot: could not create: %s\n", string);
                return false;
            }
            return Json2Dot.translate(jSONObject, file);
        }
        catch (Exception exception) {
            System.err.format("Json2Dot.parse: exception msg was %s  from %s\n", exception.getMessage(), exception);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public static JSONObject file2JObj(String string) {
        try {
            JSONParser jSONParser = new JSONParser();
            File file = new File(string);
            if (!file.exists()) {
                System.err.format("Json2Dot.file2JObj: could not find: %s\n", string);
                return null;
            }
            Object object = jSONParser.parse(new FileReader(file));
            if (object == null) {
                System.err.format("Json2Dot.file2JObj: got null from  %s\n", string);
                return null;
            }
            if (!(object instanceof JSONObject)) {
                System.err.format("Json2Dot.file2JObj: did not get a map from  %s\n", string);
                return null;
            }
            return (JSONObject)object;
        }
        catch (Exception exception) {
            System.err.format("Json2Dot.parse: exception msg was %s  from %s\n", exception.getMessage(), exception);
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static boolean translate(JSONObject jSONObject, File file) {
        Json2Dot json2Dot = new Json2Dot(jSONObject);
        if (!json2Dot.verify()) {
            return false;
        }
        String string = json2Dot.json2dot();
        return Json2Dot.sb2file(string, file);
    }

    private String json2dot() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph ").append(this.graph.get("name")).append(" ").append("{\n");
        this.graphAttrs2Dot(stringBuilder);
        this.ranks2Dot(stringBuilder);
        this.levels2Dot(stringBuilder);
        this.nodes2Dot(stringBuilder);
        this.subgraphs2Dot(stringBuilder);
        this.edges2Dot(stringBuilder);
        stringBuilder.append("\n}\n");
        return stringBuilder.toString();
    }

    private Json2Dot(JSONObject jSONObject) {
        int n = 0;
        boolean bl = false;
        for (Object k : jSONObject.keySet()) {
            Object object;
            JSONObject jSONObject2;
            Object v;
            Object v2 = jSONObject.get(k);
            if (!(v2 instanceof JSONObject) || !((v = (jSONObject2 = (JSONObject)v2).get("type")) instanceof String)) continue;
            String string = (String)v;
            if ("graph".equals(string)) {
                if (this.graph != null) {
                    System.err.format("Json2Dot(): saw more than one graph object, ignoring!\n", new Object[0]);
                    continue;
                }
                this.graph = jSONObject2;
                continue;
            }
            if ("node".equals(string)) {
                object = jSONObject2.get("rank");
                if (object != null) {
                    Long l = this.parseAsLong(object);
                    if (l == null) {
                        System.err.format("Json2Dot(): bad rank %s, ignoring!\n", object);
                    } else {
                        ArrayList<JSONObject> arrayList;
                        int n2 = l.intValue();
                        if (n2 > n) {
                            n = n2;
                        }
                        if ((arrayList = this.levels.get(l)) == null) {
                            arrayList = new ArrayList();
                            this.levels.put(l, arrayList);
                        }
                        arrayList.add(jSONObject2);
                        bl = true;
                    }
                }
                this.nodes.add(jSONObject2);
                this.id2node.put(k.toString(), jSONObject2);
                continue;
            }
            if ("subgraph".equals(string)) {
                object = k.toString();
                this.subgraphs.add(jSONObject2);
                this.id2subgraph.put((String)object, jSONObject2);
                if (((String)object).startsWith("cluster")) continue;
                System.err.format("Warning: subgraph %s does not start with \"cluster\", so it will be invisible\n", object);
                continue;
            }
            if (!"edge".equals(string)) continue;
            this.edges.add(jSONObject2);
        }
        this.ranks = new String[++n];
        this.isranked = bl;
    }

    private Long parseAsLong(Object object) {
        Long l = null;
        if (object instanceof Long) {
            l = (Long)object;
        } else {
            try {
                if (object instanceof String) {
                    return Long.parseLong((String)object);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    private boolean verify() {
        Object object;
        Object object2;
        Object object3;
        if (this.graph == null || this.graph.get("name") == null) {
            System.err.format("Json2Dot.verify: graph has no global graph obect with a name field. %s\n", this.graph);
            return false;
        }
        for (String object42 : GRAPH_CONFIGURATION_ATTRIBUTES) {
            object3 = this.graph.get(object42);
            if (object3 == null || object3 instanceof JSONObject) continue;
            System.err.format("Json2Dot.verify: graph cfg attr %s is not a JSONObject: %s\n", object42, object3);
            return false;
        }
        for (String string : this.id2node.keySet()) {
            JSONObject jSONObject = this.id2node.get(string);
            Object v = jSONObject.get("name");
            if (v == null) {
                jSONObject.put("name", string);
            } else if (!string.equals(v)) {
                System.err.format("Json2Dot.verify: node with nid %s has inconsistent name attr: %s\n", string, v);
                jSONObject.put("name", string);
            }
            if ((object3 = jSONObject.get("rank")) == null) continue;
            Long l = this.parseAsLong(object3);
            if (l != null) {
                object2 = jSONObject.get("ranklab");
                if (!(object2 instanceof String)) continue;
                object = (String)object2;
                int n = l.intValue();
                String string2 = this.ranks[n];
                if (string2 != null) {
                    if (string2.equals(object)) continue;
                    System.err.format("Json2Dot.verify: saw conflicting rank %s labels: %s != %s\n", l, object, n);
                    return false;
                }
                this.ranks[n] = object;
                continue;
            }
            System.err.format("Json2Dot.verify: rank not an ordinal number \"%s\" for node with nid = \"%s\"\n", object3, string);
        }
        for (JSONObject jSONObject : this.subgraphs) {
            Object v = jSONObject.get("nodes");
            if (v instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)v;
                for (Long l : jSONArray) {
                    if (l instanceof String) {
                        object2 = (String)((Object)l);
                        object = this.id2node.get(object2);
                        if (object != null) continue;
                        JSONObject jSONObject2 = this.id2subgraph.get(object2);
                        if (jSONObject2 == null) {
                            System.err.format("Json2Dot.verify: unknown node or subgraph label in nodes array: %s\n", object2);
                            return false;
                        }
                        this.nested.add((String)object2);
                        continue;
                    }
                    System.err.format("Json2Dot.verify: node label in nodes array not a String %s\n", l);
                    return false;
                }
                continue;
            }
            System.err.format("Json2Dot.verify: nodes value not an Array %s\n", v);
            return false;
        }
        for (JSONObject jSONObject : this.edges) {
            if (!this.isNode(jSONObject, "src")) {
                return false;
            }
            if (!this.isNode(jSONObject, "tgt")) {
                return false;
            }
            if (!this.isNullOrSubgraph(jSONObject, "ltail")) {
                return false;
            }
            if (this.isNullOrSubgraph(jSONObject, "lhead")) continue;
            return false;
        }
        return true;
    }

    private boolean isNode(JSONObject jSONObject, String string) {
        Object v = jSONObject.get(string);
        if (v == null || this.id2node.get(v.toString()) == null) {
            System.err.format("Json2Dot.isNode: %s not a known node. src = %s\n", string, v);
            return false;
        }
        return true;
    }

    private boolean isNullOrSubgraph(JSONObject jSONObject, String string) {
        Object v = jSONObject.get(string);
        if (v != null && this.id2subgraph.get(v.toString()) == null) {
            System.err.format("Json2Dot.isNode: %s not a known subgraph. %s = %s\n", string, v);
            return false;
        }
        return true;
    }

    private void val2Dot(StringBuilder stringBuilder, Object object) {
        if (object instanceof String) {
            stringBuilder.append('\"').append(object).append('\"');
        } else {
            stringBuilder.append(object);
        }
    }

    private void graphAttrs2Dot(StringBuilder stringBuilder) {
        for (String string : GRAPH_ATTRIBUTES) {
            Object v = this.graph.get(string);
            if (v == null) continue;
            stringBuilder.append("\t");
            stringBuilder.append(string);
            stringBuilder.append("=");
            this.val2Dot(stringBuilder, v);
            stringBuilder.append(";\n");
        }
    }

    private void ranks2Dot(StringBuilder stringBuilder) {
        if (this.isranked) {
            String string;
            int n;
            JSONObject jSONObject = (JSONObject)this.graph.get("timeline_edge");
            JSONObject jSONObject2 = (JSONObject)this.graph.get("timeline_node");
            stringBuilder.append("\n\t{\n");
            for (n = 0; n < this.ranks.length; ++n) {
                string = this.ranks[n];
                if (string == null) continue;
                stringBuilder.append("\n\t\t");
                this.val2Dot(stringBuilder, string);
                if (jSONObject2 != null) {
                    this.nodeAttrs2Dot(stringBuilder, jSONObject2);
                }
                stringBuilder.append(";");
            }
            stringBuilder.append("\n");
            n = 0;
            while (n < this.ranks.length) {
                string = this.ranks[n];
                if (string != null) {
                    int n2;
                    String string2 = null;
                    for (n2 = n + 1; n2 < this.ranks.length && (string2 = this.ranks[n2]) == null; ++n2) {
                    }
                    if (string2 == null) break;
                    stringBuilder.append("\n\t\t");
                    this.val2Dot(stringBuilder, string);
                    stringBuilder.append(" -> ");
                    this.val2Dot(stringBuilder, string2);
                    if (jSONObject != null) {
                        this.edgeAttrs2Dot(stringBuilder, jSONObject);
                    }
                    stringBuilder.append(";");
                    n = n2;
                    continue;
                }
                ++n;
            }
            stringBuilder.append("\n\t}\n");
        }
    }

    private void levels2Dot(StringBuilder stringBuilder) {
        JSONObject jSONObject = (JSONObject)this.graph.get("default_node");
        if (jSONObject != null) {
            stringBuilder.append("\n\tnode ");
            this.nodeAttrs2Dot(stringBuilder, jSONObject);
            stringBuilder.append(";\n");
        }
        if (this.isranked) {
            for (int i = 0; i < this.ranks.length; ++i) {
                String string = this.ranks[i];
                if (string == null) continue;
                this.level2Dot(string, new Long(i), stringBuilder);
            }
        }
    }

    private void node2Dot(StringBuilder stringBuilder, JSONObject jSONObject) {
        this.val2Dot(stringBuilder, jSONObject.get("name"));
        stringBuilder.append(" ");
        this.nodeAttrs2Dot(stringBuilder, jSONObject);
        stringBuilder.append(";");
    }

    private void level2Dot(String string, Long l, StringBuilder stringBuilder) {
        ArrayList<JSONObject> arrayList = this.levels.get(l);
        if (arrayList == null) {
            System.err.format("Json2Dot.level2Dot: level %s is empty, it should not be\n", l);
            return;
        }
        stringBuilder.append("\n\t{ rank = same; ");
        this.val2Dot(stringBuilder, string);
        for (JSONObject jSONObject : arrayList) {
            stringBuilder.append(" ");
            this.node2Dot(stringBuilder, jSONObject);
        }
        stringBuilder.append(" }\n");
    }

    private void nodes2Dot(StringBuilder stringBuilder) {
        boolean bl = false;
        for (JSONObject jSONObject : this.nodes) {
            if (jSONObject.get("rank") != null) continue;
            stringBuilder.append("\n\t");
            this.node2Dot(stringBuilder, jSONObject);
            bl = true;
        }
        if (bl) {
            stringBuilder.append("\n");
        }
    }

    private void subgraph2Dot(StringBuilder stringBuilder, String string, JSONObject jSONObject) {
        stringBuilder.append("\n\tsubgraph  ");
        stringBuilder.append(string);
        stringBuilder.append(" { ");
        this.subgraphAttrs2Dot(stringBuilder, jSONObject);
        JSONArray jSONArray = (JSONArray)jSONObject.get("nodes");
        for (Object e : jSONArray) {
            if (!(e instanceof String)) continue;
            JSONObject jSONObject2 = this.id2node.get((String)e);
            if (jSONObject2 != null) {
                stringBuilder.append(" ");
                this.val2Dot(stringBuilder, jSONObject2.get("name"));
                stringBuilder.append("; ");
                continue;
            }
            JSONObject jSONObject3 = this.id2subgraph.get((String)e);
            this.subgraph2Dot(stringBuilder, (String)e, jSONObject3);
        }
        stringBuilder.append(" }\n");
    }

    private void subgraphs2Dot(StringBuilder stringBuilder) {
        for (String string : this.id2subgraph.keySet()) {
            if (this.nested.contains(string)) continue;
            JSONObject jSONObject = this.id2subgraph.get(string);
            this.subgraph2Dot(stringBuilder, string, jSONObject);
        }
    }

    private void edge2Dot(StringBuilder stringBuilder, JSONObject jSONObject) {
        JSONObject jSONObject2 = this.id2node.get((String)jSONObject.get("src"));
        JSONObject jSONObject3 = this.id2node.get((String)jSONObject.get("tgt"));
        stringBuilder.append("\n\t");
        this.val2Dot(stringBuilder, jSONObject2.get("name"));
        stringBuilder.append(" -> ");
        this.val2Dot(stringBuilder, jSONObject3.get("name"));
        stringBuilder.append(" ");
        this.edgeAttrs2Dot(stringBuilder, jSONObject);
        stringBuilder.append(";");
    }

    private void edges2Dot(StringBuilder stringBuilder) {
        for (JSONObject jSONObject : this.edges) {
            this.edge2Dot(stringBuilder, jSONObject);
        }
    }

    private void nodeAttrs2Dot(StringBuilder stringBuilder, JSONObject jSONObject) {
        this.attrs2Dot(stringBuilder, NODE_ATTRIBUTES, jSONObject, ',', true);
    }

    private void edgeAttrs2Dot(StringBuilder stringBuilder, JSONObject jSONObject) {
        this.attrs2Dot(stringBuilder, EDGE_ATTRIBUTES, jSONObject, ',', true);
    }

    private void subgraphAttrs2Dot(StringBuilder stringBuilder, JSONObject jSONObject) {
        this.attrs2Dot(stringBuilder, SUBGRAPH_ATTRIBUTES, jSONObject, ';', false);
    }

    private void attrs2Dot(StringBuilder stringBuilder, String[] stringArray, JSONObject jSONObject, char c, boolean bl) {
        boolean bl2 = true;
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string : stringArray) {
            Object v = jSONObject.get(string);
            if (v == null) continue;
            if (!bl2) {
                stringBuilder2.append(c).append(" ");
            } else {
                bl2 = false;
            }
            stringBuilder2.append(string).append("=");
            this.val2Dot(stringBuilder2, v);
        }
        if (!bl2) {
            if (bl) {
                stringBuilder.append("[");
            }
            stringBuilder.append((CharSequence)stringBuilder2);
            if (bl) {
                stringBuilder.append("]");
            } else if (!bl2) {
                stringBuilder.append(c);
            }
        }
    }

    private static boolean sb2file(String string, File file) {
        try {
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.print(string);
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.format("Json2Dot.translate: %s\n", exception.getMessage());
            return false;
        }
        return true;
    }
}

