/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.glyph.Glyph;
import g2d.graph.GraphItem;
import g2d.graph.IOPEdge;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graph.xdotparser.visitor.xDotSubgraph;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class IOPSubgraph
extends GraphItem {
    private static final boolean DEBUG = false;
    public final String name;
    protected boolean topLevel;
    protected final HashSet<Integer> nodes = new HashSet();
    protected final HashSet<Integer> edges = new HashSet();
    protected final HashSet<Integer> subgraphs = new HashSet();
    private Glyph base = new Glyph(new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0), Color.black, null);
    private boolean highlighted = false;
    xDotSubgraph dotRendering;
    private static int subgraphCounter = 0;

    private String nameFromGid() {
        return "anonymous_subgraph_" + this.gid;
    }

    public IOPSubgraph(String string, boolean bl) {
        this.name = string == null ? this.nameFromGid() : string;
        this.topLevel = bl;
    }

    protected IOPSubgraph(IOPGraph iOPGraph, String string, boolean bl, HashSet<Integer> hashSet, HashSet<Integer> hashSet2, HashSet<Integer> hashSet3) {
        this(string, bl);
        for (Integer n : hashSet) {
            this.nodes.add(n);
        }
        for (Integer n : hashSet2) {
            this.edges.add(n);
        }
        for (Integer n : hashSet3) {
            this.subgraphs.add(n);
        }
        this.close(iOPGraph);
    }

    public IOPSubgraph(IOPSubgraph iOPSubgraph) {
        super(iOPSubgraph);
        this.name = iOPSubgraph.name;
        this.topLevel = iOPSubgraph.topLevel;
        this.highlighted = iOPSubgraph.highlighted;
        if (iOPSubgraph.dotRendering != null) {
            this.setRendering(new xDotSubgraph(iOPSubgraph.dotRendering));
        }
        for (Integer n : iOPSubgraph.nodes) {
            this.nodes.add(n);
        }
        for (Integer n : iOPSubgraph.edges) {
            this.edges.add(n);
        }
        for (Integer n : iOPSubgraph.subgraphs) {
            this.subgraphs.add(n);
        }
    }

    public List<IOPNode> getNodes(IOPGraph iOPGraph) {
        ArrayList<IOPNode> arrayList = new ArrayList<IOPNode>();
        if (iOPGraph != null) {
            for (Integer n : this.nodes) {
                GraphItem graphItem = iOPGraph.graphItemsByGid.get(n);
                if (!(graphItem instanceof IOPNode)) continue;
                arrayList.add((IOPNode)graphItem);
            }
        }
        return arrayList;
    }

    public static String gensymSubgraphName(IOPGraph iOPGraph) {
        String string;
        do {
            string = "clusterSubgraph" + subgraphCounter;
            ++subgraphCounter;
        } while (iOPGraph.getSubgraph(string) != null);
        return string;
    }

    private void close(IOPGraph iOPGraph) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        this.flattenNodes(iOPGraph, hashSet);
        this.flattenEdges(iOPGraph, hashSet2);
        for (IOPEdge iOPEdge : iOPGraph.getEdgesInArray()) {
            if (!hashSet.contains(iOPEdge.getSource().gid) || !hashSet.contains(iOPEdge.getSink().gid) || hashSet2.contains(iOPEdge.gid)) continue;
            this.edges.add(iOPEdge.gid);
        }
    }

    public void flatten(IOPGraph iOPGraph, Collection<Integer> collection, Collection<Integer> collection2, Collection<Integer> collection3) {
        collection.addAll(this.nodes);
        collection2.addAll(this.edges);
        collection3.addAll(this.subgraphs);
        for (Integer n : this.subgraphs) {
            IOPSubgraph iOPSubgraph = (IOPSubgraph)iOPGraph.graphItemsByGid.get(n);
            iOPSubgraph.flatten(iOPGraph, collection, collection2, collection3);
        }
    }

    public void flattenNodes(IOPGraph iOPGraph, Collection<Integer> collection) {
        collection.addAll(this.nodes);
        for (Integer n : this.subgraphs) {
            IOPSubgraph iOPSubgraph = (IOPSubgraph)iOPGraph.graphItemsByGid.get(n);
            iOPSubgraph.flattenNodes(iOPGraph, collection);
        }
    }

    public void flattenEdges(IOPGraph iOPGraph, Collection<Integer> collection) {
        collection.addAll(this.edges);
        for (Integer n : this.subgraphs) {
            IOPSubgraph iOPSubgraph = (IOPSubgraph)iOPGraph.graphItemsByGid.get(n);
            iOPSubgraph.flattenEdges(iOPGraph, collection);
        }
    }

    public void setRendering(xDotSubgraph xDotSubgraph2) {
        if (xDotSubgraph2 != null) {
            this.dotRendering = xDotSubgraph2;
            this.updateGlyphList();
        }
    }

    public void addNode(IOPNode iOPNode) {
        if (iOPNode == null) {
            return;
        }
        this.nodes.add(iOPNode.gid);
    }

    public void addEdge(IOPEdge iOPEdge) {
        if (iOPEdge == null) {
            return;
        }
        this.edges.add(iOPEdge.gid);
    }

    public void addSubgraph(IOPSubgraph iOPSubgraph) {
        if (iOPSubgraph == null) {
            return;
        }
        this.subgraphs.add(iOPSubgraph.gid);
    }

    private void updateGlyphList() {
        if (this.dotRendering != null) {
            this.glyphList = this.dotRendering.glyphList;
            this.base = this.dotRendering.base;
        }
    }

    public String getName() {
        return this.name;
    }

    public Point2D getCenter() {
        Rectangle2D rectangle2D = this.base.getBounds();
        return new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
    }

    public void setCenter(Point2D point2D) {
        Point2D point2D2 = this.getCenter();
        this.glyphList.translate(point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY());
    }

    public double getWidth() {
        return this.base.getBounds().getWidth();
    }

    public double getHeight() {
        return this.base.getBounds().getHeight();
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.getBounds().getX(), this.getBounds().getY());
    }

    @Override
    public double distanceTo(Point2D point2D) {
        if (point2D == null) {
            return Double.MAX_VALUE;
        }
        if (this.base.inside(point2D)) {
            return 0.0;
        }
        Rectangle2D rectangle2D = this.base.getBounds();
        return point2D.distance(rectangle2D.getCenterX(), rectangle2D.getCenterY());
    }

    @Override
    public void highlight() {
        super.highlight();
        this.base.setHighlighted(true);
    }

    @Override
    public void dehighlight() {
        super.dehighlight();
        this.base.setHighlighted(false);
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        String string = this.name + "_" + this.gid;
        if (bl) {
            string = string + "\n";
            string = string + " nodes: " + this.nodes + "\n";
            string = string + " edges: " + this.edges + "\n";
            string = string + " subgraphs: " + this.subgraphs + "\n";
        }
        return string;
    }

    public String toDotString(IOPGraph iOPGraph, Collection<IOPNode> collection, Map<Integer, IOPEdge> map) {
        StringBuffer stringBuffer = new StringBuffer();
        IOPSubgraph.toDotStringAux(stringBuffer, this, 0, iOPGraph, collection, map);
        return stringBuffer.toString();
    }

    private static void indentation(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
    }

    private static void toDotStringAux(StringBuffer stringBuffer, IOPSubgraph iOPSubgraph, int n, IOPGraph iOPGraph, Collection<IOPNode> collection, Map<Integer, IOPEdge> map) {
        GraphItem graphItem;
        IOPSubgraph.indentation(stringBuffer, n);
        stringBuffer.append("subgraph ").append(iOPSubgraph.name).append(" {\n");
        for (Integer n2 : iOPSubgraph.subgraphs) {
            graphItem = (IOPSubgraph)iOPGraph.getGraphItemByGid(n2);
            if (graphItem == null) {
                System.err.println("subgraph.toDotStringAux: " + iOPSubgraph.gid + " Didn't find a subgraph with id = " + n2);
                System.err.println("graph.getGraphItemByGid = " + iOPGraph.graphItemsByGid);
                continue;
            }
            IOPSubgraph.toDotStringAux(stringBuffer, (IOPSubgraph)graphItem, n + 1, iOPGraph, collection, map);
        }
        for (Integer n2 : iOPSubgraph.nodes) {
            graphItem = (IOPNode)iOPGraph.getGraphItemByGid(n2);
            if (graphItem == null) {
                System.err.println("subgraph.toDotStringAux: " + iOPSubgraph.gid + " Didn't find an node with id = " + n2);
                continue;
            }
            IOPSubgraph.indentation(stringBuffer, n);
            stringBuffer.append(((IOPNode)graphItem).toDotString());
            collection.remove(graphItem);
        }
        for (Integer n2 : iOPSubgraph.edges) {
            graphItem = (IOPEdge)iOPGraph.getGraphItemByGid(n2);
            if (graphItem == null) {
                System.err.println("subgraph.toDotStringAux: " + iOPSubgraph.gid + " Didn't find an edge with id = " + n2);
                continue;
            }
            IOPSubgraph.indentation(stringBuffer, n);
            stringBuffer.append(((IOPEdge)graphItem).toDotString());
            map.remove(n2);
        }
        IOPSubgraph.indentation(stringBuffer, n);
        stringBuffer.append("}\n");
    }
}

