/*
 * Decompiled with CFR 0.152.
 */
package g2d.graph;

import g2d.graph.Dot;
import g2d.graph.IOPEdge;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graph.IOPSubgraph;
import g2d.graph.xdotparser.visitor.xDotSubgraph;
import g2d.swing.IOPConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class DotParserUtils {
    public static Color DEFAULT_BORDER_COLOR = Color.black;
    public static Color DEFAULT_FILL_COLOR = Color.white;
    public static final boolean NEW_EDGE_RENDERING = true;

    public static Color parseColorAttribute(String string, Color color) {
        Color color2 = color;
        try {
            if (string != null && !"".equals(string)) {
                if ((string = Dot.chopQuotes(string)).matches("\\w*") || string.matches("[\\w;\\.]*:[\\w;\\.]*")) {
                    return color;
                }
                String[] stringArray = string.split(" +");
                color2 = new Color(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        return color2;
    }

    public static Point2D parsePositionAttribute(String string, double d) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        try {
            if (string != null && !"".equals(string)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\",");
                double d2 = Double.parseDouble(stringTokenizer.nextToken());
                double d3 = Double.parseDouble(stringTokenizer.nextToken());
                double_ = new Point2D.Double(d2, d - d3);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        return double_;
    }

    public static double parseDimensionAttribute(String string) {
        double d = 0.0;
        try {
            if (string != null && !"".equals(string)) {
                string = Dot.chopQuotes(string);
                d = IOPConstants.inchesToPoints(Double.parseDouble(string));
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        return d;
    }

    public static int parseIntegerAttribute(String string) {
        int n = 1;
        try {
            if (string != null && !"".equals(string)) {
                string = Dot.chopQuotes(string);
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        return n;
    }

    public static Dimension parseBoundingBoxAttribute(String string) {
        Dimension dimension = new Dimension();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\",");
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            double d = Double.parseDouble(stringTokenizer.nextToken());
            double d2 = Double.parseDouble(stringTokenizer.nextToken());
            dimension.setSize(d, d2);
        }
        return dimension;
    }

    public static IOPSubgraph parseSubgraphAttributes(IOPSubgraph iOPSubgraph, String string, HashMap<String, String> hashMap, double d) {
        String string2 = hashMap.get("_draw_");
        String string3 = hashMap.get("_ldraw_");
        xDotSubgraph xDotSubgraph2 = null;
        if (string2 != null || string3 != null) {
            xDotSubgraph2 = new xDotSubgraph(string2, string3, (int)d);
        }
        iOPSubgraph.setRendering(xDotSubgraph2);
        return iOPSubgraph;
    }

    public static IOPNode parseNodeAttributes(IOPGraph iOPGraph, IOPNode iOPNode, String string, HashMap<String, String> hashMap, double d, HashMap<String, String> hashMap2) {
        String string2 = hashMap.get("pos");
        Point2D point2D = DotParserUtils.parsePositionAttribute(string2, d);
        String string3 = hashMap.get("width");
        double d2 = DotParserUtils.parseDimensionAttribute(string3);
        String string4 = hashMap.get("height");
        double d3 = DotParserUtils.parseDimensionAttribute(string4);
        String string5 = hashMap.get("fillcolor");
        Color color = DotParserUtils.parseColorAttribute(string5, DEFAULT_FILL_COLOR);
        String string6 = hashMap.get("color");
        Color color2 = DotParserUtils.parseColorAttribute(string6, DEFAULT_BORDER_COLOR);
        String string7 = hashMap.get("label");
        String string8 = hashMap.get("_draw_");
        String string9 = hashMap.get("_ldraw_");
        int n = DotParserUtils.parseIntegerAttribute(hashMap.get("peripheries"));
        String string10 = hashMap.get("shape");
        if (hashMap2 != null && string10 == null) {
            string10 = hashMap2.get("shape");
        }
        if (iOPNode == null) {
            if (string7 != null) {
                string7 = Dot.chopQuotes(string7);
            }
            iOPNode = new IOPNode(string, string7, string10, color2, color, n, true);
        }
        if (iOPNode != null) {
            iOPNode.setDotLayout(iOPGraph, point2D, d2, d3, string8, string9, d);
        }
        return iOPNode;
    }

    public static IOPNode parseNodeAttributes(IOPGraph iOPGraph, IOPNode iOPNode, String string, HashMap<String, String> hashMap, double d) {
        return DotParserUtils.parseNodeAttributes(iOPGraph, iOPNode, string, hashMap, d, null);
    }

    public static boolean parseEdgeAttributes(IOPEdge iOPEdge, HashMap<String, String> hashMap, double d) {
        String string = hashMap.get("_draw_");
        String string2 = hashMap.get("_ldraw_");
        String string3 = hashMap.get("_hdraw_");
        String string4 = hashMap.get("_tdraw_");
        String string5 = hashMap.get("_hldraw_");
        String string6 = hashMap.get("_tldraw_");
        return DotParserUtils.parseEdgeAttributes(iOPEdge, string, string2, string3, string4, string5, string6, d);
    }

    public static boolean parseEdgeAttributes(IOPEdge iOPEdge, String string, String string2, String string3, String string4, String string5, String string6, double d) {
        boolean bl = true;
        if (iOPEdge != null) {
            iOPEdge.setDotLayout(string, string2, string3, string4, string5, string6, d);
        }
        return bl;
    }

    public static boolean parseEdgeAttributes(IOPEdge iOPEdge, String string, String string2, String string3, double d) {
        boolean bl = false;
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        Point2D.Double double_ = null;
        Point2D.Double double_2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \"");
        String string4 = stringTokenizer.nextToken();
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        double d3 = d - Double.parseDouble(stringTokenizer.nextToken());
        if ("e".equals(string4)) {
            double_2 = new Point2D.Double(d2, d3);
        }
        if ("s".equals(string4)) {
            double_ = new Point2D.Double(d2, d3);
        }
        if ("both".equalsIgnoreCase(string2)) {
            string4 = stringTokenizer.nextToken();
            d2 = Double.parseDouble(stringTokenizer.nextToken());
            d3 = d - Double.parseDouble(stringTokenizer.nextToken());
            if ("e".equals(string4)) {
                double_2 = new Point2D.Double(d2, d3);
            }
            if ("s".equals(string4)) {
                double_ = new Point2D.Double(d2, d3);
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            d2 = Double.parseDouble(stringTokenizer.nextToken());
            d3 = d - Double.parseDouble(stringTokenizer.nextToken());
            arrayList.add(new Point2D.Double(d2, d3));
        }
        if (string3 != null) {
            iOPEdge.setStyle(string3);
        }
        iOPEdge.updatePoints(arrayList, double_, double_2);
        return bl;
    }
}

