/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyphviewer;

import g2d.swing.IOPFileChooser;
import g2d.util.BrowserLauncher;
import g2d.util.IO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class TabInfo
extends JPanel {
    private JLabel label;
    private JEditorPane editorpane;
    private BrowserLauncher launcher;
    private HyperlinkListener linklistener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            try {
                URL uRL;
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (uRL = hyperlinkEvent.getURL()) != null) {
                    TabInfo.this.launcher.openURLinBrowser(uRL.toString());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    };

    public TabInfo(Font font) {
        this.launcher = new BrowserLauncher();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.setOpaque(false);
        jPanel.setOpaque(false);
        jPanel2.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.label = new JLabel(" ");
        this.label.setFont(font);
        jPanel.add(this.label);
        jPanel2.add(this.makeSaveButton());
        this.editorpane = new JEditorPane();
        this.editorpane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.editorpane.setFont(font);
        this.editorpane.setEditable(false);
        this.editorpane.addHyperlinkListener(this.linklistener);
        JScrollPane jScrollPane = new JScrollPane(this.editorpane);
        jScrollPane.setBackground(Color.white);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "South");
    }

    public void setHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.editorpane.removeHyperlinkListener(this.linklistener);
        this.linklistener = hyperlinkListener;
        this.editorpane.addHyperlinkListener(this.linklistener);
    }

    public void displayText(String string, String string2) {
        this.label.setText(string);
        if (string2 != null && string2.trim().startsWith("<html>")) {
            this.editorpane.setContentType("text/html");
        } else {
            this.editorpane.setContentType("text/plain");
        }
        this.editorpane.setText(string2);
        this.revalidate();
    }

    public void toFile(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.label.getText()).append("\n").append(this.editorpane.getText()).append("\n");
        IO.string2File(stringBuffer.toString(), file);
    }

    private JButton makeSaveButton() {
        JButton jButton = new JButton(new SaveAction());
        jButton.setOpaque(false);
        jButton.setToolTipText("Save info to a file");
        return jButton;
    }

    class SaveAction
    extends AbstractAction {
        private final IOPFileChooser chooser;

        public SaveAction() {
            super("Save");
            this.chooser = new IOPFileChooser("raw_text_area");
            this.chooser.setDialogTitle("Save info to File");
            this.chooser.setMultiSelectionEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.chooser.situate();
            JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(TabInfo.this);
            int n = this.chooser.showDialog(jFrame, "Save");
            if (n != 0) {
                return;
            }
            TabInfo.this.toFile(this.chooser.getSelectedFile());
        }
    }
}

