/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyphviewer;

import g2d.glyphviewer.GlyphPanel;
import g2d.swing.ZoomListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.MouseInputListener;

public class NavPanel
extends JPanel
implements ZoomListener,
MouseInputListener {
    public static final int NAV_MAX_WIDTH = 200;
    public static final int NAV_MAX_HEIGHT = 200;
    public static boolean debug = false;
    private final GlyphPanel glyphPanel;
    private BufferedImage image = null;
    private Image thumbNail = null;
    private Dimension containerSize;
    private Insets insets = new Insets(0, 0, 0, 0);
    private AffineTransform scaleToThumb;
    private AffineTransform translateToThumb;
    private AffineTransform scaleFromThumb;
    private AffineTransform translateFromThumb;
    private Rectangle porthole;
    private Point prevpoint = null;
    private static int counter = 0;
    public final int id = counter++;

    public NavPanel(GlyphPanel glyphPanel) {
        this(glyphPanel, 200, 200);
    }

    public NavPanel(GlyphPanel glyphPanel, int n, int n2) {
        this.glyphPanel = glyphPanel;
        this.containerSize = new Dimension(n, n2);
        this.setMinimumSize(new Dimension(150, 100));
        this.setPreferredSize(this.containerSize);
        this.setImage(null);
        glyphPanel.addZoomListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public String toString() {
        String string = "NavPanel_" + this.id;
        if (debug) {
            string = string + " : " + super.toString();
        }
        return string;
    }

    public void resizeThumb(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException("Cannot resize thumb nail to size NULL.");
        }
        this.containerSize = dimension;
        Dimension dimension2 = this.getPreferredSize();
        if (this.thumbNail == null) {
            Container container;
            this.makeThumbNail();
            if (this.thumbNail != null && (container = this.glyphPanel.getParent()) instanceof JViewport) {
                JViewport jViewport = (JViewport)container;
                this.setPorthole(jViewport.getViewRect());
            }
        }
        if (this.thumbNail != null) {
            boolean bl = true;
            double d = (double)dimension2.width / (double)dimension2.height;
            if (new Rectangle(dimension).contains(new Rectangle(dimension2))) {
                if (d < 1.0) {
                    if (dimension2.height == dimension.height) {
                        bl = false;
                    } else if (dimension2.width == dimension.width) {
                        bl = false;
                    }
                } else if (dimension2.width == dimension.width) {
                    bl = false;
                } else if (dimension2.width == dimension.width) {
                    bl = false;
                }
            }
            if (bl) {
                Rectangle rectangle = this.transformPortholeToOrig();
                this.makeThumbNail();
                if (rectangle != null) {
                    this.setPorthole(rectangle);
                }
            }
        } else {
            this.setPreferredSize(this.containerSize);
        }
        this.revalidate();
        this.repaint();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.makeThumbNail();
        this.revalidate();
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeThumbNail() {
        try {
            if (this.image != null) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createMatteBorder(4, 4, 4, 4, Color.WHITE)));
                this.insets = this.getBorder().getBorderInsets(this);
                int n = this.containerSize.width - this.insets.left - this.insets.right;
                int n2 = this.containerSize.height - this.insets.top - this.insets.bottom;
                n = n < 10 ? 10 : n;
                int n3 = n2 = n2 < 10 ? 10 : n2;
                if (n > 0 && n2 > 0) {
                    int n4;
                    Image image = null;
                    int n5 = this.image.getHeight();
                    int n6 = this.image.getWidth();
                    MediaTracker mediaTracker = new MediaTracker(this);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    double d = (double)n6 / (double)n5;
                    double d2 = (double)n / (double)n2;
                    if (d2 < d) {
                        n4 = Math.min(n, n6);
                        image = this.image.getScaledInstance(n4, -1, 4);
                    } else {
                        n4 = Math.min(n2, n5);
                        image = this.image.getScaledInstance(-1, n4, 4);
                    }
                    mediaTracker.addImage(image, 0);
                    try {
                        mediaTracker.waitForID(0);
                        if (mediaTracker.isErrorID(0)) {
                            throw new IllegalArgumentException("makeThumbNail: Tracker Unhappy");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println(interruptedException);
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                    int n7 = image.getWidth(null) + this.insets.left + this.insets.right;
                    int n8 = image.getHeight(null) + this.insets.top + this.insets.bottom;
                    Dimension dimension = new Dimension(n7, n8);
                    this.setPreferredSize(dimension);
                    this.thumbNail = image;
                } else {
                    this.thumbNail = null;
                }
            } else {
                this.setBorder(null);
                this.insets = new Insets(0, 0, 0, 0);
                this.thumbNail = null;
            }
            this.updateScaleTransformations();
            this.updateTranslateTransformations();
        }
        catch (Exception exception) {
            System.err.println("makeThumbNail: " + exception);
            exception.printStackTrace();
        }
    }

    public void setPorthole(Rectangle rectangle) {
        if (rectangle == null) {
            this.porthole = null;
            this.repaint();
            return;
        }
        if (this.scaleToThumb == null || this.translateToThumb == null) {
            return;
        }
        Shape shape = this.scaleToThumb.createTransformedShape(rectangle);
        shape = this.translateToThumb.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape.getBounds2D();
        this.makePorthole(rectangle2D);
        this.repaint();
    }

    private void makePorthole(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        }
        this.porthole = new Rectangle((int)Math.floor(rectangle2D.getX()), (int)Math.floor(rectangle2D.getY()), (int)Math.floor(rectangle2D.getWidth()), (int)Math.floor(rectangle2D.getHeight()));
    }

    private void movePorthole(Point point) {
        if (this.prevpoint != null) {
            int n = point.x - this.prevpoint.x;
            int n2 = point.y - this.prevpoint.y;
            this.porthole.translate(n, n2);
            this.prevpoint = point;
        }
    }

    private Rectangle transformPortholeToOrig() {
        if (this.porthole != null && this.translateFromThumb != null && this.scaleFromThumb != null) {
            Shape shape = this.translateFromThumb.createTransformedShape(this.porthole);
            shape = this.scaleFromThumb.createTransformedShape(shape);
            return shape.getBounds();
        }
        return null;
    }

    private void updateScaleTransformations() {
        if (this.glyphPanel != null && this.thumbNail != null) {
            Dimension dimension = this.glyphPanel.getGlyphSize();
            double d = (double)this.thumbNail.getWidth(null) / (double)dimension.width;
            double d2 = (double)this.thumbNail.getHeight(null) / (double)dimension.height;
            this.scaleToThumb = AffineTransform.getScaleInstance(d, d2);
            this.scaleFromThumb = AffineTransform.getScaleInstance(1.0 / d, 1.0 / d2);
        } else {
            this.scaleToThumb = null;
            this.scaleFromThumb = null;
        }
    }

    private void updateTranslateTransformations() {
        if (!new Insets(0, 0, 0, 0).equals(this.insets)) {
            this.translateToThumb = AffineTransform.getTranslateInstance(this.insets.left, this.insets.right);
            try {
                this.translateFromThumb = this.translateToThumb.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        } else {
            this.translateToThumb = null;
            this.translateFromThumb = null;
        }
    }

    @Override
    public synchronized void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.thumbNail != null) {
            graphics.drawImage(this.thumbNail, this.insets.left, this.insets.top, Color.white, null);
            if (this.porthole != null) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                if (this.prevpoint != null) {
                    graphics2D.setColor(Color.GRAY);
                } else {
                    graphics2D.setColor(Color.RED);
                }
                graphics2D.draw(this.porthole);
                graphics2D.dispose();
            }
        }
    }

    @Override
    public void zoomChanged(double d) {
        this.updateScaleTransformations();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.porthole != null) {
            this.prevpoint = this.porthole.contains(point) ? point : null;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.porthole != null) {
            if (this.prevpoint == null) {
                this.porthole.setLocation(mouseEvent.getPoint());
                this.porthole.translate(-this.porthole.width / 2, -this.porthole.height / 2);
            } else {
                this.movePorthole(mouseEvent.getPoint());
                this.prevpoint = null;
            }
            this.repaint();
            Rectangle rectangle = this.transformPortholeToOrig();
            if (rectangle != null) {
                this.glyphPanel.scrollRectToVisible(rectangle);
            }
        }
        this.prevpoint = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.porthole != null) {
            this.movePorthole(mouseEvent.getPoint());
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

