/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyphviewer;

import g2d.glyph.BufferedGlyphList;
import g2d.glyphviewer.GlyphPanel;
import g2d.glyphviewer.NavPanel;
import g2d.glyphviewer.SEPanel;
import g2d.glyphviewer.StatusBar;
import g2d.glyphviewer.ToolBar;
import g2d.tabwin.TabPanel;
import g2d.tabwin.menus.FileMenu;
import g2d.tabwin.menus.ViewMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GlyphView
extends TabPanel
implements ChangeListener {
    public BufferedGlyphList glyphs;
    public final ToolBar toolBar;
    public final GlyphPanel glyphPanel;
    public final JScrollPane scrollGlyphs;
    public final NavPanel navPanel;
    public final SEPanel sePanel;
    public final StatusBar statusBar;
    public final JMenu fileMenu;
    public final JMenu viewMenu;
    private static int counter = 0;
    public final int id = counter++;
    public static boolean debug = false;

    public GlyphView(BufferedGlyphList bufferedGlyphList, String string, String string2) {
        super(string, string2);
        this.glyphPanel = new GlyphPanel();
        this.scrollGlyphs = new JScrollPane(this.glyphPanel);
        this.navPanel = new NavPanel(this.glyphPanel);
        this.sePanel = new SEPanel(this);
        this.statusBar = new StatusBar("Status: ");
        this.fileMenu = new FileMenu();
        this.viewMenu = new ViewMenu(this);
        this.toolBar = new ToolBar(this.glyphPanel);
        this.setToolBar(this.toolBar);
        this.addMenus();
        this.addWestPanel();
        this.addNorthEastPanel();
        this.addSouthEastPanel();
        this.add((Component)this.statusBar, "South");
        this.setGlyphs(bufferedGlyphList);
    }

    private void addMenus() {
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public String toString() {
        String string = "GlyphPanel_" + this.id;
        if (debug) {
            string = string + " : " + super.toString();
        }
        return string;
    }

    public synchronized void setStatus(String string) {
        this.statusBar.setStatus(string);
    }

    public synchronized void setStatus(String string, boolean bl) {
        this.statusBar.setStatus(string, bl);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JViewport) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            Dimension dimension = jViewport.getExtentSize();
            Dimension dimension2 = jViewport.getViewSize();
            if (dimension2.width <= dimension.width && dimension2.height <= dimension.height) {
                this.navPanel.setPorthole(null);
                return;
            }
            this.navPanel.setPorthole(jViewport.getViewRect());
        } else if (object instanceof BufferedGlyphList) {
            this.resetGlyphs();
            this.sePanel.stateChanged(changeEvent);
        }
    }

    public void resetGlyphs() {
        try {
            this.glyphPanel.resetGlyphs();
            if (this.glyphs != null) {
                this.navPanel.setImage(this.glyphs.getBufferedImage());
            } else {
                this.navPanel.setImage(null);
            }
            this.stateChanged(new ChangeEvent(this.scrollGlyphs.getViewport()));
            this.repaint();
        }
        catch (Exception exception) {
            System.err.println("resetGlyphs: " + exception);
            exception.printStackTrace();
        }
    }

    public void setGlyphs(BufferedGlyphList bufferedGlyphList) {
        if (this.glyphs != null) {
            this.glyphs.removeChangeListener(this);
        }
        this.glyphs = bufferedGlyphList;
        if (this.glyphs != null) {
            this.glyphs.addChangeListener(this);
        }
        this.glyphPanel.setGlyphs(bufferedGlyphList);
        this.resetGlyphs();
    }

    private void addWestPanel() {
        this.scrollGlyphs.setBackground(Color.white);
        this.scrollGlyphs.getViewport().setScrollMode(1);
        this.scrollGlyphs.getViewport().addChangeListener(this);
        this.setPanel(TabPanel.Panel.WEST, this.scrollGlyphs);
    }

    private void addNorthEastPanel() {
        final JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.navPanel, new GridBagConstraints());
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GlyphView.this.navPanel.resizeThumb(jPanel.getSize());
            }
        });
        this.setPanel(TabPanel.Panel.NORTHEAST, jPanel);
    }

    private void addSouthEastPanel() {
        this.setPanel(TabPanel.Panel.SOUTHEAST, this.sePanel);
    }
}

