/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyph;

import g2d.glyph.Glyph;
import g2d.swing.IOPConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TextGlyph
extends Glyph {
    public static boolean debug = false;
    private String text = "";
    private int fontsize = 10;
    private String font = "Lucinda Sans";
    private Color textColor = IOPConstants.TEXTCOLOR;

    public TextGlyph(TextGlyph textGlyph) {
        super(textGlyph);
        this.text = textGlyph.text;
        this.font = textGlyph.font;
        this.textColor = textGlyph.textColor;
    }

    public TextGlyph(String string) {
        this.text = string;
        this.setGlyph(this.textShape(), this.textColor, this.textColor);
    }

    public TextGlyph(String string, int n) {
        this.text = string;
        this.fontsize = n;
        this.setGlyph(this.textShape(), this.textColor, this.textColor);
    }

    public TextGlyph(String string, int n, String string2) {
        this.text = string;
        this.fontsize = n;
        this.font = string2;
        this.setGlyph(this.textShape(), this.textColor, this.textColor);
    }

    public TextGlyph(String string, int n, String string2, Color color) {
        this.text = string;
        this.fontsize = n;
        this.font = string2;
        this.textColor = color;
        this.setGlyph(this.textShape(), this.textColor, this.textColor);
    }

    public void setText(String string) {
        this.text = string;
        this.setShape(this.textShape());
    }

    public void setText(String string, int n) {
        this.text = string;
        this.fontsize = n;
        this.setShape(this.textShape());
    }

    public String getText() {
        return this.text;
    }

    public void updateText(String string) {
        this.text = string;
        this.setShape(this._transform.createTransformedShape(this.textShape()));
    }

    public void setFontsize(int n) {
        this.fontsize = n;
        this.setShape(this.textShape());
    }

    public int getFontsize() {
        return this.fontsize;
    }

    public void setFont(String string) {
        this.font = string;
        this.setShape(this.textShape());
    }

    public String getFont() {
        return this.font;
    }

    public void setSize(int n) {
        this.setFontsize(n);
    }

    public void setTextColor(Color color) {
        this.textColor = color;
        this.setBorder(this.textColor);
        this.setFill(this.textColor);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    private Shape textShape() {
        if (this.text == null || "".equals(this.text)) {
            return null;
        }
        TextLayout textLayout = new TextLayout(this.text, new Font(this.font, 0, this.fontsize), new FontRenderContext(null, false, false));
        return textLayout.getOutline(new AffineTransform());
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = this.getFill();
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(this.getShape());
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void alignCenter(Rectangle2D rectangle2D) {
        double d = this.getBounds().getWidth();
        double d2 = this.getBounds().getHeight();
        double d3 = this.getBounds().getX();
        double d4 = this.getBounds().getY();
        double d5 = rectangle2D.getWidth();
        double d6 = rectangle2D.getHeight();
        double d7 = rectangle2D.getX();
        double d8 = rectangle2D.getY();
        double d9 = (d6 - d2) / 2.0;
        double d10 = (d5 - d) / 2.0;
        double d11 = d7 + d10 - d3;
        double d12 = d8 + d9 - d4;
        this.translate(d11, d12);
    }

    public void alignLeft(Rectangle2D rectangle2D) {
        double d = this.getBounds().getX();
        double d2 = rectangle2D.getX();
        double d3 = 0.0;
        this.translate(d2 + d3 - d, 0.0);
    }

    public void alignRight(Rectangle2D rectangle2D) {
        double d = this.getBounds().getWidth();
        double d2 = this.getBounds().getX();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getX();
        double d5 = d3 - d;
        this.translate(d4 + d5 - d2, 0.0);
    }

    public void alignTop(Rectangle2D rectangle2D) {
        double d = this.getBounds().getY();
        double d2 = rectangle2D.getY();
        double d3 = 0.0;
        this.translate(0.0, d2 + d3 - d);
    }

    public void alignOnTop(Rectangle2D rectangle2D) {
        double d = this.getBounds().getHeight();
        double d2 = this.getBounds().getY();
        double d3 = rectangle2D.getY();
        double d4 = 0.0;
        this.translate(0.0, d3 + d4 - d2 - d);
    }

    public void alignBottom(Rectangle2D rectangle2D) {
        double d = this.getBounds().getHeight();
        double d2 = this.getBounds().getY();
        double d3 = rectangle2D.getHeight();
        double d4 = rectangle2D.getY();
        double d5 = d3 - d;
        this.translate(0.0, d4 + d5 - d2);
    }

    public void alignToPoint(Point2D point2D) {
        double d = this.getBounds().getCenterX();
        double d2 = this.getBounds().getCenterY();
        this.translate(point2D.getX() - d, point2D.getY() - d2);
    }

    public void alignToDotPoint(Point2D point2D, int n) {
        double d = this.getBounds().getHeight() / 2.0;
        switch (n) {
            case 0: {
                double d2 = this.getBounds().getCenterX();
                double d3 = this.getBounds().getCenterY();
                this.translate(point2D.getX() - d2, point2D.getY() - d3 - d);
                break;
            }
            case -1: {
                double d4 = this.getBounds().getX();
                double d5 = this.getBounds().getY();
                this.translate(point2D.getX() - d4, point2D.getY() - d5 - d);
                break;
            }
            case 1: {
                double d6 = this.getBounds().getWidth();
                double d7 = this.getBounds().getX();
                double d8 = this.getBounds().getY();
                this.translate(point2D.getX() - d7 - d6, point2D.getY() - d8 - d);
                break;
            }
        }
    }

    @Override
    public String toString() {
        String string = super.toString();
        if (debug) {
            string = string + " textShape: " + this.textShape().getBounds();
        }
        return string;
    }
}

