/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyph;

import g2d.glyph.Glyphish;
import g2d.util.Image;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.net.URL;

public class ImageGlyph
extends Glyphish {
    public static boolean debug = false;
    public static Object renderingHint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private AffineTransform transform = new AffineTransform();
    private Rectangle bounds;
    private BufferedImage bImage;
    private int interpolationType = 2;

    public ImageGlyph(ImageGlyph imageGlyph) {
        this.bImage = Image.copy(imageGlyph.bImage);
        this.transform = new AffineTransform(imageGlyph.transform);
        this.bounds = new Rectangle(imageGlyph.bounds);
    }

    public ImageGlyph(String string, int n, int n2) {
        this(string);
        this.translate(n, n2);
    }

    public ImageGlyph(String string, int n, int n2, int n3, int n4) {
        this.configureImage(Image.file2Image(string), n, n2, n3, n4);
    }

    public ImageGlyph(String string) {
        this.bImage = Image.file2Image(string);
        this.bounds = new Rectangle(this.bImage.getWidth(), this.bImage.getHeight());
    }

    public ImageGlyph(URL uRL, int n, int n2) {
        this.configureImage(Image.url2Image(uRL), n, n2);
    }

    public ImageGlyph(URL uRL, int n, int n2, int n3, int n4) {
        this.configureImage(Image.url2Image(uRL), n, n2, n3, n4);
    }

    private void configureImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        if (bufferedImage != null) {
            this.bImage = Image.getScaledInstance(bufferedImage, n3, n4, renderingHint, true);
            this.bounds = new Rectangle(this.bImage.getWidth(), this.bImage.getHeight());
            this.translate(n, n2);
            bufferedImage.flush();
        }
    }

    private void configureImage(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage != null) {
            this.bImage = bufferedImage;
            this.bounds = new Rectangle(this.bImage.getWidth(), this.bImage.getHeight());
            this.translate(n, n2);
        }
    }

    private void translate(int n, int n2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        this.transform(affineTransform);
    }

    public int getHeight() {
        return (int)Math.round(this.bounds.getHeight());
    }

    public int getWidth() {
        return (int)Math.round(this.bounds.getWidth());
    }

    @Override
    public boolean inside(Point2D point2D) {
        return this.bounds.contains(point2D);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.bounds.intersects(rectangle2D);
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        AffineTransformOp affineTransformOp = new AffineTransformOp(this.transform, this.interpolationType);
        graphics2D.drawImage(this.bImage, affineTransformOp, 0, 0);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        Shape shape = affineTransform.createTransformedShape(this.bounds);
        this.bounds = shape.getBounds();
        this.transform.preConcatenate(affineTransform);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public String toString() {
        String string = super.toString();
        if (debug) {
            string = string + " " + this.bounds;
        }
        return string;
    }
}

