/*
 * Decompiled with CFR 0.152.
 */
package g2d.glyph;

import g2d.glyph.Glyphish;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class AnimatedGlyph
extends Glyphish {
    private static final boolean DEBUG = false;
    private AffineTransform transform = new AffineTransform();
    private int index = -1;
    private int number = 0;
    private String[] files;
    private String[] views;
    private BufferedImage[] images;
    private Shape[] rects;
    private int interpolationType = 2;

    private void initialize(String string) {
        int n;
        if (string == null) {
            return;
        }
        File file = new File(string);
        this.files = file.list();
        if (this.files == null) {
            return;
        }
        if (this.files.length == 0) {
            return;
        }
        this.index = 0;
        this.number = this.files.length;
        this.views = new String[this.number];
        this.images = new BufferedImage[this.number];
        this.rects = new Rectangle2D[this.number];
        try {
            for (n = 0; n < this.files.length; ++n) {
                File file2 = new File(string + File.separator + this.files[n]);
                this.views[n] = this.files[n].substring(0, this.files[n].indexOf(46));
                this.images[n] = ImageIO.read(file2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (n = 0; n < this.files.length; ++n) {
            this.rects[n] = new Rectangle(this.images[n].getWidth(), this.images[n].getHeight());
        }
    }

    public AnimatedGlyph(String string) {
        this.initialize(string);
    }

    public void increment() {
        this.index = (this.index + 1) % this.number;
    }

    public int getHeight() {
        Shape shape = this.transform.createTransformedShape(this.rects[this.index]);
        return (int)Math.round(shape.getBounds().getHeight());
    }

    public int getWidth() {
        Shape shape = this.transform.createTransformedShape(this.rects[this.index]);
        return (int)Math.round(shape.getBounds().getWidth());
    }

    @Override
    public boolean inside(Point2D point2D) {
        Shape shape = this.transform.createTransformedShape(this.rects[this.index]);
        return shape.contains(point2D);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        Shape shape = this.transform.createTransformedShape(this.rects[this.index]);
        return shape.intersects(rectangle2D);
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        AffineTransformOp affineTransformOp = new AffineTransformOp(this.transform, this.interpolationType);
        graphics2D.drawImage(this.images[this.index], affineTransformOp, 0, 0);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.transform.preConcatenate(affineTransform);
    }

    @Override
    public Rectangle2D getBounds() {
        Shape shape = this.transform.createTransformedShape(this.rects[this.index]);
        return shape.getBounds();
    }
}

