/*
 * Decompiled with CFR 0.152.
 */
package g2d.cpsa;

import g2d.util.IO;
import java.io.File;
import java.io.IOException;

public class Cpsa {
    public static boolean cpsaDebug = true;

    public static String ask(Task task, String string) {
        try {
            File file = File.createTempFile("cpsa", ".in");
            File file2 = File.createTempFile("cpsa", ".out");
            if (cpsaDebug) {
                System.err.println("in = " + file + "\nout = " + file2);
            }
            IO.string2File(string, file);
            if (!Cpsa.query(task, file, file2)) {
                return null;
            }
            String string2 = IO.file2String(file2);
            if (!cpsaDebug) {
                file.delete();
                file2.delete();
            } else {
                IO.err.println("Cpsa leaving cpsa files around!\n");
            }
            return string2;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
    }

    public static boolean query(Task task, File file, File file2) {
        block6: {
            Process process = null;
            String string = task.cmd;
            string = string + " -o " + file2.getPath() + " " + file.getPath();
            try {
                if (cpsaDebug) {
                    IO.err.println(string);
                }
                if ((process = Runtime.getRuntime().exec(string)) == null || !(process instanceof Process)) break block6;
                try {
                    int n = process.waitFor();
                    if (n != 0) {
                        throw new IOException("cpsaProcess wait failed " + n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(interruptedException);
                    return false;
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
                return false;
            }
        }
        return true;
    }

    public static enum Task {
        ANALYSIS("cpsa"),
        GRAPH("cpsagraph"),
        SHAPES("cpsashapes");

        public final String cmd;

        private Task(String string2) {
            this.cmd = string2;
        }
    }
}

