/*
 * Decompiled with CFR 0.152.
 */
package g2d.console;

import g2d.console.Console;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuBar
extends JMenuBar {
    private final Console console;
    private static final int menuMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String[] fileLabels = new String[]{"Open", "Reload", "Save", "Save as", "Search", "Quit"};
    private static final int[] fileKeyCodes = new int[]{79, 82, 83, 87, 70, 81};
    private static final int[] fileKeyMasks = new int[]{menuMask, menuMask, menuMask, menuMask | 1, menuMask, menuMask};
    private final JMenu fileMenu = new JMenu("File");
    private final JMenuItem[] fileItem = new JMenuItem[fileLabels.length];
    private final ActionListener[] fileListeners = new ActionListener[]{new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.loadFile();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.reloadFile();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.saveFile();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.saveFileAs();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.search();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.exit();
        }
    }};
    private static final String[] editLabels = new String[]{"Cut", "Copy", "Paste"};
    private static final int[] editKeyCodes = new int[]{88, 67, 86};
    private static final int[] editKeyMasks = new int[]{menuMask, menuMask, menuMask};
    private final JMenu editMenu = new JMenu("Edit");
    private final JMenuItem[] editItem = new JMenuItem[editLabels.length];
    private final ActionListener[] editListeners = new ActionListener[]{new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.cut();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.copy();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.paste();
        }
    }};
    private static final String[] evaluateLabels = new String[]{"Buffer", "Selected", "Line"};
    private static final int[] evaluateKeyCodes = new int[]{66, 69, 76};
    private static final int[] evaluateKeyMasks = new int[]{menuMask, menuMask, menuMask};
    private final JMenu evaluateMenu = new JMenu("Evaluate");
    private final JMenuItem[] evaluateItem = new JMenuItem[evaluateLabels.length];
    private final ActionListener[] evaluateListeners = new ActionListener[]{new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.evaluate(Console.Command.BUFFER);
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.evaluate(Console.Command.SELECTED);
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.evaluate(Console.Command.LINE);
        }
    }};
    private static final String[] inspectLabels = new String[]{"Buffer", "Selected", "Line"};
    private static final int[] inspectKeyCodes = new int[]{66, 69, 76};
    private static final int inspectMask = menuMask | 1;
    private static final int[] inspectKeyMasks = new int[]{inspectMask, inspectMask, inspectMask};
    private final JMenu inspectMenu = new JMenu("Inspect");
    private final JMenuItem[] inspectItem = new JMenuItem[inspectLabels.length];
    private final ActionListener[] inspectListeners = new ActionListener[]{new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.inspect(Console.Command.BUFFER);
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.inspect(Console.Command.SELECTED);
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.inspect(Console.Command.LINE);
        }
    }};
    private static final String[] viewLabels = new String[]{"Definitions", "UIDs"};
    private static final int[] viewKeyCodes = new int[]{68, 85};
    private static final int[] viewKeyMasks = new int[]{menuMask, menuMask, menuMask};
    private final JMenu viewMenu = new JMenu("View");
    private final JMenuItem[] viewItem = new JMenuItem[viewLabels.length];
    private final ActionListener[] viewListeners = new ActionListener[]{new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.viewDefinitions();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.console.viewUIDs();
        }
    }};

    protected MenuBar(Console console) {
        this.console = console;
        this.initMenu(this.fileItem, fileLabels, fileKeyCodes, fileKeyMasks, this.fileMenu, this.fileListeners);
        this.initMenu(this.editItem, editLabels, editKeyCodes, editKeyMasks, this.editMenu, this.editListeners);
        this.initMenu(this.evaluateItem, evaluateLabels, evaluateKeyCodes, evaluateKeyMasks, this.evaluateMenu, this.evaluateListeners);
        this.initMenu(this.inspectItem, inspectLabels, inspectKeyCodes, inspectKeyMasks, this.inspectMenu, this.inspectListeners);
        this.initMenu(this.viewItem, viewLabels, viewKeyCodes, viewKeyMasks, this.viewMenu, this.viewListeners);
    }

    private void initMenu(JMenuItem[] jMenuItemArray, String[] stringArray, int[] nArray, int[] nArray2, JMenu jMenu, ActionListener[] actionListenerArray) {
        for (int i = 0; i < jMenuItemArray.length; ++i) {
            jMenuItemArray[i] = new JMenuItem(stringArray[i]);
            jMenu.add(jMenuItemArray[i]);
            jMenuItemArray[i].addActionListener(actionListenerArray[i]);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(nArray[i], nArray2[i]);
            jMenuItemArray[i].setAccelerator(keyStroke);
        }
        this.add(jMenu);
    }
}

