/*
 * Decompiled with CFR 0.152.
 */
package g2d.console;

import g2d.console.Console;
import g2d.util.FileChooser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JEditorPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class InputTextArea
extends JEditorPane {
    private String currentFile;
    private final Console console;
    private final FileChooser chooser;

    public InputTextArea(Console console) {
        this.console = console;
        this.chooser = new FileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("JLambda files", "lsp");
        Console.g2d_preferences.manageFileChooser(this.chooser, console.ilk);
        if (console.cwd != null) {
            this.chooser.setCurrentDirectory(console.cwd);
        }
        this.chooser.setFileFilter(fileNameExtensionFilter);
    }

    protected void loadFile() {
        this.console.setStatus("Loading");
        String string = "Loading cancelled";
        int n = this.chooser.showOpenDialog(this.console.parent);
        if (n == 0) {
            File file = this.chooser.getSelectedFile();
            String string2 = file.toString();
            this.loadFile(string2);
            string = "Loaded " + string2;
        }
        this.console.setStatus(string);
    }

    protected void reloadFile() {
        this.console.setStatus("Reloading");
        String string = "Reloading failed; no file set";
        if (this.currentFile != null) {
            this.loadFile(this.currentFile);
            string = "Reloaded " + this.currentFile;
        }
        this.console.setStatus(string);
    }

    protected void loadFile(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            StringBuffer stringBuffer = new StringBuffer();
            this.setText(null);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2).append("\n");
            }
            bufferedReader.close();
            this.setText(new String(stringBuffer));
            this.setCaretPosition(0);
            this.currentFile = string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void saveFile() {
        if (this.currentFile != null) {
            this.saveFileAs(this.currentFile);
        } else {
            this.saveFileAs();
        }
    }

    protected void saveFileAs() {
        int n = this.chooser.showSaveDialog(this);
        if (n == 0) {
            this.saveFileAs(this.chooser.getSelectedFile().toString());
            return;
        }
    }

    protected void saveFileAs(String string) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(string), true);
        }
        catch (IOException iOException) {
            return;
        }
        printWriter.print(this.getText());
        printWriter.close();
        this.console.setStatus("Saved " + string);
    }

    protected void clear() {
        this.setText(null);
    }

    protected void search(String string, boolean bl, boolean bl2) {
        int n;
        String string2 = this.getText();
        if (!bl) {
            string2 = string2.toLowerCase();
            string = string.toLowerCase();
        }
        if ((n = bl2 ? string2.lastIndexOf(string, this.getSelectionStart() - string.length()) : string2.indexOf(string, this.getSelectionEnd())) == -1) {
            if (bl2) {
                this.select(string2.length() - 1, string2.length() - 1);
            } else {
                this.select(0, 0);
            }
            return;
        }
        this.select(n, n + string.length());
    }

    protected String getLine() {
        int n;
        String string = this.getText();
        int n2 = string.length();
        if (string == null || n2 == 0) {
            return null;
        }
        int n3 = this.getCaretPosition();
        int n4 = -1;
        if (n2 > 0 && n3 == n2) {
            --n3;
        }
        if (string.charAt(n3) == '\n' && n3 > 0) {
            n = n3 - 1;
            n4 = n3;
        } else {
            n = n3;
        }
        while (n >= 0 && string.charAt(n) != '\n') {
            --n;
        }
        if (n4 != n3) {
            for (n4 = n3; n4 < n2 && string.charAt(n4) != '\n'; ++n4) {
            }
        }
        if (n4 == n) {
            return null;
        }
        return string.substring(++n, n4);
    }
}

