/*
 * Decompiled with CFR 0.152.
 */
package g2d.closure;

import g2d.jlambda.Attributable;
import g2d.jlambda.Closure;
import g2d.util.IO;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ClosureMouseListener
extends Attributable
implements MouseListener {
    private Closure mouseClickedAction;
    private Closure mouseEnteredAction;
    private Closure mouseExitedAction;
    private Closure mousePressedAction;
    private Closure mouseReleasedAction;

    public void setMouseAction(int n, Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("ClosureMouseListener.setMouseAction: closure arity not 2 -- " + closure);
        } else {
            switch (n) {
                case 500: {
                    this.mouseClickedAction = closure;
                    return;
                }
                case 504: {
                    this.mouseEnteredAction = closure;
                    return;
                }
                case 505: {
                    this.mouseExitedAction = closure;
                    return;
                }
                case 501: {
                    this.mousePressedAction = closure;
                    return;
                }
                case 502: {
                    this.mouseReleasedAction = closure;
                    return;
                }
            }
            IO.err.println("ClosureMouseListener.setMouseAction: unrecognized type -- " + n);
        }
    }

    private void takeAction(Closure closure, MouseEvent mouseEvent) {
        if (closure != null) {
            closure.applyClosure(this, mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.takeAction(this.mouseClickedAction, mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.takeAction(this.mouseEnteredAction, mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.takeAction(this.mouseExitedAction, mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.takeAction(this.mousePressedAction, mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.takeAction(this.mouseReleasedAction, mouseEvent);
    }
}

