/*
 * Decompiled with CFR 0.152.
 */
package g2d;

import g2d.Behavior;
import g2d.jlambda.Closure;
import g2d.jlambda.Constants;
import g2d.jlambda.Debugger;
import g2d.jlambda.Interpreter;
import g2d.jlambda.List;
import g2d.jlambda.SyntaxError;
import g2d.jlambda.antlr4.visitor.ParseError;
import g2d.jlambda.antlr4.visitor.Parser;
import g2d.util.ActorMsg;
import g2d.util.IO;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;

public final class Main {
    public static final boolean isOSX;
    private static String self;
    public static String hostname;
    private static boolean remote;
    private static boolean gadget;
    private final Interpreter engine;
    public static boolean DEBUG;
    public static boolean TRUNCATE;
    public static int SNIP_LENGTH;

    private Main(Interpreter interpreter) {
        this.engine = interpreter == null ? Interpreter.getInterpreter("default") : interpreter;
    }

    public static void main(String[] stringArray) {
        Main main = new Main(null);
        IO.setIO(System.in, System.out, System.err);
        Main.substantiate(stringArray);
        main.readEval();
    }

    public static void main(Socket socket, boolean bl, Interpreter interpreter) {
        Main.main(socket, bl, interpreter, null);
    }

    public static void main(Socket socket, boolean bl, Interpreter interpreter, InputStream inputStream) {
        try {
            Main.main(socket.getInputStream(), new PrintStream(socket.getOutputStream()), bl, interpreter, inputStream);
        }
        catch (Exception exception) {
            IO.err.println(exception);
        }
    }

    public static void main(InputStream inputStream, PrintStream printStream, boolean bl, Interpreter interpreter) {
        Main.main(inputStream, printStream, bl, interpreter, null);
    }

    public static void main(String string, InputStream inputStream, PrintStream printStream, boolean bl, Interpreter interpreter, InputStream inputStream2) {
        hostname = string;
        System.err.println("Host: " + hostname);
        Main.main(inputStream, printStream, bl, interpreter, inputStream2);
    }

    public static void main(InputStream inputStream, PrintStream printStream, boolean bl, Interpreter interpreter, InputStream inputStream2) {
        Main main = new Main(interpreter);
        String[] stringArray = new String[]{"iop_remote_actor"};
        remote = true;
        gadget = bl;
        try {
            Main.substantiate(stringArray);
            if (inputStream2 != null) {
                main.evalCode(inputStream2);
            }
            IO.setIO(inputStream, printStream, System.err);
            main.readEval();
        }
        catch (Exception exception) {
            IO.err.println(exception);
        }
    }

    public static void main(Socket socket, boolean bl) {
        Main.main(socket, bl, null);
    }

    public static void main(Socket socket) {
        Main.main(socket, false, null);
    }

    public static void addBehavior(Closure closure) {
        Behavior.addCallback(closure);
    }

    private void evalCode(InputStream inputStream) {
        ArrayList arrayList = null;
        try {
            arrayList = Parser.parseFromInputStream(inputStream);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        try {
            if (arrayList != null) {
                for (Object e : arrayList) {
                    if (!(e instanceof List)) continue;
                    this.engine.evaluate((List)e);
                }
            }
        }
        catch (ParseError parseError) {
            System.err.println(parseError);
        }
        catch (SyntaxError syntaxError) {
            System.err.println(syntaxError);
        }
    }

    private static void substantiate(String[] stringArray) {
        self = stringArray.length > 0 ? stringArray[0] : "graphics2d";
        Constants.setBinaryDirectory(stringArray.length > 1 ? stringArray[1] : "");
    }

    private void readEval() {
        while (true) {
            if (DEBUG) {
                IO.err.println("Waiting for a message...");
            }
            final ActorMsg actorMsg = ActorMsg.readActorMsg();
            if (DEBUG) {
                IO.err.println("Got a message!");
            }
            if (actorMsg != null && actorMsg.getSender() != null) {
                final String string = actorMsg.getSender();
                final boolean bl = Behavior.isSexpression(actorMsg);
                if (DEBUG) {
                    IO.err.println("Got a message from " + string);
                    if (bl) {
                        IO.err.println("body.length() = " + actorMsg.getBody().length());
                        IO.err.println(actorMsg.toString(TRUNCATE, SNIP_LENGTH));
                        IO.err.flush();
                    } else {
                        IO.err.println("It's for the filemanager!");
                    }
                }
                if (string == null) continue;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!bl) {
                                Behavior.handle(actorMsg);
                            } else {
                                String string3 = actorMsg.getBody();
                                long l = 0L;
                                long l2 = 0L;
                                if (DEBUG) {
                                    IO.err.println("Calling engine.evaluate(body);");
                                    l = System.currentTimeMillis();
                                }
                                if (string3 != null) {
                                    Main.this.engine.evaluate(string3, string);
                                }
                                if (DEBUG) {
                                    l2 = System.currentTimeMillis();
                                    String string2 = "Called engine.evaluate(body);\n";
                                    string2 = string2 + "start = " + l + "\n";
                                    string2 = string2 + "stop = " + l2 + "\n";
                                    if (l != 0L) {
                                        string2 = string2 + " elapsed = " + (l2 - l) + " milisecs";
                                    }
                                    IO.err.println(string2);
                                }
                            }
                        }
                        catch (Exception exception) {
                            Debugger.handle(exception);
                        }
                    }
                }).start();
                continue;
            }
            if (Main.isGadget()) continue;
            IO.err.println("Skipping null message");
        }
    }

    public static final void setBinaryDirectory(String string) {
        Constants.setBinaryDirectory(string);
    }

    public static final String getBinaryDirectory() {
        return Constants.getBinaryDirectory();
    }

    public static final boolean isRemote() {
        return remote;
    }

    public static final boolean isGadget() {
        return gadget;
    }

    public static final void setGadget(boolean bl) {
        gadget = bl;
    }

    public static final void setRemote(boolean bl) {
        remote = bl;
    }

    public static final String getSelf() {
        return self;
    }

    static {
        remote = false;
        gadget = false;
        isOSX = "Mac OS X".equals(System.getProperty("os.name"));
        DEBUG = false;
        TRUNCATE = true;
        SNIP_LENGTH = 100;
    }
}

