/*
 * Decompiled with CFR 0.152.
 */
package g2d;

import g2d.Main;
import g2d.jlambda.Utils;
import g2d.util.ActorMsg;

public class FileManager {
    static boolean isSexpression(ActorMsg actorMsg) {
        ActorMsg.Token token = actorMsg.getNextToken();
        if (token == null) {
            return false;
        }
        byte by = token.byteAt(0);
        return by == 40;
    }

    static boolean isFileManagerRequest(ActorMsg actorMsg) {
        ActorMsg.Token token = actorMsg.getNextToken();
        if (token == null) {
            return false;
        }
        byte by = token.byteAt(0);
        if (by == 40) {
            return false;
        }
        if (by != 114 && by != 119 && by != 97) {
            return false;
        }
        String string = token.toString();
        return "read".equals(string) || "write".equals(string) || "append".equals(string);
    }

    static void handle(ActorMsg actorMsg) {
        ActorMsg.Token token = actorMsg.lastToken;
        if (token == null) {
            return;
        }
        String string = token.toString();
        if (string == null) {
            return;
        }
        ActorMsg.Token token2 = actorMsg.getNextToken();
        String string2 = token2 == null ? null : token2.toString();
        String string3 = actorMsg.getSender();
        String string4 = Main.getSelf();
        if ("read".equals(string)) {
            FileManager.handleRead(actorMsg, string3, string4, string2);
        } else if ("write".equals(string)) {
            FileManager.handleWrite(actorMsg, string3, string4, string2);
        } else if ("append".equals(string)) {
            FileManager.handleAppend(actorMsg, string3, string4, string2);
        } else {
            System.err.println("FileManager.handle: did not understand method '" + string + "'");
        }
    }

    static void handleRead(ActorMsg actorMsg, String string, String string2, String string3) {
        byte[] byArray;
        if (string3 != null && (byArray = Utils.file2Bytes(string3)) != null) {
            ActorMsg.send(string, string2, "contents " + string3 + "\n", byArray);
            return;
        }
        ActorMsg.send(string, string2, "readFailure\n" + string3 + "\n");
    }

    static void handleWrite(ActorMsg actorMsg, String string, String string2, String string3) {
        byte[] byArray;
        if (string3 != null && (byArray = actorMsg.bytesRemaining()) != null && Utils.bytes2File(string3, byArray, false)) {
            ActorMsg.send(string, string2, "writeOK\n" + string3 + "\n");
            return;
        }
        ActorMsg.send(string, string2, "writeFailure\n" + string3 + "\n");
    }

    static void handleAppend(ActorMsg actorMsg, String string, String string2, String string3) {
        byte[] byArray;
        if (string3 != null && (byArray = actorMsg.bytesRemaining()) != null && Utils.bytes2File(string3, byArray, true)) {
            ActorMsg.send(string, string2, "appendOK\n" + string3 + "\n");
            return;
        }
        ActorMsg.send(string, string2, "appendFailure\n" + string3 + "\n");
    }
}

