/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.Editor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuBar
extends JMenuBar {
    private final Editor editor;
    private static final int menuMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String[] fileLabels = new String[]{"Open", "Save", "Save as", "Search", "Quit"};
    private static final int[] fileKeyCodes = new int[]{79, 83, 87, 70, 81};
    private static final int[] fileKeyMasks = new int[]{menuMask, menuMask, menuMask | 1, menuMask, menuMask};
    private final JMenu fileMenu = new JMenu("File");
    private final JMenuItem[] fileItem = new JMenuItem[fileLabels.length];
    private final ActionListener[] fileListeners = new ActionListener[]{new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.loadFile();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.saveFile();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.saveFileAs();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.search();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.exit();
        }
    }};
    private static final String[] editLabels = new String[]{"Cut", "Copy", "Paste"};
    private static final int[] editKeyCodes = new int[]{88, 67, 86};
    private static final int[] editKeyMasks = new int[]{menuMask, menuMask, menuMask};
    private final JMenu editMenu = new JMenu("Edit");
    private final JMenuItem[] editItem = new JMenuItem[editLabels.length];
    private final ActionListener[] editListeners = new ActionListener[]{new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.cut();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.copy();
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.paste();
        }
    }};
    private static final String[] commLabels = new String[]{"Buffer", "Selected", "Line"};
    private static final int[] commKeyCodes = new int[]{66, 72, 76};
    private static final int[] commKeyMasks = new int[]{menuMask, menuMask, menuMask};
    private final JMenu commMenu = new JMenu("Send");
    private final JMenuItem[] commItem = new JMenuItem[commLabels.length];
    private final ActionListener[] commListeners = new ActionListener[]{new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.sendMessage(0);
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.sendMessage(1);
        }
    }, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuBar.this.editor.sendMessage(2);
        }
    }};

    protected MenuBar(Editor editor) {
        this.editor = editor;
        try {
            this.initMenu(this.fileItem, fileLabels, fileKeyCodes, fileKeyMasks, this.fileMenu, this.fileListeners);
            this.initMenu(this.editItem, editLabels, editKeyCodes, editKeyMasks, this.editMenu, this.editListeners);
            this.initMenu(this.commItem, commLabels, commKeyCodes, commKeyMasks, this.commMenu, this.commListeners);
            String[] stringArray = new String[]{"Active", "Calm"};
            JMenu jMenu = new JMenu("UI");
            ButtonGroup buttonGroup = new ButtonGroup();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Active", !Editor.calm);
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.calm = false;
                }
            });
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Calm", Editor.calm);
            jCheckBoxMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.calm = true;
                }
            });
            buttonGroup.add(jCheckBoxMenuItem);
            buttonGroup.add(jCheckBoxMenuItem2);
            jMenu.add(jCheckBoxMenuItem);
            jMenu.add(jCheckBoxMenuItem2);
            this.add(jMenu);
        }
        catch (Exception exception) {
            Editor._e_(exception);
        }
    }

    private void initMenu(JMenuItem[] jMenuItemArray, String[] stringArray, int[] nArray, int[] nArray2, JMenu jMenu, ActionListener[] actionListenerArray) {
        for (int i = 0; i < jMenuItemArray.length; ++i) {
            jMenuItemArray[i] = new JMenuItem(stringArray[i]);
            jMenu.add(jMenuItemArray[i]);
            jMenuItemArray[i].addActionListener(actionListenerArray[i]);
            if (nArray == null || nArray2 == null) continue;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(nArray[i], nArray2[i]);
            jMenuItemArray[i].setAccelerator(keyStroke);
        }
        this.add(jMenu);
    }
}

