/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.Constants;
import GUI.ErrorLogger;
import GUI.InputTextArea;
import GUI.MenuBar;
import GUI.OutputTextArea;
import GUI.RegConnection;
import GUI.Registry;
import GUI.SearchDialog;
import GUI.ToolBar;
import g2d.tabwin.TabPreferences;
import g2d.util.Preferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Editor
extends JPanel {
    public static boolean calm = false;
    public static final int BUFFER = 0;
    public static final int SELECTED = 1;
    public static final int LINE = 2;
    public static final Preferences g2d_preferences;
    private int windowWidth;
    private int windowHeight;
    private final InputTextArea inputTextArea = new InputTextArea(this);
    private final JScrollPane inputPane = new JScrollPane(this.inputTextArea);
    protected final OutputTextArea outputTextArea = new OutputTextArea(this);
    private final JScrollPane outputPane = new JScrollPane(this.outputTextArea);
    private final JSplitPane splitPane = new JSplitPane(0, this.inputPane, this.outputPane);
    private final MenuBar menuBar = new MenuBar(this);
    private final ToolBar toolBar = new ToolBar(this);
    private final JFrame frame;
    protected static ErrorLogger errors;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.windowWidth, this.windowHeight);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.windowWidth = n;
        this.windowHeight = n2;
    }

    protected void addOutputText(String string) {
        this.outputTextArea.addText(string);
    }

    public Editor(String string, String string2, JFrame jFrame) {
        super(new BorderLayout());
        this.frame = jFrame;
        Constants.init();
        int n = new Integer(string2);
        errors = new ErrorLogger("/tmp/iop_" + string + "_java_errors");
        Editor._a_("iop pid = " + string + " port = " + string2);
        RegConnection.setIn2RegPortNumber(n);
        this.outputTextArea.initialize();
        Editor._a_("outputTextArea.initialize(in2RegPortNumber) finished\n");
        this.inputTextArea.initialize();
        Editor._a_("inputTextArea initialized\n");
        g2d_preferences.manageJFrame(jFrame, "IOPGUI");
        JLabel jLabel = new JLabel("Input Window");
        jLabel.setForeground(Color.blue);
        this.inputPane.setColumnHeaderView(jLabel);
        JLabel jLabel2 = new JLabel("Output and Error Window");
        jLabel2.setForeground(Color.blue);
        this.outputPane.setColumnHeaderView(jLabel2);
        this.add((Component)this.splitPane, "Center");
        g2d_preferences.manageJSplitPane(this.splitPane, "IOPGUI");
        this.add((Component)this.toolBar, "First");
        this.outputTextArea.setEditable(false);
        Editor._a_("Editor layout finished\n");
        new Thread(this.outputTextArea).start();
        Editor._a_("outputTextArea thread started\n");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            Editor._e_(exception);
        }
        this.toolBar.initChoice();
        this.splitPane.setResizeWeight(0.75);
        Editor._a_("Editor: " + this.getPreferredSize());
        Editor._a_("Input Pane: " + this.inputPane.getPreferredSize());
        Editor._a_("Input TextArea: " + this.inputTextArea.getPreferredSize());
        Editor._a_("Output Pane: " + this.outputPane.getPreferredSize());
        Editor._a_("Output TextArea: " + this.outputTextArea.getPreferredSize());
        Editor._a_("Split Pane Weight: " + this.splitPane.getResizeWeight());
        this.splitPane.resetToPreferredSizes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAndShowGUI(String string, String string2) {
        try {
            String string3 = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(string3);
            JFrame jFrame = new JFrame("InterOperation Prototype: Version 3424");
            final Editor editor = new Editor(string, string2, jFrame);
            editor.setOpaque(true);
            jFrame.setContentPane(editor);
            jFrame.setJMenuBar(editor.menuBar);
            jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    editor.exit();
                }

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    editor.exit();
                }
            });
            ToolBar toolBar = editor.toolBar;
            synchronized (toolBar) {
                Editor._a_("packing\n");
                jFrame.pack();
                Editor._a_("packed\n");
            }
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            Editor._e_("createAndShowGUI: " + exception);
        }
    }

    public static void main(final String[] stringArray) {
        if (stringArray.length == 2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Editor.createAndShowGUI(stringArray[0], stringArray[1]);
                }
            });
        }
    }

    protected void exit() {
        try {
            RegConnection regConnection = new RegConnection("Editor.exit()");
            regConnection.writeInt(1);
            regConnection.close();
        }
        catch (Exception exception) {
            Editor._a_("Editor.exit: " + exception);
        }
    }

    protected void sendRequest(int n, String string) {
        try {
            RegConnection regConnection = new RegConnection("Editor.sendRequest()");
            regConnection.writeInt(0);
            regConnection.writeInt(this.toolBar.getSelectedIndex());
            regConnection.writeInt(string.length());
            regConnection.writeString(string);
            regConnection.close();
        }
        catch (Exception exception) {
            Editor._a_("Editor.sendRequest: " + exception);
        }
    }

    protected void sendMessage(int n) {
        String string;
        String string2 = null;
        if (n == 0) {
            string2 = this.inputTextArea.getText();
        } else if (n == 1) {
            string2 = this.inputTextArea.getSelectedText();
        } else if (n == 2 && (string = this.inputTextArea.getLine()) != null && !string.equals("")) {
            string2 = string + "\n";
        }
        if (string2 == null || string2.equals("")) {
            Editor._a_("Message is null");
            return;
        }
        Editor._a_("\nMessage = \"" + string2 + "\"");
        this.sendRequest(0, string2);
    }

    protected void updateRegistry(String string) {
        this.toolBar.updateRegistry(string);
    }

    protected void showRegistry() {
        Registry registry = Registry.getRegistry();
        this.outputTextArea.append(registry.toString());
        this.outputTextArea.resetViewToEnd();
    }

    protected void loadFile() {
        this.inputTextArea.loadFile();
    }

    protected void loadFile(String string) {
        this.inputTextArea.loadFile(string);
    }

    protected void saveFile() {
        this.inputTextArea.saveFile();
    }

    protected void saveFileAs() {
        this.inputTextArea.saveFileAs();
    }

    protected void saveFileAs(String string) {
        this.inputTextArea.saveFileAs(string);
    }

    protected void clear() {
        this.inputTextArea.clear();
    }

    protected void cut() {
        this.inputTextArea.cut();
    }

    protected void copy() {
        this.inputTextArea.cut();
    }

    protected void paste() {
        this.inputTextArea.paste();
    }

    protected void calm(boolean bl) {
        calm = bl;
    }

    protected void search() {
        SearchDialog searchDialog = new SearchDialog(this, this.frame);
        searchDialog.setVisible(true);
    }

    protected void search(String string, boolean bl, boolean bl2) {
        this.inputTextArea.search(string, bl, bl2);
    }

    protected static void _a_(String string) {
    }

    protected static void _e_(String string) {
        errors.log(string);
    }

    protected static void _e_(Exception exception) {
        Editor._e_(exception.toString());
    }

    static {
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            try {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IOP");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.err.println("static GUI.Editor block: " + exception);
            }
        }
        g2d_preferences = TabPreferences.g2d_preferences;
    }
}

