/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;

public final class Constants {
    public static final DecimalFormat df = new DecimalFormat("#.####");
    public static final int maxRetries = 5;
    public static final boolean VERBOSE = false;
    public static final String initrc = ".ioprc";
    public static final String localFile = "input.txt";
    public static final int minPort = 8000;
    public static final int maxPort = 9000;
    public static final int SIZE = 64;
    public static final int defaultFontSize = 12;
    public static final String VERSION = "3424";
    public static final int versionNumber;
    public static final char COMMENT = ';';
    public static final String version = "Version 3424";
    public static final String iopLookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String iopWelcome;
    private static String font;
    private static int fontStyle;
    private static int fontSize;
    private static int screenW;
    private static int screenH;

    public static Font iopFont(int n, int n2) {
        return new Font(font, n, n2);
    }

    public static String getFont() {
        return font;
    }

    public static void setFont(String string) {
        font = string;
    }

    public static int getFontStyle() {
        return fontStyle;
    }

    public static void setFontStyle(int n) {
        fontStyle = n;
    }

    public static int getFontSize() {
        return fontSize;
    }

    public static void setFontSize(int n) {
        fontSize = n;
    }

    public static int getHeight() {
        return screenH;
    }

    public static void setHeight(int n) {
        screenH = n;
    }

    public static int getWidth() {
        return screenW;
    }

    public static void setWidth(int n) {
        screenW = n;
    }

    public static void init() {
        Dimension dimension = Constants.minimumScreenSize();
        screenH = 3 * dimension.height / 4;
        screenW = dimension.width / 2;
    }

    private static Dimension minimumScreenSize() {
        int n = -1;
        int n2 = -1;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
            for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                Rectangle rectangle = graphicsConfiguration.getBounds();
                if (n == -1) {
                    n = (int)rectangle.getWidth();
                }
                if ((double)n > rectangle.getWidth()) {
                    n = (int)rectangle.getWidth();
                }
                if (n2 == -1) {
                    n2 = (int)rectangle.getHeight();
                }
                if (!((double)n2 > rectangle.getHeight())) continue;
                n2 = (int)rectangle.getHeight();
            }
        }
        return new Dimension(n, n2);
    }

    private Constants() {
    }

    static {
        int n = 6666;
        try {
            n = Integer.parseInt(VERSION.replace(".", ""));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("g2d.jlambda.Constants: " + numberFormatException.getMessage());
        }
        versionNumber = n;
        iopWelcome = "\n\n\n\n\n\n\tWelcome to the InterOperation Prototype  (IOP)\n\t\n\t\tVersion 3424\n\n\n\tDesigned by:  Ian A. Mason & Carolyn L. Talcott. \n\tWritten by:   Ian A. Mason. \n\tCopyright (C) 2004-2016 Ian A. Mason.\n\tThis is free software, see: \n\thttp://www.gnu.org/licenses/gpl.txt for details.\n\tIOP comes with ABSOLUTEY NO WARRANTY!\n\n\n\n\n\n\t\t" + DateFormat.getDateInstance().format(new Date());
        font = "Lucinda Sans";
        fontStyle = 0;
        fontSize = 12;
        screenW = 0;
        screenH = 0;
    }
}

