/*
 * Decompiled with CFR 0.152.
 */
package rmp;

import java.util.ArrayList;

public class BitmaskHelper {
    private static final int BITS_PER_ELEMENT = 31;

    public static ArrayList<Integer> MASK_TO_INTS(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < nArray.length * 31; ++i) {
            int[] nArray2 = new int[]{i};
            int[] nArray3 = BitmaskHelper.makeBitmask(nArray2, nArray.length * 31);
            if (!BitmaskHelper.EQUALS(BitmaskHelper.AND(nArray3, nArray), nArray3)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public static void UNSETBIT(int[] nArray, int n) {
        int n2 = (int)Math.floor((double)n / 31.0);
        int n3 = n - 31 * n2;
        int n4 = (int)Math.pow(2.0, n3);
        int n5 = n2;
        nArray[n5] = nArray[n5] & ~n4;
    }

    public static int[] NOT(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = ~nArray[i];
        }
        return nArray2;
    }

    public static boolean EQUALS(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] AND(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] & nArray2[i];
        }
        return nArray3;
    }

    public static int[] OR(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] | nArray2[i];
        }
        return nArray3;
    }

    public static int[] makeBitmask(int[] nArray, int n) {
        int n2 = (int)Math.ceil((double)n / 31.0);
        int[] nArray2 = new int[n2];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = 0;
        }
        for (int n3 : nArray) {
            int n4 = (int)Math.floor((double)n3 / 31.0);
            int n5 = n3 - 31 * n4;
            int n6 = (int)Math.pow(2.0, n5);
            int n7 = n4;
            nArray2[n7] = nArray2[n7] | n6;
        }
        return nArray2;
    }
}

