/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pf.util.Association;
import org.pf.util.MapEntry;
import org.pf.util.MapWrapper;
import org.pf.util.Trigger;
import org.pf.util.TriggerClient;

public class TemporaryMap
extends MapWrapper
implements TriggerClient {
    private long expirationTime = 60000L;

    protected long expirationTime() {
        return this.expirationTime;
    }

    protected void expirationTime(long newValue) {
        this.expirationTime = newValue;
    }

    public TemporaryMap(long expiresAfterMs, long checkAfterMs) {
        if (expiresAfterMs < 100L) {
            throw new IllegalArgumentException("expiresAfterMs must be greater than 99 ms");
        }
        if (checkAfterMs < 10L) {
            throw new IllegalArgumentException("checkAfterMs must be greater than 9 ms");
        }
        this.expirationTime(expiresAfterMs);
        Trigger.launch("TemporaryMap.Trigger", this, checkAfterMs);
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        Map.Entry entry = this.findByValue(value);
        if (entry == null) {
            return false;
        }
        Association assoc = (Association)entry.getValue();
        this.touch(assoc);
        return true;
    }

    public Set entrySet() {
        HashSet entries = new HashSet(this.size());
        for (Map.Entry entry : this.internalMap().entrySet()) {
            Association assoc = (Association)entry.getValue();
            this.touch(assoc);
            MapEntry newEntry = new MapEntry(entry.getKey(), assoc.value());
            entries.add(newEntry);
        }
        return entries;
    }

    public Object get(Object key) {
        Object value = this.internalMap().get(key);
        if (value != null) {
            Association assoc = (Association)value;
            this.touch(assoc);
            value = assoc.value();
        }
        return value;
    }

    public Set keySet() {
        this.touchAll();
        return this.internalMap().keySet();
    }

    public Object put(Object key, Object value) {
        Association<Long, Object> assoc = new Association<Long, Object>(this.newTimestamp(), value);
        return this.internalMap().put(key, assoc);
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Collection values() {
        ArrayList values = new ArrayList(this.size());
        for (Association assoc : this.internalMap().values()) {
            this.touch(assoc);
            values.add(assoc.value());
        }
        return values;
    }

    public Object remove(Object key) {
        Association assoc = (Association)this.internalMap().remove(key);
        if (assoc == null) {
            return null;
        }
        return assoc.value();
    }

    public boolean canBeTriggeredBy(Trigger trigger) {
        return true;
    }

    public boolean triggeredBy(Trigger trigger) {
        this.removeExpiredEntries();
        return true;
    }

    protected void touch(Association assoc) {
        assoc.key(this.newTimestamp());
    }

    protected void touchAll() {
        for (Association assoc : this.internalMap().values()) {
            this.touch(assoc);
        }
    }

    protected Long newTimestamp() {
        Long timestamp = new Long(System.currentTimeMillis());
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExpiredEntries() {
        Map map = this.internalMap();
        synchronized (map) {
            Iterator iterator = this.internalMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!this.isExpired((Association)entry.getValue())) continue;
                iterator.remove();
            }
        }
    }

    protected boolean isExpired(Association assoc) {
        long ts = (Long)assoc.key();
        long diff = System.currentTimeMillis() - ts;
        return diff > this.expirationTime();
    }

    protected Map.Entry findByValue(Object value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry entry : this.internalMap().entrySet()) {
            Association assoc = (Association)entry.getValue();
            if (!value.equals(assoc.value())) continue;
            return entry;
        }
        return null;
    }

    protected Map createEmptyMap() {
        return Collections.synchronizedMap(new HashMap());
    }
}

