/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.util.ArrayList;
import java.util.List;
import org.pf.bif.lifecycle.ISystemExitListener;
import org.pf.util.Bool;
import org.pf.util.CollectionUtil;

public class SysUtil {
    public static final String OS_FAMILY_UNKNOWN = "unknown";
    public static final String OS_FAMILY_WINDOWS = "windows";
    public static final String OS_FAMILY_UNIX = "unix";
    public static final String OS_FAMILY_MACINTOSH = "macintosh";
    protected static final String OS_PROPERTY_NAME = "os.name";
    protected static final String PF_OS_PROPERTY_NAME = "org.pf.util.os.name";
    protected static final String SOLARIS = "SOLARIS";
    protected static final String LINUX = "LINUX";
    protected static final String AIX = "AIX";
    protected static final String HP_UX = "HP-UX";
    protected static final String FREE_BSD = "FREEBSD";
    protected static final String[] UNIX_SYSTEMS = new String[]{"SOLARIS", "AIX", "HP-UX", "LINUX", "FREEBSD"};
    private static final String OS_FAMILY = SysUtil.determineOsFamilyName();
    private static final boolean IS_WINDOWS = SysUtil.checkIfWindows();
    private static final SysUtil soleInstance = new SysUtil();
    private Boolean isEclipse = null;
    private List exitListeners = new ArrayList();

    protected List getExitListeners() {
        return this.exitListeners;
    }

    protected void setExitListeners(List newValue) {
        this.exitListeners = newValue;
    }

    public static SysUtil current() {
        return soleInstance;
    }

    protected static boolean checkIfWindows() {
        return OS_FAMILY_WINDOWS.equals(SysUtil.determineOsFamilyName());
    }

    protected static String determineOsFamilyName() {
        String osName = System.getProperty(PF_OS_PROPERTY_NAME);
        if (osName == null) {
            osName = System.getProperty(OS_PROPERTY_NAME, "");
        }
        return SysUtil.determineOsFamilyName(osName);
    }

    protected static String determineOsFamilyName(String operationSystemName) {
        String osName = operationSystemName.toUpperCase();
        if (osName.startsWith("WINDOWS")) {
            return OS_FAMILY_WINDOWS;
        }
        if (osName.startsWith("MAC")) {
            return OS_FAMILY_MACINTOSH;
        }
        if (CollectionUtil.current().indexOf((Object[])UNIX_SYSTEMS, osName) >= 0) {
            return OS_FAMILY_UNIX;
        }
        return OS_FAMILY_UNKNOWN;
    }

    protected SysUtil() {
    }

    public boolean isWindows() {
        return IS_WINDOWS;
    }

    public boolean isEclipse() {
        if (this.isEclipse == null) {
            this.isEclipse = Bool.toBoolean(this.determineIfEclipse());
        }
        return this.isEclipse;
    }

    public boolean isAppletEnvironment() {
        return Bool.isTrue(System.getProperty("java.version.applet"));
    }

    public String getOsFamily() {
        return OS_FAMILY;
    }

    public void sleep(long milliseconds) {
        try {
            Thread.currentThread();
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void exit(int rc) {
        this.notifyExitListeners(rc);
        System.exit(rc);
    }

    public void exit(int rc, long sleepBeforeExit) {
        this.sleep(sleepBeforeExit);
        this.exit(rc);
    }

    public void addSystemExitListener(ISystemExitListener listener) {
        if (listener != null && !this.getExitListeners().contains(listener)) {
            this.getExitListeners().add(listener);
        }
    }

    public void removeSystemExitListener(ISystemExitListener listener) {
        if (listener != null) {
            this.getExitListeners().remove(listener);
        }
    }

    protected void notifyExitListeners(int rc) {
        for (ISystemExitListener listener : this.getExitListeners()) {
            listener.systemAboutToExit(rc);
        }
    }

    protected boolean determineIfEclipse() {
        String option = System.getProperty("org.pf.util.isEclipse");
        if (option != null) {
            return Bool.isTrue(option);
        }
        try {
            this.getClass();
            Class<?> clazz = Class.forName("org.eclipse.core.runtime.Platform");
            return clazz != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void reset() {
        this.isEclipse = null;
    }
}

