/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.pf.bif.filter.IObjectFilter;
import org.pf.util.Association;
import org.pf.util.AssociationList;
import org.pf.util.CollectionUtil;
import org.pf.util.NamedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedValueList<V>
extends AssociationList<String, V> {
    public static final NamedValue[] EMPTY_NAMED_VALUE_ARRAY = new NamedValue[0];

    public NamedValueList() {
    }

    public NamedValueList(Map<String, V> map) {
        super(map);
    }

    public void add(NamedValue<V> namedValue) {
        if (this.isValidAssociation(namedValue)) {
            this.basicAdd(namedValue);
        }
    }

    @Override
    public void add(Association<String, V> association) {
        if (association instanceof NamedValue) {
            this.add((NamedValue)association);
        }
    }

    @Override
    public void add(String name, V value) {
        this.add((NamedValue)this.newElement(name, value));
    }

    public void addAll(NamedValue<V> ... namedValues) {
        if (namedValues != null) {
            int i = 0;
            while (i < namedValues.length) {
                this.add(namedValues[i]);
                ++i;
            }
        }
    }

    public NamedValue<V>[] namedValueArray() {
        return this.namedValueArray(null);
    }

    public NamedValue<V>[] namedValueArray(IObjectFilter filter) {
        Collection result = this.collectElements(filter);
        if (this.collUtil().isNullOrEmpty(result)) {
            return EMPTY_NAMED_VALUE_ARRAY;
        }
        return (NamedValue[])this.collUtil().toArray(result);
    }

    public NamedValue<V> namedValueAt(int index) {
        return (NamedValue)this.associationAt(index);
    }

    public void setNamedValueAt(int index, NamedValue<V> namedValue) {
        this.setAssociationAt(index, namedValue);
    }

    public String nameAt(int index) {
        return this.namedValueAt(index).name();
    }

    public NamedValue<V> findNamedValue(String name) {
        return (NamedValue)this.findAssociation(name);
    }

    public boolean containsName(String name) {
        return this.findAssociation(name) != null;
    }

    public void sort() {
        this.sort(true);
    }

    public void sort(boolean ascending) {
        Object[] elements = this.namedValueArray();
        Arrays.sort(elements);
        if (!ascending) {
            CollectionUtil.current().reverse(elements);
        }
        this.clear();
        this.addAll((NamedValue<V>[])elements);
    }

    @Override
    public V valueAt(String name) {
        return this.findValue(name);
    }

    public NamedValue<V> remove(String name) {
        return (NamedValue)this.removeKey(name);
    }

    public List<String> names() {
        return this.keys();
    }

    @Override
    protected Association newElement(String key, V value) {
        return new NamedValue<V>(key, value);
    }

    @Override
    protected Class elementClass() {
        return NamedValue.class;
    }

    @Override
    protected Class keyClass() {
        return String.class;
    }
}

