/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pf.bif.callback.IObjectProcessor;
import org.pf.bif.filter.IObjectFilter;
import org.pf.util.AAssociationProcessor;
import org.pf.util.Association;
import org.pf.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationList<K, V> {
    public static final Association[] EMPTY_ASSOCIATION_ARRAY = new Association[0];
    private List<Association<K, V>> list = null;

    protected List<Association<K, V>> getList() {
        return this.list;
    }

    protected void setList(List<Association<K, V>> newValue) {
        this.list = newValue;
    }

    public AssociationList() {
        this.clear();
    }

    public AssociationList(Map<K, V> map) {
        this.clear();
        this.addAll(map);
    }

    public void clear() {
        this.setList(new ArrayList<Association<K, V>>());
    }

    public int size() {
        return this.getList().size();
    }

    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    public void add(Association<K, V> association) {
        if (this.isValidAssociation(association)) {
            this.basicAdd(association);
        }
    }

    public void add(K key, V value) {
        this.add(this.newElement(key, value));
    }

    public void addAll(Map<K, V> map) {
        this.addOrPutAll(map, true);
    }

    public void addAll(Properties props) {
        this.addOrPutAll(props, true);
    }

    public void addAll(Association<K, V> ... associations) {
        if (associations != null) {
            int i = 0;
            while (i < associations.length) {
                this.add(associations[i]);
                ++i;
            }
        }
    }

    public Association<K, V>[] associationArray() {
        return this.associationArray(null);
    }

    public Association<K, V>[] associationArray(IObjectFilter filter) {
        Collection<Association<K, V>> result = this.collectElements(filter);
        if (this.collUtil().isNullOrEmpty(result)) {
            return EMPTY_ASSOCIATION_ARRAY;
        }
        return (Association[])this.collUtil().toArray(result);
    }

    public List<Association<K, V>> asList() {
        ArrayList<Association<K, V>> newList = new ArrayList<Association<K, V>>(this.size());
        newList.addAll(this.getList());
        return newList;
    }

    public Hashtable<K, V> asHashtable() {
        Hashtable map = new Hashtable(this.size());
        return (Hashtable)this.addAllToMap(map);
    }

    public HashMap<K, V> asHashMap() {
        HashMap map = new HashMap(this.size());
        return (HashMap)this.addAllToMap(map);
    }

    public Map<K, V> addAllToMap(final Map<K, V> map) {
        AAssociationProcessor processor = new AAssociationProcessor<K, V>(){

            @Override
            public boolean processObject(Association<K, V> association) {
                map.put(association.key(), association.value());
                return true;
            }
        };
        this.processEach(processor);
        return map;
    }

    public void processEach(IObjectProcessor associationProcessor) {
        boolean goOn = true;
        int count = this.getList().size();
        int i = 0;
        while (i < count && goOn) {
            goOn = associationProcessor.processObject(this.getList().get(i));
            ++i;
        }
    }

    public Association<K, V> associationAt(int index) {
        return this.getList().get(index);
    }

    public void setAssociationAt(int index, Association<K, V> associaction) {
        this.getList().set(index, associaction);
    }

    public K keyAt(int index) {
        return this.associationAt(index).key();
    }

    public V valueAt(int index) {
        return this.associationAt(index).value();
    }

    public V valueAt(K key) {
        return this.findValue(key);
    }

    public Association<K, V> findAssociation(K key) {
        if (key != null) {
            for (Association<K, V> assoc : this.getList()) {
                if (!key.equals(assoc.key())) continue;
                return assoc;
            }
        }
        return null;
    }

    public boolean remove(Association<K, V> association) {
        return this.getList().remove(association);
    }

    public Association<K, V> remove(int index) {
        return this.getList().remove(index);
    }

    public Association<K, V> removeKey(K key) {
        Association<K, V> assoc = this.findAssociation(key);
        if (assoc == null) {
            return null;
        }
        if (this.remove(assoc)) {
            return assoc;
        }
        return null;
    }

    public void removeAll(Collection<Association<K, V>> assocCollection) {
        this.getList().removeAll(assocCollection);
    }

    public List<V> values() {
        ArrayList<V> values = new ArrayList<V>(this.size());
        int i = 0;
        while (i < this.size()) {
            values.add(this.valueAt((K)i));
            ++i;
        }
        return values;
    }

    public List<K> keys() {
        ArrayList<K> keys = new ArrayList<K>(this.size());
        int i = 0;
        while (i < this.size()) {
            keys.add(this.keyAt(i));
            ++i;
        }
        return keys;
    }

    public boolean containsKey(K key) {
        return this.findAssociation(key) != null;
    }

    public void put(K key, V value) {
        Association assoc = this.findAssociation(key);
        if (assoc == null) {
            assoc = this.newElement(key, value);
            this.add(assoc);
        } else {
            assoc.value(value);
        }
    }

    public void put(Association<K, V> association) {
        if (!this.isCorrectElementType(association)) {
            return;
        }
        int index = this.indexOf(association.key());
        if (index < 0) {
            this.add(association);
        } else {
            this.getList().set(index, association);
        }
    }

    public void putAll(Association<K, V>[] associations) {
        if (associations != null) {
            int i = 0;
            while (i < associations.length) {
                this.put(associations[i]);
                ++i;
            }
        }
    }

    public void putAll(Map<K, V> map) {
        this.addOrPutAll(map, false);
    }

    public int indexOf(K key) {
        if (key != null) {
            int i = 0;
            while (i < this.size()) {
                Association<K, V> assoc = this.getList().get(i);
                if (key.equals(assoc.key())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected boolean isValidAssociation(Association<K, V> association) {
        return association != null && association.key() != null && association.value() != null && this.isCorrectElementType(association);
    }

    protected void basicAdd(Association<K, V> association) {
        this.getList().add(association);
    }

    protected V findValue(K key) {
        Association<K, V> assoc = this.findAssociation(key);
        if (assoc == null) {
            return null;
        }
        return assoc.value();
    }

    protected void addOrPutAll(Map map, boolean add) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!this.isCorrectKeyType(entry.getKey()) || !this.isCorrectValueType(entry.getValue())) continue;
                if (add) {
                    this.add(entry.getKey(), entry.getValue());
                    continue;
                }
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected boolean isCorrectElementType(Association<K, V> association) {
        return this.elementClass().isInstance(association);
    }

    protected boolean isCorrectKeyType(Object key) {
        return this.keyClass().isInstance(key);
    }

    protected boolean isCorrectValueType(Object value) {
        return this.valueClass().isInstance(value);
    }

    protected Association newElement(K key, V value) {
        return new Association<K, V>(key, value);
    }

    protected Class elementClass() {
        return Association.class;
    }

    protected Class keyClass() {
        return Object.class;
    }

    protected Class<V> valueClass() {
        return Object.class;
    }

    protected Collection<Association<K, V>> collectElements(IObjectFilter filter) {
        Collection<Association<K, V>> result = filter == null ? this.getList() : CollectionUtil.current().copy(this.getList(), filter);
        return result;
    }

    protected CollectionUtil collUtil() {
        return CollectionUtil.current();
    }
}

