/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pf.text.StringUtil;

public class Version {
    private static final int LESS = -1;
    private static final int EQUAL = 0;
    private static final int GREATER = 1;
    private static final String JAVA_VERSION_PROPERTY = "java.version";
    private static final String JAVA_PATCH_SEPARATOR = "_";
    private static final Integer NOT_SET = new Integer(-1);
    public static final String SEPARATOR = ".";
    public static final String SPECIAL_CHARACTERS = "-_";
    private List elements = null;

    protected List getElements() {
        return this.elements;
    }

    protected void setElements(List newValue) {
        this.elements = newValue;
    }

    public static boolean isValidVersion(String str) {
        if (str == null) {
            return false;
        }
        Version version = new Version(str);
        return version.isValid();
    }

    public static Version getJavaVersion() {
        return new Version(System.getProperty(JAVA_VERSION_PROPERTY));
    }

    public static Version getJavaBaseVersion() {
        String versionStr = System.getProperty(JAVA_VERSION_PROPERTY);
        versionStr = StringUtil.current().cutTail(versionStr, JAVA_PATCH_SEPARATOR);
        return new Version(versionStr);
    }

    protected Version() {
        this.setElements(new ArrayList());
    }

    public Version(String versionString) {
        this();
        this.parse(versionString);
    }

    public Version(Version version) {
        this();
        for (VersionElement vElement : version.getElements()) {
            this.getElements().add(vElement.copy());
        }
    }

    public Version(int major, int minor, int micro, String qualifier) {
        this(major, minor, micro);
        this.getElements().add(new VersionElement(qualifier));
    }

    public Version(int major, int minor, int micro) {
        this(major, minor);
        this.addElement(micro);
    }

    public Version(int major, int minor) {
        this(major);
        this.addElement(minor);
    }

    public Version(int major) {
        this();
        this.addElement(major);
    }

    public boolean isGreaterThan(Version version) {
        return this.compareTo(version) == 1;
    }

    public boolean isLessThan(Version version) {
        return this.compareTo(version) == -1;
    }

    public boolean isGreaterThan(String version) {
        return this.isGreaterThan(new Version(version));
    }

    public boolean isLessThan(String version) {
        return this.isLessThan(new Version(version));
    }

    public boolean isGreaterOrEqual(Version version) {
        int result = this.compareTo(version);
        return result == 1 || result == 0;
    }

    public boolean isLessOrEqual(Version version) {
        int result = this.compareTo(version);
        return result == -1 || result == 0;
    }

    public boolean isGreaterOrEqual(String strVersion) {
        return this.isGreaterOrEqual(new Version(strVersion));
    }

    public boolean isLessOrEqual(String strVersion) {
        return this.isLessOrEqual(new Version(strVersion));
    }

    public boolean isEqualTo(String strVersion) {
        if (!Version.isValidVersion(strVersion)) {
            return false;
        }
        Version otherVersion = new Version(strVersion);
        return this.equals(otherVersion);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.compareTo(obj) == 0;
        }
        if (obj instanceof String) {
            return this.compareTo(new Version((String)obj)) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.getElements().size()) {
            hash ^= this.getElements().get(i).hashCode();
            ++i;
        }
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        int i = 0;
        while (i < this.getElements().size()) {
            if (i > 0) {
                buffer.append(SEPARATOR);
            }
            buffer.append(this.getElements().get(i));
            ++i;
        }
        return buffer.toString();
    }

    public Version copy() {
        return new Version(this);
    }

    public String[] getVersionElements() {
        String[] subElements = new String[this.getElements().size()];
        int i = 0;
        while (i < this.getElements().size()) {
            VersionElement elem = (VersionElement)this.getElements().get(i);
            subElements[i] = elem.toString();
            ++i;
        }
        return subElements;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Version) {
            Version otherVersion = (Version)obj;
            List otherElemets = otherVersion.getElements();
            int i = 0;
            while (i < otherElemets.size()) {
                VersionElement otherElement;
                if (i >= this.getElements().size()) {
                    return -1;
                }
                VersionElement element = (VersionElement)this.getElements().get(i);
                int compResult = element.compareTo(otherElement = (VersionElement)otherElemets.get(i));
                if (compResult != 0) {
                    return compResult < 0 ? -1 : 1;
                }
                ++i;
            }
            return i == this.getElements().size() ? 0 : 1;
        }
        throw new IllegalArgumentException("The object to compare is not a Version");
    }

    public boolean isNumeric() {
        if (this.getElements().isEmpty()) {
            return false;
        }
        for (VersionElement element : this.getElements()) {
            if (element.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (this.getElements().isEmpty()) {
            return false;
        }
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            VersionElement element = (VersionElement)iter.next();
            if (!element.isValid()) {
                return false;
            }
            if (element.isNumeric() || !iter.hasNext() && this.getElements().size() != 1) continue;
            return false;
        }
        return true;
    }

    protected void parse(String versionString) {
        String[] parts = this.str().parts(versionString, SEPARATOR);
        int i = 0;
        while (i < parts.length) {
            VersionElement element = new VersionElement(parts[i]);
            this.getElements().add(element);
            ++i;
        }
    }

    protected void addElement(int value) {
        int num = value < 0 ? 0 : value;
        this.getElements().add(new VersionElement(num));
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    private class VersionElement
    implements Comparable {
        private Integer intPart = Version.access$0();
        private String strPart = "";

        private VersionElement(Integer intPart, String strPart) {
            this.intPart = intPart;
            this.strPart = strPart;
        }

        VersionElement(String versionPart) {
            this.parse(versionPart);
        }

        VersionElement(int versionPart) {
            this.intPart = new Integer(versionPart);
        }

        public String toString() {
            if (this.intPart.equals(NOT_SET)) {
                return this.strPart;
            }
            return String.valueOf(this.intPart.toString()) + this.strPart;
        }

        public int compareTo(Object otherElement) {
            return this.compareTo((VersionElement)otherElement);
        }

        public boolean equals(Object object) {
            if (object instanceof VersionElement) {
                return this.compareTo((VersionElement)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            if (this.isNumeric()) {
                return this.intPart;
            }
            return this.strPart.hashCode();
        }

        public VersionElement copy() {
            return new VersionElement(this.intPart, this.strPart);
        }

        protected void parse(String versionPart) {
            boolean isNumber = true;
            StringBuffer numBuffer = new StringBuffer(20);
            StringBuffer strBuffer = new StringBuffer(20);
            int i = 0;
            while (i < versionPart.length()) {
                char ch = versionPart.charAt(i);
                boolean bl = isNumber = isNumber && Character.isDigit(ch);
                if (isNumber) {
                    numBuffer.append(ch);
                } else {
                    strBuffer.append(ch);
                }
                ++i;
            }
            try {
                if (numBuffer.length() > 0) {
                    int value = Integer.parseInt(numBuffer.toString());
                    this.intPart = new Integer(value);
                }
            }
            catch (NumberFormatException e) {
                this.intPart = NOT_SET;
                this.strPart = "";
                return;
            }
            this.strPart = strBuffer.toString();
            if (!this.isValidStringPart(this.strPart)) {
                this.strPart = "";
                this.intPart = NOT_SET;
            }
        }

        protected boolean isValidStringPart(String str) {
            char[] chars = str.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (!Character.isLetterOrDigit(chars[i]) && Version.SPECIAL_CHARACTERS.indexOf(chars[i]) < 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected int compareTo(VersionElement otherElement) {
            int compResult = this.intPart.compareTo(otherElement.intPart);
            if (compResult == 0) {
                compResult = this.strPart.compareTo(otherElement.strPart);
            }
            return compResult;
        }

        protected boolean isValid() {
            return !this.isInvalid();
        }

        protected boolean isInvalid() {
            return this.intPart.equals(NOT_SET) && Version.this.str().isNullOrEmpty(this.strPart);
        }

        protected boolean isNumeric() {
            return this.isValid() && Version.this.str().isNullOrEmpty(this.strPart);
        }
    }
}

