/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.pf.text.MatchRule;
import org.pf.text.MatchRuleVisitor;

public class LdapMatchRuleVisitor
implements MatchRuleVisitor {
    private StringBuffer buffer = null;
    private GroupInfo rootGroup = null;
    private Stack stack = null;

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(StringBuffer newValue) {
        this.buffer = newValue;
    }

    protected GroupInfo getRootGroup() {
        return this.rootGroup;
    }

    protected void setRootGroup(GroupInfo newValue) {
        this.rootGroup = newValue;
    }

    protected Stack getStack() {
        return this.stack;
    }

    protected void setStack(Stack newValue) {
        this.stack = newValue;
    }

    public void walkThroughInit() {
        this.setBuffer(new StringBuffer(100));
        this.setStack(new Stack());
    }

    public void walkThroughFinished() {
        this.appendGroup(this.getRootGroup());
    }

    public void startGroup(boolean andOperator, boolean notOperator) {
        GroupInfo group = null;
        group = this.createGroup();
        group.not_flag = notOperator;
        if (this.isFirstGroup()) {
            this.setRootGroup(group);
        } else {
            this.addElementToCurrentGroup(group, andOperator);
        }
        this.push(group);
    }

    public void endGroup() {
        this.pop();
    }

    public void attribute(String name, int compareOperator, String[] values, boolean andOperator, boolean notOperator) {
        AttributeInfo element = new AttributeInfo();
        element.name = name;
        element.operator = compareOperator;
        element.values = values;
        element.not_flag = notOperator;
        this.addElementToCurrentGroup(element, andOperator);
    }

    public String asSearchString(MatchRule matchRule) {
        matchRule.apply(this);
        return this.getBuffer().toString();
    }

    public void appendGroup(GroupInfo group) {
        if (group.not_flag) {
            this.getBuffer().append("(!");
        }
        if (group.neutral_elements == null) {
            this.appendGroupElements(group.and_elements, true);
            this.appendGroupElements(group.or_elements, false);
        } else {
            this.appendGroupElement((ElementInfo)group.neutral_elements.get(0));
        }
        if (group.not_flag) {
            this.getBuffer().append(')');
        }
    }

    protected void appendGroupElement(ElementInfo element) {
        if (element.isGroupInfo()) {
            this.appendGroup((GroupInfo)element);
        } else {
            this.appendAttribute((AttributeInfo)element);
        }
    }

    protected void appendGroupElements(List elements, boolean andOperator) {
        if (elements.size() == 0) {
            return;
        }
        this.getBuffer().append('(');
        this.getBuffer().append(andOperator ? (char)'&' : '|');
        int i = 0;
        while (i < elements.size()) {
            this.appendGroupElement((ElementInfo)elements.get(i));
            ++i;
        }
        this.getBuffer().append(')');
    }

    protected void appendAttribute(AttributeInfo element) {
        this.appendAttribute(element.name, element.operator, element.values, element.not_flag);
    }

    protected void appendAttribute(String name, int operator, String[] values, boolean notOperator) {
        boolean manyValues = false;
        boolean bl = manyValues = values.length > 1;
        if (notOperator) {
            this.getBuffer().append("(!");
        }
        if (manyValues) {
            this.getBuffer().append("(|");
        }
        int i = 0;
        while (i < values.length) {
            this.appendAttribute(name, operator, values[i]);
            ++i;
        }
        if (manyValues) {
            this.getBuffer().append(")");
        }
        if (notOperator) {
            this.getBuffer().append(")");
        }
    }

    protected void appendAttribute(String name, int operator, String value) {
        this.getBuffer().append('(');
        this.getBuffer().append(name);
        switch (operator) {
            case 1: {
                this.getBuffer().append('=');
                break;
            }
            case 4: {
                this.getBuffer().append(">=");
                break;
            }
            case 5: {
                this.getBuffer().append("<=");
                break;
            }
            default: {
                this.getBuffer().append('=');
            }
        }
        this.getBuffer().append(value);
        this.getBuffer().append(')');
    }

    protected void addElementToCurrentGroup(Object element, boolean andOperator) {
        GroupInfo group = null;
        List groupSlot = null;
        group = this.currentGroup();
        List list = groupSlot = andOperator ? group.and_elements : group.or_elements;
        if (group.neutral_elements == null) {
            groupSlot.add(element);
        } else if (group.neutral_elements.size() == 0) {
            group.neutral_elements.add(element);
        } else {
            groupSlot.add(group.neutral_elements.get(0));
            groupSlot.add(element);
            group.neutral_elements = null;
        }
    }

    protected GroupInfo createGroup() {
        return new GroupInfo();
    }

    protected GroupInfo pop() {
        return (GroupInfo)this.getStack().pop();
    }

    protected void push(GroupInfo obj) {
        this.getStack().push(obj);
    }

    protected GroupInfo currentGroup() {
        return (GroupInfo)this.getStack().peek();
    }

    protected boolean isFirstGroup() {
        return this.getStack().empty();
    }

    private class AttributeInfo
    extends ElementInfo {
        protected String name;
        protected int operator;
        protected String[] values;

        private AttributeInfo() {
            this.name = null;
            this.operator = 1;
            this.values = null;
        }
    }

    private class ElementInfo {
        protected boolean not_flag = false;

        private ElementInfo() {
        }

        protected boolean isGroupInfo() {
            return false;
        }
    }

    private class GroupInfo
    extends ElementInfo {
        protected List neutral_elements = new ArrayList();
        protected List and_elements = new ArrayList();
        protected List or_elements = new ArrayList();

        private GroupInfo() {
        }

        protected boolean isGroupInfo() {
            return true;
        }
    }
}

