/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pf.text.StringUtil;

public class CommandLineArguments {
    protected static final String STRING_DELIMITER = "\"";
    protected static final String DEFAULT_SWITCH_INDICATOR = "-";
    private String[] arguments = null;
    private String switchIndicator = "-";
    private Map optionsWithValues = null;

    protected String[] arguments() {
        return this.arguments;
    }

    protected void arguments(String[] newValue) {
        this.arguments = newValue;
    }

    protected String switchIndicator() {
        return this.switchIndicator;
    }

    protected void switchIndicator(String newValue) {
        this.switchIndicator = newValue;
    }

    protected Map getOptionsWithValues() {
        return this.optionsWithValues;
    }

    protected void setOptionsWithValues(Map newValue) {
        this.optionsWithValues = newValue;
    }

    public CommandLineArguments() {
        this(null, DEFAULT_SWITCH_INDICATOR);
    }

    public CommandLineArguments(String[] args) {
        this(args, DEFAULT_SWITCH_INDICATOR);
    }

    public CommandLineArguments(String[] args, String switchIndicator) {
        if (args == null) {
            this.arguments(StringUtil.EMPTY_STRING_ARRAY);
        } else {
            this.arguments(this.strUtil().copyFrom(args, 0));
        }
        if (switchIndicator != null) {
            this.setSwitchIndicator(switchIndicator);
        } else {
            this.init();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        int i = 0;
        while (i < this.arguments().length) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(this.arguments()[i]);
            ++i;
        }
        return buffer.toString();
    }

    public boolean isOptionSet(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        return this.strUtil().contains(this.arguments(), option);
    }

    public String getArgumentValue(String option, String defaultValue) {
        String value = this.getArgumentValue(option);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getArgumentValue(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        return this.findOptionValue(option);
    }

    public String[] getArgumentValues(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        return this.findValues(option);
    }

    public String[] getArgumentValues(String option, String[] defaultValues) {
        String[] values = this.getArgumentValues(option);
        if (values == null) {
            return defaultValues;
        }
        return values;
    }

    public String[] getOptionValues(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        String[] args = this.arguments();
        int index = this.strUtil().indexOf(args, option);
        if (index < 0) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(args.length);
        int i = index + 1;
        while (i < args.length) {
            if (args[i].startsWith(this.getSwitchIndicator())) break;
            strings.add(args[i]);
            ++i;
        }
        if (strings.isEmpty()) {
            return StringUtil.EMPTY_STRING_ARRAY;
        }
        return this.strUtil().asStrings(strings);
    }

    public void addOption(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        if (!this.isOptionSet(option)) {
            String[] newArgs = this.strUtil().append(this.arguments(), option);
            this.arguments(newArgs);
        }
    }

    public void addOptionWithArgument(String option, String argument) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        if (argument == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isOptionSet(option)) {
            String[] add = new String[]{option, argument};
            String[] newArgs = this.strUtil().append(this.arguments(), add);
            this.arguments(newArgs);
            this.init();
        }
    }

    public void removeOption(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        this.arguments(this.strUtil().remove(this.arguments(), option));
    }

    public void removeOptionWithArgument(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        String[] args = this.arguments();
        int index = this.strUtil().indexOf(args, option);
        if (index < 0) {
            return;
        }
        args[index] = null;
        if (++index < this.arguments().length && !this.isOption(args[index])) {
            args[index] = null;
        }
        this.arguments(this.strUtil().removeNull(this.arguments()));
        this.init();
    }

    public CommandLineArguments copy() {
        CommandLineArguments aCopy = new CommandLineArguments(this.arguments());
        aCopy.setSwitchIndicator(this.getSwitchIndicator());
        return aCopy;
    }

    public String getSwitchIndicator() {
        return this.switchIndicator();
    }

    public void setSwitchIndicator(String newValue) {
        this.switchIndicator(newValue);
        this.init();
    }

    public int size() {
        return this.arguments().length;
    }

    public String[] getArguments() {
        return this.strUtil().copyFrom(this.arguments(), 0);
    }

    public String getArgumentAt(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.arguments()[index];
    }

    protected void init() {
        HashMap namedValues = new HashMap();
        String[] args = this.arguments();
        int i = 0;
        while (i < args.length) {
            String option = args[i];
            String value = null;
            if (this.isOption(option)) {
                if (option.length() > 2) {
                    value = option.substring(2);
                    option = option.substring(0, 2);
                    this.addOptionWithValue(namedValues, option, value);
                }
                option = args[i];
                value = "";
                if (i < args.length - 1 && !this.isOption(args[i + 1])) {
                    value = args[i + 1];
                }
                this.addOptionWithValue(namedValues, option, value);
            }
            ++i;
        }
        this.setOptionsWithValues(namedValues);
    }

    protected void addOptionWithValue(Map map, String option, String value) {
        if (option != null && value != null) {
            String[] values = (String[])map.get(option);
            if (values == null) {
                values = StringUtil.EMPTY_STRING_ARRAY;
            }
            values = this.strUtil().append(values, value);
            map.put(option, values);
        }
    }

    protected boolean isOption(String arg) {
        return arg.startsWith(this.getSwitchIndicator());
    }

    protected String findOptionValue(String option) {
        String[] values = this.findValues(option);
        if (this.strUtil().isNullOrEmpty(values)) {
            return null;
        }
        return values[0];
    }

    protected String[] findValues(String option) {
        return (String[])this.getOptionsWithValues().get(option);
    }

    protected StringUtil strUtil() {
        return StringUtil.current();
    }
}

