/*
 * Decompiled with CFR 0.152.
 */
package org.pf.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SwingUtil {
    private static SwingUtil soleInstance = new SwingUtil();

    public static SwingUtil current() {
        return soleInstance;
    }

    protected SwingUtil() {
    }

    public void centerWindow(Window window, int width, int height) {
        Dimension screenSize = null;
        int xpos = 1;
        int ypos = 1;
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        xpos = (screenSize.width - width) / 2;
        ypos = (screenSize.height - height) / 2;
        ((Component)window).setBounds(xpos, ypos, width, height);
    }

    public void centerWindow(Window window) {
        this.centerWindow(window, window.getWidth(), window.getHeight());
    }

    public void centerFrame(JFrame frame, int width, int height) {
        this.centerWindow(frame, width, height);
    }

    public void centerFrame(JFrame frame) {
        this.centerWindow(frame);
    }

    public void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
    }

    public Component findComponent(Container container, String componentName) {
        return this.findComponent(container, null, componentName);
    }

    public Component findComponent(Container container, Class componentType, String componentName) {
        Component component = null;
        Component[] components = this.componentsOf(container);
        if (components != null) {
            int i = 0;
            while (i < components.length) {
                if (componentType != null) {
                    if (componentType.isInstance(components[i])) {
                        if (componentName != null) {
                            if (componentName.equals(components[i].getName())) {
                                component = components[i];
                            }
                        } else {
                            component = components[i];
                        }
                    }
                } else if (componentName != null && componentName.equals(components[i].getName())) {
                    component = components[i];
                }
                if (component == null && components[i] instanceof Container) {
                    component = this.findComponent((Container)components[i], componentType, componentName);
                }
                if (component != null) {
                    return component;
                }
                ++i;
            }
        }
        if (container instanceof JRootPane) {
            JRootPane pane = (JRootPane)container;
            return this.findComponent(pane.getJMenuBar(), componentType, componentName);
        }
        return null;
    }

    protected Component[] componentsOf(Container container) {
        if (container instanceof JMenu) {
            JMenu menu = (JMenu)container;
            return menu.getMenuComponents();
        }
        return container.getComponents();
    }
}

