/*
 * Decompiled with CFR 0.152.
 */
package org.pf.reflect;

import java.lang.reflect.Array;
import org.pf.reflect.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo<T> {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private String className = null;
    private Class<T> classObject = null;
    private boolean isSingleton = false;
    private T soleInstance = null;

    protected String className() {
        return this.className;
    }

    protected void className(String newValue) {
        this.className = newValue;
    }

    protected Class<T> classObject() {
        return this.classObject;
    }

    protected void classObject(Class<T> newValue) {
        this.classObject = newValue;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public void setIsSingleton(boolean newValue) {
        this.isSingleton = newValue;
    }

    protected T getSoleInstance() {
        return this.soleInstance;
    }

    protected void setSoleInstance(T newValue) {
        this.soleInstance = newValue;
    }

    public ClassInfo(String className) {
        this.setClassName(className);
    }

    public ClassInfo(String className, boolean singleton) {
        this(className);
        this.setIsSingleton(singleton);
    }

    public ClassInfo(Class aClass) {
        this.setClassObject(aClass);
    }

    public ClassInfo(Class aClass, boolean singleton) {
        this(aClass);
        this.setIsSingleton(singleton);
    }

    public boolean isAssignableFrom(Class type) {
        if (type == null) {
            return false;
        }
        if (this.getClassObject() == null) {
            return false;
        }
        return this.getClassObject().isAssignableFrom(type);
    }

    public boolean isAssignableTo(Class type) {
        if (type == null) {
            return false;
        }
        if (this.getClassObject() == null) {
            return false;
        }
        return type.isAssignableFrom(this.getClassObject());
    }

    public boolean isInstance(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClassObject() == null) {
            return false;
        }
        return this.getClassObject().isInstance(object);
    }

    public String getClassName() {
        return this.className();
    }

    public void setClassName(String className) {
        if (className != null) {
            this.className(className);
            this.classObject(null);
        }
    }

    public Class<T> getClassObject() {
        if (this.classObject() == null) {
            this.initClassObject();
        }
        return this.classObject();
    }

    public void setClassObject(Class<T> aClass) {
        if (aClass != null) {
            this.classObject(aClass);
            this.className(aClass.getName());
        }
    }

    public T getInstance() {
        if (this.isSingleton()) {
            if (this.getSoleInstance() == null) {
                this.setSoleInstance(this.createInstance());
            }
            return this.getSoleInstance();
        }
        return this.createInstance();
    }

    public T createInstance() {
        try {
            return this.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public T newInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<T> aClass = this.getClassObject();
        if (aClass == null) {
            throw new ClassNotFoundException(this.className());
        }
        return aClass.newInstance();
    }

    public T[] newArray(int size) {
        if (this.getClassObject() != null) {
            return (Object[])Array.newInstance(this.getClassObject(), size);
        }
        return EMPTY_OBJECT_ARRAY;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.getClassName() + ")";
    }

    protected void initClassObject() {
        Class aClass = ReflectUtil.current().findClass(this.getClassName());
        if (aClass != null) {
            this.classObject(aClass);
        }
    }
}

