/*
 * Decompiled with CFR 0.152.
 */
package org.pf.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import org.pf.file.Classpath;
import org.pf.file.ClasspathElement;
import org.pf.file.FileUtil;
import org.pf.file.PropertiesFileContent;
import org.pf.file.PropertyFileLoader;
import org.pf.plugin.LoggerProvider;
import org.pf.plugin.PluginHolder;
import org.pf.plugin.PluginUtil;
import org.pf.reflect.ClassInfo;
import org.pf.reflect.Dynamic;
import org.pf.reflect.ReflectUtil;
import org.pf.text.StringPattern;
import org.pf.text.StringUtil;
import org.pf.util.AssociationList;
import org.pf.util.CollectionUtil;
import org.pf.util.NamedValueList;
import org.pf.util.OrderedProperties;

public class PluginRegistry {
    protected static final boolean DEBUG = "true".equals(System.getProperty("org.pf.plugin.PluginRegistry.debug"));
    protected static final String DEBUG_PREFIX = "org.pf.plugin.PluginRegistry: ";
    protected static final String PLUGIN_DEF_SEPARATOR = ";";
    protected static final String OPTIONS_START = "[";
    protected static final String OPTIONS_END = "]";
    protected static final StringPattern PLUGIN_OPTIONS_PATTERN = StringPattern.create("[*]?*");
    private NamedValueList registry;

    protected NamedValueList getRegistry() {
        return this.registry;
    }

    protected void setRegistry(NamedValueList newValue) {
        this.registry = newValue;
    }

    public PluginRegistry() {
        this.setRegistry(new NamedValueList());
    }

    public int loadPluginsFrom(String filename) {
        int sum = this.readPlugins(filename, this.getPluginClasspath());
        if (DEBUG) {
            this.debug("Registered " + sum + " plug-ins");
        }
        return sum;
    }

    public Object getPlugin(String pluginId) {
        PluginHolder pluginHolder = (PluginHolder)this.getRegistry().valueAt(pluginId);
        if (pluginHolder != null) {
            return pluginHolder.getInstance();
        }
        return null;
    }

    public Object getPlugin(String pluginId, Class pluginType) {
        int i = 0;
        while (i < this.getRegistry().size()) {
            PluginHolder pluginHolder;
            if (pluginId.equals(this.getRegistry().nameAt(i)) && (pluginHolder = (PluginHolder)((AssociationList)this.getRegistry()).valueAt(i)).isPluginType(pluginType)) {
                return pluginHolder.getInstance();
            }
            ++i;
        }
        return null;
    }

    public Object[] getPluginsOfType(Class pluginType) {
        ArrayList<Object> found = new ArrayList<Object>(this.getRegistry().size());
        for (PluginHolder pluginHolder : this.getRegistry().values()) {
            Object plugin;
            if (!pluginHolder.isPluginType(pluginType) || (plugin = pluginHolder.getInstance()) == null) continue;
            found.add(plugin);
        }
        if (found.size() == 0) {
            return (Object[])Array.newInstance(pluginType, 0);
        }
        return this.coll().toArray(found, pluginType);
    }

    public String[] getPluginIDsOfType(Class pluginType) {
        ArrayList<String> found = new ArrayList<String>(this.getRegistry().size());
        int i = 0;
        while (i < this.getRegistry().size()) {
            PluginHolder pluginHolder = (PluginHolder)((AssociationList)this.getRegistry()).valueAt(i);
            if (pluginHolder.isPluginType(pluginType)) {
                found.add(this.getRegistry().nameAt(i));
            }
            ++i;
        }
        if (found.size() == 0) {
            return StringUtil.EMPTY_STRING_ARRAY;
        }
        return this.str().asStrings(found);
    }

    protected boolean registerPlugin(PluginHolder pluginHolder) {
        Object object = pluginHolder.getInstance();
        if (object == null) {
            return false;
        }
        String id = pluginHolder.getExternalId();
        Method method = this.find_getPluginId_Method(object);
        if (method != null) {
            id = (String)Dynamic.invoke(object, method, null);
        }
        this.getRegistry().add(id, pluginHolder);
        return true;
    }

    protected int readPlugins(String filename, Classpath classpath) {
        int sum = 0;
        if (DEBUG) {
            this.debug("Lookup file <" + filename + "> in <" + classpath + ">");
        }
        ClasspathElement[] elements = classpath.elementsContaining(filename);
        int i = 0;
        while (i < elements.length) {
            if (DEBUG) {
                this.debug("Found file <" + filename + "> in <" + elements[i].getName() + ">");
            }
            sum += this.readPluginsFrom(elements[i], filename);
            ++i;
        }
        return sum;
    }

    protected int readPluginsFrom(ClasspathElement element, String filename) {
        PropertiesFileContent properties;
        InputStream stream = null;
        try {
            try {
                stream = element.open(filename);
                properties = PropertyFileLoader.loadFullPropertiesFile(stream);
            }
            catch (IOException e) {
                if (DEBUG) {
                    this.debug("Exception reading file <" + filename + "> : " + e.toString());
                }
                this.fileUtil().close(stream);
                return 0;
            }
        }
        finally {
            this.fileUtil().close(stream);
        }
        return this.addDefinitionsToRegistry(properties);
    }

    protected int addDefinitionsToRegistry(OrderedProperties definitions) {
        int sum = 0;
        String[] keys = definitions.getPropertyNames();
        int i = 0;
        while (i < keys.length) {
            if (this.parseAndAddToRegistry(keys[i], definitions.getProperty(keys[i]))) {
                ++sum;
            }
            ++i;
        }
        return sum;
    }

    protected boolean parseAndAddToRegistry(String id, String pluginDefinition) {
        ClassInfo classInfo;
        String classOptions = null;
        String[] parts = this.str().parts(pluginDefinition, PLUGIN_DEF_SEPARATOR);
        if (this.str().isNullOrEmpty(parts)) {
            return false;
        }
        String className = parts[0];
        if (DEBUG) {
            this.debug("Found <" + className + "> with id <" + id + ">");
        }
        if (PLUGIN_OPTIONS_PATTERN.matches(className)) {
            classOptions = this.str().getDelimitedSubstring(className, OPTIONS_START, OPTIONS_END);
            className = this.str().cutHead(className, OPTIONS_END);
        }
        if (!this.validateClass(classInfo = new ClassInfo(className))) {
            return false;
        }
        PluginHolder holder = new PluginHolder(id, classInfo);
        if ("1".equals(classOptions)) {
            holder.isSingleton(true);
        }
        Properties config = new Properties();
        int i = 1;
        while (i < parts.length) {
            String[] keyValue = this.str().splitNameValue(parts[i], "=");
            if (!this.str().isNullOrEmpty(keyValue)) {
                config.setProperty(keyValue[0], keyValue.length > 1 ? keyValue[1] : "");
            }
            ++i;
        }
        holder.setConfiguration(config);
        return this.registerPlugin(holder);
    }

    protected boolean validateClass(ClassInfo classInfo) {
        if (this.validateClassFound(classInfo)) {
            return this.validateInstanceCreation(classInfo);
        }
        return false;
    }

    protected boolean validateClassFound(ClassInfo classInfo) {
        Class aClass = classInfo.getClassObject();
        if (aClass == null) {
            LoggerProvider.getLogger().logError("Plug-in class <" + classInfo.getClassName() + "> not found!");
            return false;
        }
        return true;
    }

    protected boolean validateInstanceCreation(ClassInfo classInfo) {
        try {
            classInfo.newInstance();
            return true;
        }
        catch (Exception ex) {
            LoggerProvider.getLogger().logError("Plug-in class <" + classInfo.getClassName() + "> cannot be instantiated.", ex);
            return false;
        }
    }

    protected Method find_getPluginId_Method(Object object) {
        return ReflectUtil.current().findMethod(object.getClass(), "getPluginId", null, 1);
    }

    protected Classpath getPluginClasspath() {
        return PluginUtil.current().getPluginClasspath();
    }

    protected FileUtil fileUtil() {
        return FileUtil.current();
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    protected CollectionUtil coll() {
        return CollectionUtil.current();
    }

    protected void debug(String text) {
        LoggerProvider.getLogger().logDebug(DEBUG_PREFIX + text);
    }
}

