/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.pf.file.FileFinder;
import org.pf.file.FileUtil;
import org.pf.joi.AbstractObjectSpy;
import org.pf.joi.BasicInspector;
import org.pf.joi.ElementFilter;
import org.pf.joi.ElementFilterMenu;
import org.pf.joi.ExportProvider;
import org.pf.joi.InspectionFrame;
import org.pf.joi.InspectionView;
import org.pf.joi.Inspector;
import org.pf.joi.Spy;

public class InspectionWindowController
implements ActionListener,
WindowListener {
    public static final int INSPECT_IN_CURRENT_PLACE = 1;
    public static final int INSPECT_IN_NEW_TAB = 2;
    public static final int INSPECT_IN_NEW_WINDOW = 3;
    protected static final String TXT_ACTIONS = "Actions";
    protected static final String TXT_CONTINUE_THREAD = "Continue Thread";
    protected static final String TXT_SORT = "Sort";
    protected static final String TXT_BASIC_INSPECT_IN_NEW_WINDOW = "Basic Inspect in new window";
    protected static final String TXT_BASIC_INSPECT_IN_NEW_TAB = "Basic Inspect in new tab";
    protected static final String TXT_BASIC_INSPECT_HERE = "Basic Inspect in this tab/window";
    protected static final String TXT_INSPECT_IN_NEW_WINDOW = "Inspect in new window";
    protected static final String TXT_INSPECT_IN_NEW_TAB = "Inspect in new tab";
    protected static final String TXT_INSPECT_HERE = "Inspect in this tab/window";
    protected static final String actCloseWindow = "actionCloseWindow";
    protected static final String actCloseAll = "actionCloseAll";
    protected static final String actCloseTab = "actionCloseTab";
    protected static final String actInspectWindow = "actionInspectInWindow";
    protected static final String actInspectTab = "actionInspectInTab";
    protected static final String actInspectHere = "actionInspectHere";
    protected static final String actBasicInspectWindow = "actionBasicInspectInWindow";
    protected static final String actBasicInspectTab = "actionBasicInspectInTab";
    protected static final String actBasicInspectHere = "actionBasicInspectHere";
    protected static final String actSort = "actionSort";
    protected static final String actContinue = "actionContinue";
    protected static final String actAbout = "actionAbout";
    protected static final String actToggleStatic = "ToggleStatic";
    protected static final String actToggleFinal = "ToggleFinal";
    protected static final String actToggleTransient = "ToggleTransient";
    protected static final String actTogglePackage = "TogglePackage";
    protected static final String actTogglePrivate = "TogglePrivate";
    protected static final String actToggleProtected = "ToggleProtected";
    protected static final String actTogglePublic = "TogglePublic";
    protected static final String actShowInspectorMapping = "ShowInspectorMapping";
    protected static final String actShowRendererMapping = "ShowRendererMapping";
    protected static final String actShowExporterMapping = "ShowExporterMapping";
    protected static final String actShowSystemProperties = "ShowSystemProperties";
    protected static final String actShowLicenseText = "ShowLicenseText";
    protected static final int PLUGIN_INSPECTOR = 1;
    protected static final int PLUGIN_RENDERER = 2;
    protected static final int PLUGIN_EXPORTER = 3;
    private InspectionFrame mainFrame = null;
    private BasicInspector currentInspector = null;
    private ElementFilterMenu filterMenu = null;

    protected InspectionFrame getMainFrame() {
        return this.mainFrame;
    }

    protected void setMainFrame(InspectionFrame newValue) {
        this.mainFrame = newValue;
    }

    protected BasicInspector getCurrentInspector() {
        return this.currentInspector;
    }

    protected void setCurrentInspector(BasicInspector newValue) {
        this.currentInspector = newValue;
    }

    protected ElementFilterMenu getFilterMenu() {
        return this.filterMenu;
    }

    protected void setFilterMenu(ElementFilterMenu newValue) {
        this.filterMenu = newValue;
    }

    public InspectionWindowController() {
        this.setFilterMenu(new ElementFilterMenu());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(actCloseWindow)) {
            this.terminate();
        } else if (e.getActionCommand().equals(actBasicInspectWindow)) {
            this.currentInspector().basicInspectCurrentElement(3);
        } else if (e.getActionCommand().equals(actBasicInspectTab)) {
            this.currentInspector().basicInspectCurrentElement(2);
        } else if (e.getActionCommand().equals(actBasicInspectHere)) {
            this.currentInspector().basicInspectCurrentElement(1);
        } else if (e.getActionCommand().equals(actInspectWindow)) {
            this.currentInspector().inspectCurrentElement(3);
        } else if (e.getActionCommand().equals(actInspectTab)) {
            this.currentInspector().inspectCurrentElement(2);
        } else if (e.getActionCommand().equals(actInspectHere)) {
            this.currentInspector().inspectCurrentElement(1);
        } else if (e.getActionCommand().equals(actCloseAll)) {
            this.closeAllControllers();
        } else if (e.getActionCommand().equals(actSort)) {
            this.currentInspector().sortElements();
        } else if (e.getActionCommand().equals(actContinue)) {
            this.continueProcess();
        } else if (e.getActionCommand().equals(actToggleStatic)) {
            this.toggleFilter(8);
        } else if (e.getActionCommand().equals(actToggleFinal)) {
            this.toggleFilter(16);
        } else if (e.getActionCommand().equals(actToggleTransient)) {
            this.toggleFilter(128);
        } else if (e.getActionCommand().equals(actTogglePrivate)) {
            this.toggleFilter(2);
        } else if (e.getActionCommand().equals(actToggleProtected)) {
            this.toggleFilter(4);
        } else if (e.getActionCommand().equals(actTogglePublic)) {
            this.toggleFilter(1);
        } else if (e.getActionCommand().equals(actTogglePackage)) {
            this.toggleFilter(-1);
        } else if (e.getActionCommand().equals(actShowInspectorMapping)) {
            this.showPluginMapping(1);
        } else if (e.getActionCommand().equals(actShowRendererMapping)) {
            this.showPluginMapping(2);
        } else if (e.getActionCommand().equals(actShowExporterMapping)) {
            this.showPluginMapping(3);
        } else if (e.getActionCommand().equals(actCloseTab)) {
            this.closeInspectionTab(e);
        } else if (e.getActionCommand().equals(actShowSystemProperties)) {
            this.showSystemProperties();
        } else if (e.getActionCommand().equals(actShowLicenseText)) {
            this.showLicenseText();
        } else if (e.getActionCommand().equals(actAbout)) {
            this.displayAboutInfo();
        } else if (e.getActionCommand().startsWith("Export|")) {
            this.exportObject(e.getActionCommand().substring("Export|".length()));
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.terminate();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    protected BasicInspector currentInspector() {
        return this.getCurrentInspector();
    }

    protected void replaceCurrentInspector(BasicInspector inspector) {
        this.setCurrentInspector(inspector);
        this.getFilterMenu().replaceFilter(this.getCurrentInspector().elementFilter());
    }

    protected void viewSelected(InspectionView view) {
        this.replaceCurrentInspector(view.getController());
    }

    protected void terminate() {
        Inspector.unregisterController(this);
        this.close();
    }

    protected void continueProcess() {
        Inspector.deactivateHalt();
    }

    protected void start(BasicInspector inspector) {
        this.addInspector(inspector);
        this.replaceCurrentInspector(inspector);
        this.buildUI();
        this.getMainFrame().addInspection(inspector.getInspectionView());
        this.openUI();
    }

    protected void close() {
        this.getMainFrame().setVisible(false);
    }

    protected void closeAllControllers() {
        Inspector.closeAllControllers();
    }

    protected void toggleFilter(int filterFlag) {
        this.getElementFilter().toggleSwitch(filterFlag);
        this.currentInspector().updateDisplay();
    }

    protected void showPluginMapping(int pluginType) {
        Map mapping = null;
        String name = "";
        switch (pluginType) {
            case 1: {
                mapping = Inspector.inspectorBinding().getMapping();
                name = "Inspector mapping";
                break;
            }
            case 3: {
                mapping = Inspector.exportProviderRegistry().getMapping();
                name = "Exporter mapping";
                break;
            }
            case 2: {
                mapping = Spy.getRendererRegistry().getMapping();
                name = "Renderer mapping";
            }
        }
        if (mapping != null) {
            Inspector.inspect(name, mapping);
        }
    }

    protected void exportObject(String exportName) {
        ExportProvider exportProvider = null;
        exportProvider = Inspector.findExporterNamed(exportName);
        if (exportProvider != null) {
            try {
                exportProvider.export(this.getInspectedObject(), this.getMainFrame());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void closeInspectionTab(ActionEvent event) {
        InspectionView view = this.getMainFrame().getSelectedView();
        if (view != null) {
            this.removeInspector(view.getController());
            this.getMainFrame().removeInspection(view);
        }
    }

    protected void displayAboutInfo() {
        JOptionPane.showMessageDialog(this.getMainFrame().getContentPane(), Inspector.getAboutInfoText(), "About JOI", 1);
    }

    protected void showSystemProperties() {
        Inspector.inspect("System Properties", System.getProperties());
    }

    protected void showLicenseText() {
        URL url = FileFinder.locateFileOnClasspath("cpl-v1.0.txt");
        if (url != null) {
            String text;
            try {
                text = this.fileUtil().readTextFrom(url.openStream());
            }
            catch (Exception e) {
                text = e.toString();
            }
            Inspector.inspect("Common Public License 1.0", text);
        }
    }

    protected void addInspector(BasicInspector inspector) {
        inspector.setController(this);
    }

    protected void removeInspector(BasicInspector inspector) {
        inspector.setController(null);
    }

    protected String getInspectorId() {
        return this.currentInspector().getInspectorId();
    }

    protected AbstractObjectSpy getInspectedObject() {
        return this.currentInspector().getInspectedObject();
    }

    protected String getInspectedObjectTypeString() {
        return this.currentInspector().getInspectedObject().getTypeString();
    }

    protected ElementFilter getElementFilter() {
        return this.getFilterMenu().getElementFilter();
    }

    protected void openUI() {
        this.getMainFrame().validate();
        this.getMainFrame().setVisible(true);
    }

    protected void openNewInspector(BasicInspector inspector, int where) {
        this.addInspector(inspector);
        switch (where) {
            case 2: {
                this.getMainFrame().addInspection(inspector.getInspectionView());
                break;
            }
            case 1: {
                this.getMainFrame().replaceInspection(inspector.getInspectionView());
                break;
            }
            default: {
                this.removeInspector(inspector);
                return;
            }
        }
        inspector.setFilter(this.getElementFilter().copy());
        this.replaceCurrentInspector(inspector);
    }

    protected void buildUI() {
        InspectionFrame frame = new InspectionFrame(this);
        this.setMainFrame(frame);
        frame.setJMenuBar(this.createMenuBar());
    }

    protected JMenu createMenu(String text) {
        return new JMenu(text);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = null;
        menuBar = new JMenuBar();
        menuBar.add(this.createSubmenuWindow());
        menuBar.add(this.createSubmenuActions());
        menuBar.add(this.createSubmenuShow());
        menuBar.add(this.createSubmenuPlugins());
        menuBar.add(this.createSubmenuHelp());
        return menuBar;
    }

    protected JMenu createSubmenuActions() {
        JMenu menu = null;
        JMenuItem menuItem = null;
        menu = this.createMenu(TXT_ACTIONS);
        menuItem = this.createMenuItem(TXT_INSPECT_HERE, actInspectHere);
        menu.add(menuItem);
        menuItem = this.createMenuItem(TXT_INSPECT_IN_NEW_TAB, actInspectTab);
        menu.add(menuItem);
        menuItem = this.createMenuItem(TXT_INSPECT_IN_NEW_WINDOW, actInspectWindow);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.createMenuItem(TXT_BASIC_INSPECT_HERE, actBasicInspectHere);
        menu.add(menuItem);
        menuItem = this.createMenuItem(TXT_BASIC_INSPECT_IN_NEW_TAB, actBasicInspectTab);
        menu.add(menuItem);
        menuItem = this.createMenuItem(TXT_BASIC_INSPECT_IN_NEW_WINDOW, actBasicInspectWindow);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.createMenuItem(TXT_SORT, actSort);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.createMenuItem(TXT_CONTINUE_THREAD, actContinue);
        menu.add(menuItem);
        return menu;
    }

    protected JMenu createSubmenuWindow() {
        JMenu menu = null;
        JMenuItem menuItem = null;
        ExportProvider exportProvider = null;
        menu = this.createMenu("Window");
        String[] keys = Inspector.exportProviderRegistry().keys();
        if (keys.length > 0) {
            int i = 0;
            while (i < keys.length) {
                String text;
                exportProvider = Inspector.findExporterNamed(keys[i]);
                if (exportProvider != null && (text = exportProvider.exportLabel()) != null) {
                    menuItem = this.createMenuItem(text, "Export|" + keys[i]);
                    menu.add(menuItem);
                }
                ++i;
            }
            menu.addSeparator();
        }
        menuItem = this.createMenuItem("Close Window", actCloseWindow);
        menu.add(menuItem);
        menuItem = this.createMenuItem("Close All Windows", actCloseAll);
        menu.add(menuItem);
        return menu;
    }

    protected JMenu createSubmenuShow() {
        JMenu menu = null;
        JCheckBoxMenuItem menuItem = null;
        menu = this.createMenu("Show");
        menuItem = this.getFilterMenu().getStaticMenuItem();
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = this.getFilterMenu().getFinalMenuItem();
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = this.getFilterMenu().getTransientMenuItem();
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.getFilterMenu().getPrivateMenuItem();
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = this.getFilterMenu().getProtectedMenuItem();
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = this.getFilterMenu().getPublicMenuItem();
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = this.getFilterMenu().getPackageMenuItem();
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menu;
    }

    protected JMenu createSubmenuPlugins() {
        JMenu menu = null;
        JMenuItem menuItem = null;
        menu = this.createMenu("Plugins");
        menuItem = this.createMenuItem("Inspector", actShowInspectorMapping);
        menu.add(menuItem);
        menuItem = this.createMenuItem("Renderer", actShowRendererMapping);
        menu.add(menuItem);
        menuItem = this.createMenuItem("Exporter", actShowExporterMapping);
        menu.add(menuItem);
        return menu;
    }

    protected JMenu createSubmenuHelp() {
        JMenu menu = null;
        JMenuItem menuItem = null;
        menu = this.createMenu("Help");
        menuItem = this.createMenuItem("Show System Properties", actShowSystemProperties);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.createMenuItem("License", actShowLicenseText);
        menu.add(menuItem);
        menuItem = this.createMenuItem("About JOI", actAbout);
        menu.add(menuItem);
        return menu;
    }

    protected JMenuItem createMenuItem(String text, String command) {
        JMenuItem menuItem = null;
        menuItem = new JMenuItem(text);
        menuItem.setActionCommand(command);
        menuItem.addActionListener(this);
        return menuItem;
    }

    protected FileUtil fileUtil() {
        return FileUtil.current();
    }
}

