/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.util.zip.ZipEntry;
import org.pf.file.FileLocator;
import org.pf.file.FileUtil;

public class FileInfo {
    private static final String PATH_SEPARATOR = "/";
    private String archiveName = null;
    private String path = null;
    private String name = null;
    private long size = 0L;
    private long lastModified = 0L;

    public FileInfo(File file) {
        this.setPathAndName(file);
        this.setSize(file.length());
        this.lastModified(file.lastModified());
    }

    public FileInfo(String archiveName, ZipEntry zipEntry) {
        this.setArchiveName(archiveName);
        this.setPathAndName(new File(zipEntry.getName()));
        this.setSize(zipEntry.getSize());
        this.lastModified(zipEntry.getTime());
    }

    public boolean isInArchive() {
        return this.getArchiveName() != null;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public String getLocation() {
        if (this.isInArchive()) {
            return String.valueOf(this.getArchiveName()) + PATH_SEPARATOR + this.getFullName();
        }
        return this.getFullName();
    }

    public String getFullName() {
        return String.valueOf(this.getPath()) + PATH_SEPARATOR + this.getName();
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public FileLocator asFileLocator() {
        return FileLocator.create(this.getLocation());
    }

    public File asFile() {
        if (this.isInArchive()) {
            return null;
        }
        return new File(this.getPath(), this.getName());
    }

    protected void setArchiveName(String newValue) {
        this.archiveName = newValue;
    }

    protected void setPath(String newValue) {
        this.path = newValue;
    }

    protected void setName(String newValue) {
        this.name = newValue;
    }

    protected void setSize(long newValue) {
        this.size = newValue;
    }

    protected void lastModified(long newValue) {
        this.lastModified = newValue;
    }

    protected void setPathAndName(File file) {
        this.setPath(this.util().javaFilename(file.getParent()));
        this.setName(file.getName());
    }

    protected FileUtil util() {
        return FileUtil.current();
    }
}

