/*
 * Decompiled with CFR 0.152.
 */
package g2d.terms;

import g2d.terms.AppTerm;
import g2d.terms.Hole;
import g2d.terms.HoleTerm;
import g2d.terms.Sort;
import g2d.terms.Subsorter;
import g2d.terms.Term;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Constructor {
    public final String name;
    public final int arity;
    public final Sort sort;
    public final List<Sort> args;
    public final int hashCode;
    private String printable = null;

    public Constructor(String string, int n, Sort sort, Sort[] sortArray) {
        this.name = string;
        this.arity = n;
        this.sort = sort;
        this.args = Collections.unmodifiableList(Arrays.asList(sortArray == null ? new Sort[]{} : sortArray));
        boolean bl = this.isOK();
        if (!bl) {
            System.err.println("Constructor(String name, int arity, Sort sort, Sort[] args) UNHAPPY");
        }
        assert (bl);
        this.hashCode = this._hashCode();
    }

    public Constructor(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2 || stringArray[0] == null || stringArray[1] == null) {
            throw new IllegalArgumentException("Constructor(String[] maudeForm) UNHAPPY");
        }
        this.name = stringArray[0];
        this.arity = stringArray.length - 2;
        this.sort = new Sort(stringArray[1]);
        Sort[] sortArray = new Sort[this.arity];
        for (int i = 2; i < stringArray.length; ++i) {
            sortArray[i - 2] = new Sort(stringArray[i]);
        }
        this.args = Collections.unmodifiableList(Arrays.asList(sortArray));
        this.hashCode = this._hashCode();
    }

    public int length() {
        return this.name.length();
    }

    public Term expand(Subsorter subsorter) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (int i = 0; i < this.arity; ++i) {
            HoleTerm holeTerm = new HoleTerm(new Hole(this.args.get(i)));
            arrayList.add(holeTerm);
        }
        return new AppTerm(this, arrayList, subsorter);
    }

    public boolean isOK() {
        if (this.name == null || this.sort == null || this.arity < 0 || this.args == null) {
            return false;
        }
        return this.arity == this.args.size();
    }

    public String toString() {
        if (this.printable == null) {
            this.printable = this.expand(null).toString();
        }
        return this.printable;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Constructor constructor = (Constructor)object;
        if (this.args.size() != constructor.args.size()) {
            return false;
        }
        for (int i = 0; i < this.args.size(); ++i) {
            Sort sort = this.args.get(i);
            Sort sort2 = constructor.args.get(i);
            if (sort == null && sort2 != null || sort != null && sort2 == null) {
                return false;
            }
            if (sort == sort2 && (sort == null || sort.equals(sort2))) continue;
            return false;
        }
        return !(this.name != constructor.name && !this.name.equals(constructor.name) || this.arity != constructor.arity || this.sort != constructor.sort && !this.sort.equals(constructor.sort));
    }

    private int _hashCode() {
        int n = 7;
        n = 31 * n + this.arity;
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.sort.hashCode();
        for (int i = 0; i < this.args.size(); ++i) {
            Sort sort = this.args.get(i);
            n = 31 * n + (sort == null ? 0 : sort.hashCode());
        }
        return n;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

