/*
 * Decompiled with CFR 0.152.
 */
package g2d.terms;

import g2d.terms.Constructor;
import g2d.terms.HolePosition;
import g2d.terms.Sort;
import g2d.terms.Subsorter;
import g2d.terms.Term;
import g2d.terms.TermPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AppTerm
extends Term {
    public final Constructor constructor;
    public final List<Term> terms;
    public final int hashCode;
    private int _rank = -1;
    private int _length = -1;
    private int _holeCount = -1;
    private Set<Term> _subterms = null;

    public AppTerm(Constructor constructor, ArrayList<Term> arrayList, Subsorter subsorter) {
        if (constructor == null) {
            throw new IllegalArgumentException("AppTerm()'s constructor argument cannot be null");
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("AppTerm()'s terms argument cannot be null");
        }
        this.constructor = constructor;
        this.terms = Collections.unmodifiableList(arrayList);
        this.hashCode = this._hashCode();
        if (subsorter != null) {
            boolean bl = this.isOK(subsorter);
            if (!bl) {
                System.err.println("this = " + this);
                System.err.println("arity = " + constructor.arity);
                System.err.println("terms = " + arrayList);
                System.err.println("AppTerm() UNHAPPY");
            }
            assert (bl);
        }
    }

    @Override
    public Sort sort() {
        return this.constructor.sort;
    }

    @Override
    public Set<Term> subterms() {
        if (this._subterms != null) {
            return this._subterms;
        }
        HashSet<Term> hashSet = new HashSet<Term>();
        hashSet.add(this);
        for (Term term : this.terms) {
            hashSet.addAll(term.subterms());
        }
        this._subterms = hashSet;
        return hashSet;
    }

    @Override
    public void toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.constructor.name);
        if (this.constructor.arity != 0) {
            boolean bl = false;
            stringBuffer.append("(");
            for (Term term : this.terms) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                term.toStringBuffer(stringBuffer);
            }
            stringBuffer.append(")");
        }
    }

    @Override
    public int length() {
        if (this._length >= 0) {
            return this._length;
        }
        int n = this.constructor.length();
        if (this.constructor.arity != 0) {
            boolean bl = false;
            n += 2;
            for (Term term : this.terms) {
                if (bl) {
                    n += 2;
                } else {
                    bl = true;
                }
                n += term.length();
            }
        }
        this._length = n;
        return n;
    }

    @Override
    public int rank() {
        if (this._rank >= 0) {
            return this._rank;
        }
        int n = 1;
        int n2 = 0;
        if (this.constructor.arity != 0) {
            for (Term term : this.terms) {
                int n3 = term.rank();
                if (n3 <= n2) continue;
                n2 = n3;
            }
        }
        this._rank = n += n2;
        return n;
    }

    public boolean isOK(Subsorter subsorter) {
        if (this.constructor == null || this.terms == null) {
            System.err.println("AppTerm.isOK: shouldn't have a null constructor or terms field");
            return false;
        }
        if (this.constructor.arity != this.terms.size()) {
            System.err.println("AppTerm.isOK: arities don't match");
            return false;
        }
        for (int i = 0; i < this.constructor.arity; ++i) {
            Sort sort = this.constructor.args.get(i);
            Term term = this.terms.get(i);
            if (sort == null || term == null) {
                System.err.println("AppTerm.isOK: null encounted checking types.");
                return false;
            }
            if (subsorter.isSubsort(term.sort(), sort)) continue;
            System.err.println("AppTerm.isOK: not a subsort");
            return false;
        }
        return true;
    }

    @Override
    public int holeCount() {
        if (this._holeCount >= 0) {
            return this._holeCount;
        }
        int n = 0;
        for (int i = 0; i < this.terms.size(); ++i) {
            n += this.terms.get(i).holeCount();
        }
        this._holeCount = n;
        return n;
    }

    @Override
    public Term copy() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Term term : this.terms) {
            arrayList.add(term.copy());
        }
        return new AppTerm(this.constructor, arrayList, null);
    }

    @Override
    public Term expand(int n, Term term, Subsorter subsorter) {
        ArrayList<Term> arrayList = Term.expand(this.terms, n, term, subsorter);
        if (arrayList != null) {
            return new AppTerm(this.constructor, arrayList, subsorter);
        }
        return null;
    }

    @Override
    public Term expand(Term term, Term term2, Subsorter subsorter) {
        if (this == term) {
            return term2;
        }
        ArrayList<Term> arrayList = Term.expand(this.terms, term, term2, subsorter);
        return new AppTerm(this.constructor, arrayList, subsorter);
    }

    @Override
    public int getHolePositions(int n, ArrayList<HolePosition> arrayList) {
        Constructor constructor = this.constructor;
        int n2 = constructor.name.length();
        if (constructor.arity > 0) {
            boolean bl = false;
            ++n2;
            for (Term term : this.terms) {
                if (bl) {
                    n2 += 2;
                }
                n2 += term.getHolePositions(n2 + n, arrayList);
                if (bl) continue;
                bl = true;
            }
            ++n2;
        }
        return n2;
    }

    @Override
    public int getSubtermPositions(int n, Sort sort, ArrayList<TermPosition> arrayList) {
        Constructor constructor = this.constructor;
        int n2 = this.constructor.length();
        if (constructor.arity > 0) {
            boolean bl = false;
            ++n2;
            for (int i = 0; i < constructor.arity; ++i) {
                Term term = this.terms.get(i);
                Sort sort2 = constructor.args.get(i);
                if (bl) {
                    n2 += 2;
                } else {
                    bl = true;
                }
                n2 += term.getSubtermPositions(n2 + n, sort2, arrayList);
            }
            ++n2;
        }
        arrayList.add(new TermPosition(n, sort, this));
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        AppTerm appTerm = (AppTerm)object;
        if (this.terms.size() != appTerm.terms.size()) {
            return false;
        }
        for (int i = 0; i < this.terms.size(); ++i) {
            if (this.terms.get(i).equals(appTerm.terms.get(i))) continue;
            return false;
        }
        return this.constructor == appTerm.constructor || this.constructor.equals(appTerm.constructor);
    }

    private int _hashCode() {
        int n = 7;
        n = 31 * n + this.constructor.hashCode();
        for (int i = 0; i < this.terms.size(); ++i) {
            n = 31 * n + this.terms.get(i).hashCode();
        }
        return n;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

