/*
 * Decompiled with CFR 0.152.
 */
package g2d.tabwin.menus;

import g2d.tabwin.TabFrame;
import g2d.tabwin.TabPanel;
import g2d.tabwin.TabUtils;
import g2d.tabwin.menus.ViewMenuListener;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ViewMenu
extends JMenu {
    private final Container owner;
    private final JMenuItem minitem;
    private final JMenuItem closeitem;
    public final List<JMenuItem> additions = new ArrayList<JMenuItem>();

    public ViewMenu(Container container) {
        super("View");
        this.owner = container;
        this.minitem = this.minimizeMe();
        this.closeitem = this.closeMe();
        this.populate();
        this.addMenuListener(new ViewMenuListener(container, this));
    }

    protected void populate() {
        this.add(this.minitem);
        this.add(this.closeitem);
        this.addSeparator();
    }

    protected void depopulate() {
        this.removeAll();
        this.populate();
    }

    private JMenuItem minimizeMe() {
        JMenuItem jMenuItem = new JMenuItem("Minimize");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabFrame tabFrame = TabUtils.getTabFrame(ViewMenu.this.owner);
                if (tabFrame != null) {
                    int n = tabFrame.getExtendedState();
                    tabFrame.setExtendedState(n |= 1);
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem closeMe() {
        JMenuItem jMenuItem = new JMenuItem("Close Tab");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                TabFrame tabFrame = TabUtils.getTabFrame(ViewMenu.this.owner);
                if (tabFrame != null && ViewMenu.this.owner instanceof TabPanel && (n = tabFrame.indexOfTabPanel((TabPanel)ViewMenu.this.owner)) != -1) {
                    tabFrame.removeTabPanelAt(n);
                    ((TabPanel)ViewMenu.this.owner).dispose();
                }
            }
        });
        return jMenuItem;
    }
}

