/*
 * Decompiled with CFR 0.152.
 */
package g2d.tabwin;

import g2d.jlambda.Closure;
import g2d.tabwin.AppFrame;
import g2d.tabwin.TabControl;
import g2d.tabwin.TabPanel;
import g2d.tabwin.TabPreferences;
import g2d.util.Preferences;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JTabbedPane;

public class TabFrame
extends AppFrame {
    public static final Preferences g2d_preferences = TabPreferences.g2d_preferences;
    private final JTabbedPane tabs = new JTabbedPane();
    static final ArrayList<Closure> creationClosures = new ArrayList();

    public TabFrame() {
        this("PLA");
    }

    public TabFrame(String string) {
        this(null, string);
    }

    public TabFrame(TabPanel tabPanel) {
        this(tabPanel, "PLA");
    }

    public TabFrame(TabPanel tabPanel, String string) {
        super(string + " Tab Frame");
        this.tabs.setTabLayoutPolicy(0);
        g2d_preferences.manageJFrame(this, string);
        this.add(this.tabs);
        if (tabPanel != null) {
            this.addTabPanel(tabPanel);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        int n = this.getTabPanelCount();
        for (int i = 0; i < n; ++i) {
            TabPanel tabPanel = this.getTabPanelAt(i);
            if (tabPanel == null) continue;
            tabPanel.dispose();
        }
    }

    public static void addCreationClosure(Closure closure) {
        creationClosures.add(closure);
    }

    public int getTabPanelCount() {
        return this.tabs.getTabCount();
    }

    public TabPanel getFocusedTabPanel() {
        TabPanel tabPanel = null;
        Component component = this.tabs.getSelectedComponent();
        if (component instanceof TabPanel) {
            tabPanel = (TabPanel)component;
        }
        return tabPanel;
    }

    public int indexOfTabControl(TabControl tabControl) {
        return this.tabs.indexOfTabComponent(tabControl);
    }

    public int indexOfTabPanel(TabPanel tabPanel) {
        return this.tabs.indexOfComponent(tabPanel);
    }

    public void focusTabPanelAt(int n) {
        this.tabs.setSelectedIndex(n);
    }

    public void focusTabPanel(TabPanel tabPanel) {
        this.tabs.setSelectedComponent(tabPanel);
    }

    public TabPanel getTabPanelAt(int n) {
        TabPanel tabPanel = null;
        Component component = this.tabs.getComponentAt(n);
        if (component instanceof TabPanel) {
            tabPanel = (TabPanel)component;
        }
        return tabPanel;
    }

    public void removeTabPanel(TabPanel tabPanel) {
        int n = this.getTabPanelCount();
        for (int i = 0; i < n; ++i) {
            TabPanel tabPanel2 = this.getTabPanelAt(i);
            if (tabPanel2 != tabPanel) continue;
            this.removeTabPanelAt(i);
            break;
        }
    }

    public void removeTabPanelAt(int n) {
        this.tabs.remove(n);
        if (this.tabs.getTabCount() == 0) {
            this.dispose();
        }
    }

    public void addTabPanel(TabPanel tabPanel) {
        int n = this.tabs.getTabCount();
        this.tabs.addTab(tabPanel.title, null, tabPanel, tabPanel.toolTip);
        this.tabs.setTabComponentAt(n, new TabControl(this, tabPanel));
    }

    public void addTabPanel(int n, TabPanel tabPanel) {
        this.tabs.insertTab(tabPanel.title, null, tabPanel, tabPanel.toolTip, n);
        this.tabs.setTabComponentAt(n, new TabControl(this, tabPanel));
    }

    public void addTabPanel(int n, TabPanel tabPanel, boolean bl) {
        this.addTabPanel(n, tabPanel);
        if (bl) {
            this.tabs.setSelectedIndex(n);
        }
    }

    public void insertBefore(int n, int n2) {
        if (n2 == n) {
            return;
        }
        int n3 = n2;
        TabPanel tabPanel = this.getTabPanelAt(n);
        this.removeTabPanelAt(n);
        if (n < n2) {
            --n3;
        }
        this.addTabPanel(n3, tabPanel);
    }

    public void insertAfter(int n, int n2) {
        if (n2 == n) {
            return;
        }
        int n3 = n2;
        TabPanel tabPanel = this.getTabPanelAt(n);
        this.removeTabPanelAt(n);
        if (n2 < n) {
            --n3;
        }
        this.addTabPanel(n3, tabPanel);
    }

    @Override
    public boolean containsLocationOnScreen(Point point) {
        return this.contains(point.x - this.getX(), point.y - this.getY());
    }

    @Override
    public String toString() {
        return "TabFrame_" + this.id;
    }
}

