/*
 * Decompiled with CFR 0.152.
 */
package g2d.tabwin;

import g2d.tabwin.DragWindow;
import g2d.tabwin.TabFrame;
import g2d.tabwin.TabInsertionHandler;
import g2d.tabwin.TabPanel;
import g2d.tabwin.TabUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabControl
extends JPanel {
    private final TabFrame owner;
    private final TabPanel panel;
    protected static final Cursor hand = new Cursor(12);
    protected static final Cursor cursor = new Cursor(0);
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(false);
            }
        }
    };

    public TabControl(TabFrame tabFrame, final TabPanel tabPanel) {
        super(new FlowLayout(0, 0, 0));
        if (tabFrame == null) {
            throw new NullPointerException("TabFrame is null");
        }
        this.owner = tabFrame;
        this.panel = tabPanel;
        this.setOpaque(false);
        JLabel jLabel = new JLabel(){

            @Override
            public String getText() {
                int n = TabControl.this.getIndex();
                if (n != -1) {
                    return tabPanel.title;
                }
                return null;
            }

            @Override
            public String toString() {
                return "TabLabel_" + TabControl.this.getIndex();
            }
        };
        this.add(new TabGripper());
        this.add(jLabel);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        TabCloseButton tabCloseButton = new TabCloseButton();
        this.add(tabCloseButton);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    public int getIndex() {
        return this.owner.indexOfTabControl(this);
    }

    private class TabDragListener
    extends MouseAdapter
    implements MouseListener,
    MouseMotionListener {
        DragWindow dragWindow;
        boolean visible = false;

        private TabDragListener() {
        }

        private DragWindow createDragWindow() {
            TabFrame tabFrame = TabUtils.getTabFrame(TabControl.this);
            DragWindow dragWindow = new DragWindow((Window)tabFrame, TabControl.this.getLocationOnScreen());
            return dragWindow;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.dragWindow == null) {
                this.dragWindow = this.createDragWindow();
            }
            if (!this.visible) {
                this.visible = true;
                this.dragWindow.moveTo(mouseEvent.getX(), mouseEvent.getY());
                this.dragWindow.setVisible(true);
            } else {
                this.dragWindow.moveTo(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.visible) {
                Point point = this.dragWindow.getLocationOnScreen();
                TabFrame tabFrame = TabUtils.getTabFrameAtLocation(point);
                this.visible = false;
                if (tabFrame == null) {
                    TabUtils.launchTab(TabUtils.getTabFrame(TabControl.this), TabControl.this.getIndex(), point);
                } else if (((TabControl)TabControl.this).owner.id == tabFrame.id) {
                    Point point2 = mouseEvent.getLocationOnScreen();
                    int n = point2.x - TabControl.this.owner.getX();
                    int n2 = point2.y - TabControl.this.owner.getY();
                    Component component = TabControl.this.owner.findComponentAt(n, n2);
                    if (component != null && component instanceof TabInsertionHandler) {
                        TabInsertionHandler tabInsertionHandler = (TabInsertionHandler)((Object)component);
                        tabInsertionHandler.handleInsertion(TabControl.this.getIndex());
                    }
                } else {
                    TabUtils.transferTab(TabUtils.getTabFrame(TabControl.this), TabControl.this.getIndex(), tabFrame);
                }
                this.dragWindow.setVisible(false);
                this.dragWindow.dispose();
                this.dragWindow = null;
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            TabControl.this.setCursor(hand);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TabControl.this.setCursor(cursor);
        }
    }

    private class TabCloseButton
    extends JButton
    implements ActionListener,
    TabInsertionHandler {
        public TabCloseButton() {
            int n = 17;
            this.setPreferredSize(new Dimension(n, n));
            this.setToolTipText("close this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TabControl.this.owner.indexOfTabControl(TabControl.this);
            TabControl.this.owner.removeTabPanelAt(n);
            TabControl.this.panel.dispose();
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.getModel().isPressed()) {
                graphics2D.translate(1, 1);
            }
            graphics2D.setStroke(new BasicStroke(1.5f, 1, 1));
            graphics2D.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                graphics2D.setColor(Color.RED);
            }
            int n = 5;
            graphics2D.drawLine(n, n, this.getWidth() - n - 1, this.getHeight() - n - 1);
            graphics2D.drawLine(this.getWidth() - n - 1, n, n, this.getHeight() - n - 1);
            graphics2D.dispose();
        }

        @Override
        public String toString() {
            return "TabCloseButton_" + TabControl.this.getIndex();
        }

        @Override
        public void handleInsertion(int n) {
            TabControl.this.owner.insertAfter(n, TabControl.this.getIndex());
        }
    }

    private class TabGripper
    extends JButton
    implements TabInsertionHandler {
        TabDragListener tabDragListener;

        public TabGripper() {
            this.tabDragListener = new TabDragListener();
            int n = 17;
            this.setPreferredSize(new Dimension(n, n));
            this.setToolTipText("Gripper for dragging and dropping this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.addMouseListener(this.tabDragListener);
            this.addMouseMotionListener(this.tabDragListener);
            this.setRolloverEnabled(true);
        }

        @Override
        public String toString() {
            return "TabGripper_" + TabControl.this.getIndex();
        }

        @Override
        public void handleInsertion(int n) {
            TabControl.this.owner.insertBefore(n, TabControl.this.getIndex());
        }
    }
}

