/*
 * Decompiled with CFR 0.152.
 */
package g2d.swing;

import g2d.jlambda.Closure;
import g2d.util.IO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IOPSingleSelect
extends JDialog
implements ListSelectionListener {
    private DefaultListModel<Object> listModel = new DefaultListModel();
    private JList<Object> list = new JList<Object>(this.listModel);
    private JPanel buttonPane = new JPanel();
    private String value;
    private HashMap<String, Closure> actions = new HashMap();
    private Frame parent;
    private String cancelButtonLabel = "Dismiss";
    private boolean persistAfterSelection = false;

    private void addToModel(Collection<?> collection) {
        if (collection == null) {
            return;
        }
        for (Object obj : collection) {
            if (!(obj instanceof String)) continue;
            this.listModel.addElement((String)obj);
        }
    }

    private void addToModel(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof String)) continue;
            this.listModel.addElement((String)object);
        }
    }

    public IOPSingleSelect(Frame frame, String string, String string2) {
        super(frame, string, true);
        this.parent = frame;
        this.configure(string, string2);
    }

    public IOPSingleSelect(Frame frame, Collection<?> collection, String string, String string2) {
        super(frame, string, true);
        this.parent = frame;
        this.addToModel(collection);
        this.configure(string, string2);
    }

    public IOPSingleSelect(Frame frame, Object[] objectArray, String string, String string2) {
        super(frame, string, true);
        this.parent = frame;
        this.addToModel(objectArray);
        this.configure(string, string2);
    }

    public void addAction(String string, Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("IOPSingleSelect.addAction: closure arity not 2 -- " + closure);
        } else {
            if (!this.listModel.contains(string)) {
                this.listModel.addElement(string);
            }
            this.actions.put(string, closure);
        }
    }

    public void addAction(String[] stringArray, Object[] objectArray, Closure closure) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Closure closure2 = (Closure)closure.applyClosure(string, objectArray[i]);
            this.addAction(string, closure2);
        }
    }

    private void configure(String string, String string2) {
        JButton jButton = new JButton(this.cancelButtonLabel);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IOPSingleSelect.this.list.clearSelection();
                IOPSingleSelect.this.value = null;
                IOPSingleSelect.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(string2);
        jLabel.setLabelFor(this.list);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
        this.buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.buttonPane.add(Box.createHorizontalGlue());
        this.buttonPane.add(jButton);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        container.add((Component)this.buttonPane, "South");
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    public void addButton(JButton jButton) {
        this.buttonPane.add(jButton);
        this.pack();
    }

    public void setPersistAfterSelection(boolean bl) {
        this.persistAfterSelection = bl;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (!this.list.isSelectionEmpty()) {
            this.doSelectAction(listSelectionEvent);
        }
    }

    private void doSelectAction(ListSelectionEvent listSelectionEvent) {
        this.value = (String)this.list.getSelectedValue();
        Closure closure = this.actions.get(this.value);
        if (closure != null) {
            closure.applyClosure(this, listSelectionEvent);
        }
        this.list.clearSelection();
        if (!this.persistAfterSelection) {
            this.setVisible(false);
        }
    }
}

