/*
 * Decompiled with CFR 0.152.
 */
package g2d.swing;

import g2d.util.IO;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class IOPFileChooser
extends JFileChooser {
    private static Preferences preferences;
    private static File previousDirectory;
    private Map<String, FileFilter> filter_map = new HashMap<String, FileFilter>();
    private FileFilter defaultFileFilter = null;
    private String directoryPrefString = null;
    private String filterPrefString = null;
    private String filePrefString = null;

    public IOPFileChooser(String string, String string2, String string3) {
        this.directoryPrefString = string;
        this.filterPrefString = string2;
        this.filePrefString = string3;
        this.situate();
    }

    public IOPFileChooser(String string) {
        this(string, null, null);
    }

    public IOPFileChooser() {
        this(null, null, null);
    }

    public static void setPreferences(Preferences preferences) {
        IOPFileChooser.preferences = preferences;
    }

    @Override
    public void addChoosableFileFilter(FileFilter fileFilter) {
        super.addChoosableFileFilter(fileFilter);
        String string = fileFilter.getDescription();
        if (fileFilter != null && this.filter_map != null) {
            this.filter_map.put(string, fileFilter);
        }
        this.defaultFileFilter = fileFilter;
    }

    public void situate() {
        this.situate_dir();
        this.situate_filter();
        this.situate_file();
    }

    private void situate_dir() {
        String string = null;
        if (preferences != null && this.directoryPrefString != null) {
            string = preferences.get(this.directoryPrefString, null);
        }
        if (string != null) {
            this.setCurrentDirectory(new File(string));
        } else if (previousDirectory != null) {
            this.setCurrentDirectory(previousDirectory);
        }
    }

    private void situate_filter() {
        String string = null;
        if (preferences != null && this.filterPrefString != null) {
            string = preferences.get(this.filterPrefString, null);
        }
        if (string != null) {
            FileFilter fileFilter = this.filter_map.get(string);
            if (fileFilter != null) {
                this.setFileFilter(fileFilter);
            }
        } else if (this.defaultFileFilter != null) {
            this.setFileFilter(this.defaultFileFilter);
        }
    }

    private void situate_file() {
        File file;
        String string = null;
        if (preferences != null && this.filePrefString != null) {
            string = preferences.get(this.filePrefString, null);
        }
        if (string != null && (file = new File(string)) != null) {
            this.setSelectedFile(file);
        }
    }

    private void remember_dir(File file) {
        if (preferences != null && this.directoryPrefString != null) {
            String string = file.toString();
            preferences.put(this.directoryPrefString, string);
        } else {
            previousDirectory = file;
        }
    }

    private void remember_file(File file) {
        if (preferences != null && this.filePrefString != null) {
            String string = file.toString();
            preferences.put(this.filePrefString, string);
        }
    }

    private void remember_filter(FileFilter fileFilter) {
        if (preferences != null && this.filterPrefString != null) {
            String string = fileFilter.getDescription();
            preferences.put(this.filterPrefString, string);
        }
    }

    private int wrapShow(int n) {
        if (n == 0) {
            this.remember_dir(this.getCurrentDirectory());
            this.remember_filter(this.getFileFilter());
            this.remember_file(this.getSelectedFile());
        }
        return n;
    }

    @Override
    public int showDialog(Component component, String string) {
        return this.wrapShow(super.showDialog(component, string));
    }

    @Override
    public int showOpenDialog(Component component) {
        return this.wrapShow(super.showOpenDialog(component));
    }

    @Override
    public int showSaveDialog(Component component) {
        return this.wrapShow(super.showSaveDialog(component));
    }

    public static void reset() {
        previousDirectory = null;
    }

    public static boolean setDirectory(String string) {
        if (string == null) {
            return false;
        }
        previousDirectory = new File(string = IO.interpretTilde(string));
        return previousDirectory != null;
    }
}

