/*
 * Decompiled with CFR 0.152.
 */
package g2d.swing;

import g2d.glyph.Glyph;
import g2d.glyph.GlyphList;
import g2d.glyph.Glyphish;
import g2d.graph.IOPGraph;
import g2d.jlambda.Closure;
import g2d.swing.ZoomListener;
import g2d.util.IO;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JViewport;

public class IOPComponent
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener,
MouseWheelListener {
    private GlyphList glyphList = new GlyphList();
    private Glyphish selected;
    private AffineTransform zoomTrans;
    private AffineTransform invZoomTrans;
    private Rectangle2D thisBound;
    public static final boolean DEBUG = false;
    private Closure mouseClickedAction;
    private Closure mouseDraggedAction;
    private Closure mouseEnteredAction;
    private Closure mouseExitedAction;
    private Closure mouseMovedAction;
    private Closure mousePressedAction;
    private Closure mouseReleasedAction;
    private HashSet<ZoomListener> zoomListeners = new HashSet();
    private Closure keyPressedAction;
    private Closure keyReleasedAction;
    private Closure keyTypedAction;

    public IOPComponent() {
        this.zoomTrans = new AffineTransform();
        this.invZoomTrans = new AffineTransform();
        this.setDoubleBuffered(true);
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.thisBound = new Rectangle2D.Double(0.0, 0.0, 500.0, 500.0);
        this.checkSize();
    }

    public synchronized void add(Glyphish glyphish) {
        this.glyphList.add(glyphish);
        this.checkSize();
    }

    public synchronized void remove(Glyphish glyphish) {
        this.glyphList.remove(glyphish);
        this.checkSize();
    }

    public synchronized void setGraph(IOPGraph iOPGraph) {
        this.glyphList.clear();
        if (iOPGraph != null) {
            this.glyphList = iOPGraph;
        }
        this.checkSize();
    }

    public synchronized void add(Glyphish glyphish, AffineTransform affineTransform) {
        this.glyphList.add(glyphish);
        glyphish.transform(affineTransform);
        this.checkSize();
    }

    public boolean isGlyphishVisible(Glyphish glyphish) {
        if (glyphish == null) {
            return false;
        }
        return this.getViewRectangle().contains(glyphish.getBounds());
    }

    public void setMouseAction(int n, Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("IOPComponent.setAction: closure arity not 2 -- " + closure);
        } else {
            switch (n) {
                case 500: {
                    this.mouseClickedAction = closure;
                    return;
                }
                case 506: {
                    this.mouseDraggedAction = closure;
                    return;
                }
                case 504: {
                    this.mouseEnteredAction = closure;
                    return;
                }
                case 505: {
                    this.mouseExitedAction = closure;
                    return;
                }
                case 503: {
                    this.mouseMovedAction = closure;
                    return;
                }
                case 501: {
                    this.mousePressedAction = closure;
                    return;
                }
                case 502: {
                    this.mouseReleasedAction = closure;
                    return;
                }
            }
            IO.err.println("IOPComponent.setMouseAction: unrecognized type -- " + n);
        }
    }

    private void takeAction(Closure closure, AWTEvent aWTEvent) {
        if (closure != null) {
            closure.applyClosure(this, aWTEvent);
        }
    }

    @Override
    public synchronized void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        System.err.println("FIXME: IOPComponent.paintComponent needs to set the clip");
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(this.getForeground());
        graphics2D.transform(this.zoomTrans);
        this.setBackground(Color.white);
        this.glyphList.paint(graphics2D);
    }

    public void checkSize() {
        Rectangle2D rectangle2D = this.glyphList.getBounds();
        double d = this.thisBound.getWidth();
        double d2 = this.thisBound.getHeight();
        if (rectangle2D != null) {
            if (rectangle2D.getMaxX() > this.thisBound.getMaxX()) {
                d = rectangle2D.getMaxX();
            }
            if (rectangle2D.getMaxY() > this.thisBound.getMaxY()) {
                d2 = rectangle2D.getMaxY();
            }
            this.thisBound.setRect(0.0, 0.0, d, d2);
        }
        Rectangle2D rectangle2D2 = this.zoomBound(this.thisBound.getBounds());
        this.setPreferredSize(new Dimension((int)rectangle2D2.getMaxX(), (int)rectangle2D2.getMaxY()));
        this.revalidate();
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this.zoomListeners.add(zoomListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        this.zoomListeners.remove(zoomListener);
    }

    private void notifyZoomListeners() {
        Iterator<ZoomListener> iterator = this.zoomListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().zoomChanged(this.getZoomScale());
        }
    }

    public double getZoomScale() {
        return this.zoomTrans.getScaleX();
    }

    public void zoom(double d) {
        this.zoom1(d);
        this.centerOn(this.glyphList.getBounds());
    }

    private void zoom1(double d) {
        this.zoomTrans.scale(d, d);
        try {
            this.invZoomTrans = this.zoomTrans.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            System.err.println(noninvertibleTransformException);
        }
        Rectangle2D rectangle2D = this.zoomBound(this.thisBound.getBounds2D());
        this.setPreferredSize(new Dimension((int)rectangle2D.getMaxX(), (int)rectangle2D.getMaxY()));
        this.checkSize();
        this.repaint();
        this.notifyZoomListeners();
    }

    public void centerOn(Glyphish glyphish) {
        if (glyphish != null) {
            this.centerOn(glyphish.getBounds());
        }
    }

    public AffineTransform centerOn(Rectangle2D rectangle2D) {
        AffineTransform affineTransform = new AffineTransform();
        if (rectangle2D != null) {
            Rectangle2D rectangle2D2 = this.zoomBound(rectangle2D.getBounds2D());
            Rectangle2D rectangle2D3 = this.getViewRectangle();
            double d = rectangle2D2.getX() - rectangle2D3.getX() - (rectangle2D3.getWidth() - rectangle2D2.getWidth()) / 2.0;
            double d2 = rectangle2D2.getY() - rectangle2D3.getY() - (rectangle2D3.getHeight() - rectangle2D2.getHeight()) / 2.0;
            this.scrollRectToVisible(AffineTransform.getTranslateInstance(d, d2).createTransformedShape(rectangle2D3.getBounds()).getBounds());
            Rectangle2D rectangle2D4 = this.getViewRectangle();
            if (!rectangle2D3.equals(rectangle2D4)) {
                affineTransform = AffineTransform.getTranslateInstance(rectangle2D3.getX() - rectangle2D4.getX(), rectangle2D3.getY() - rectangle2D4.getY());
            }
        }
        return affineTransform;
    }

    private Rectangle2D getViewRectangle() {
        Container container = this.getParent();
        Glyph glyph = container instanceof JViewport ? new Glyph(((JViewport)container).getViewRect()) : new Glyph(this.getVisibleRect());
        glyph.transform(this.invZoomTrans);
        return glyph.getBounds();
    }

    public Rectangle2D zoomBound(Rectangle2D rectangle2D) {
        if (rectangle2D != null) {
            double d = this.getZoomScale();
            if (d == 1.0) {
                return rectangle2D;
            }
            double d2 = rectangle2D.getWidth() * d;
            double d3 = rectangle2D.getHeight() * d;
            double d4 = rectangle2D.getX() * d;
            double d5 = rectangle2D.getY() * d;
            rectangle2D.setRect(d4, d5, d2, d3);
        }
        return rectangle2D;
    }

    public void zoomToFit(double d, double d2, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.zoomBound(rectangle2D.getBounds2D());
        if (rectangle2D2 != null) {
            double d3 = d / rectangle2D2.getWidth();
            double d4 = d2 / rectangle2D2.getHeight();
            if (d3 == 0.0 || d4 == 0.0) {
                d3 = 1.0;
                d4 = 1.0;
            }
            if (d3 <= d4) {
                this.zoom1(d3);
            } else {
                this.zoom1(d4);
            }
        }
        this.centerOn(rectangle2D);
    }

    public void zoomToFit(double d, double d2) {
        Rectangle2D rectangle2D = this.zoomBound(this.glyphList.getBounds());
        if (rectangle2D != null) {
            double d3 = d / rectangle2D.getWidth();
            double d4 = d2 / rectangle2D.getHeight();
            if (d3 == 0.0 || d4 == 0.0) {
                d3 = 1.0;
                d4 = 1.0;
            }
            if (d3 <= d4) {
                this.zoom(d3);
            } else {
                this.zoom(d4);
            }
        }
    }

    public void zoomToOriginal() {
        this.zoomTrans.setToIdentity();
        this.zoom(1.0);
    }

    public Point2D zoomPoint(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Point2D point2D = this.invZoomTrans.transform(point, null);
        mouseEvent.translatePoint((int)(point2D.getX() - ((Point2D)point).getX()), (int)(point2D.getY() - ((Point2D)point).getY()));
        return point2D;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        double d = 0.2;
        this.zoom(1.0 + (double)mouseWheelEvent.getWheelRotation() * d);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Point2D point2D = this.zoomPoint(mouseEvent);
        Glyphish glyphish = this.glyphList.getGlyphThing(point2D);
        if (glyphish != null) {
            glyphish.mouseReleased(mouseEvent);
        }
        this.takeAction(this.mouseReleasedAction, mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Glyphish glyphish;
        Point2D point2D = this.zoomPoint(mouseEvent);
        this.selected = glyphish = this.glyphList.getGlyphThing(point2D);
        Glyphish glyphish2 = glyphish;
        if (glyphish2 != null) {
            glyphish2.mousePressed(mouseEvent);
        }
        this.takeAction(this.mousePressedAction, mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Point2D point2D = this.zoomPoint(mouseEvent);
        Glyphish glyphish = this.glyphList.getGlyphThing(point2D);
        if (glyphish != null) {
            glyphish.mouseExited(mouseEvent);
        }
        this.takeAction(this.mouseExitedAction, mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Point2D point2D = this.zoomPoint(mouseEvent);
        Glyphish glyphish = this.glyphList.getGlyphThing(point2D);
        if (glyphish != null) {
            glyphish.mouseEntered(mouseEvent);
        }
        this.takeAction(this.mouseEnteredAction, mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        Point2D point2D = this.zoomPoint(mouseEvent);
        Glyphish glyphish = this.glyphList.getGlyphThing(point2D);
        if (glyphish != null) {
            glyphish.mouseClicked(mouseEvent);
        } else {
            System.err.println("Nothing there!");
        }
        this.takeAction(this.mouseClickedAction, mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point2D point2D = this.zoomPoint(mouseEvent);
        Glyphish glyphish = this.glyphList.getGlyphThing(point2D);
        if (glyphish != null) {
            glyphish.mouseMoved(mouseEvent);
        }
        this.takeAction(this.mouseMovedAction, mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point2D point2D = this.zoomPoint(mouseEvent);
        Glyphish glyphish = this.glyphList.getGlyphThing(point2D);
        if (glyphish != null) {
            glyphish.mouseDragged(mouseEvent);
        }
        this.takeAction(this.mouseDraggedAction, mouseEvent);
    }

    public void setKeyAction(int n, Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("IOPComponent.setKeyAction: closure arity not 2 -- " + closure);
        } else {
            switch (n) {
                case 401: {
                    this.keyPressedAction = closure;
                    return;
                }
                case 402: {
                    this.keyReleasedAction = closure;
                    return;
                }
                case 400: {
                    this.keyTypedAction = closure;
                    return;
                }
            }
            IO.err.println("IOPComponent.setKeyAction: unrecognized type -- " + n);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.selected != null) {
            this.selected.keyTyped(keyEvent);
        }
        this.takeAction(this.keyTypedAction, keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.selected != null) {
            this.selected.keyReleased(keyEvent);
        }
        this.takeAction(this.keyReleasedAction, keyEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.selected != null) {
            this.selected.keyPressed(keyEvent);
        }
        this.takeAction(this.keyPressedAction, keyEvent);
    }
}

