/*
 * Decompiled with CFR 0.152.
 */
package g2d.subset;

import g2d.jlambda.Closure;
import g2d.subset.DEvent;
import g2d.subset.DPanel;
import g2d.subset.SEvent;
import g2d.subset.Universe;
import g2d.subset.Urelement;
import g2d.swing.IOPFileChooser;
import g2d.swing.IOPFileFilter;
import g2d.util.IO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class DDialog
extends JDialog {
    private static final String SCOPE = "Scope";
    private static final String DISH = "Dish";
    private Closure oKClosure;
    protected Frame parent;
    protected Universe dish;
    protected DPanel dishPanel = new DPanel(1);
    protected Universe scope;
    protected DPanel scopePanel = new DPanel(1);
    private boolean uninitialized = true;

    public void add2DishToolbar(Component component) {
        this.dishPanel.add2Toolbar(component);
    }

    public String[] getSelected() {
        return this.dish.getStrings();
    }

    public String[] getSelected(int n) {
        return this.dish.getStrings(n);
    }

    public boolean saveEntriesToFile() {
        IOPFileChooser iOPFileChooser = new IOPFileChooser("raw_text_area");
        IOPFileFilter iOPFileFilter = new IOPFileFilter("Text Files");
        iOPFileFilter.setFilesOnly(true);
        iOPFileFilter.addExtension("txt");
        iOPFileChooser.setFileFilter(iOPFileFilter);
        int n = ((JFileChooser)iOPFileChooser).showSaveDialog(this.parent);
        if (n == 0) {
            String[] stringArray = this.dish.getStrings();
            File file = iOPFileChooser.getSelectedFile();
            IO.array2File(stringArray, file);
            return true;
        }
        return false;
    }

    public String[] getEntriesFromFile() {
        String[] stringArray = null;
        IOPFileChooser iOPFileChooser = new IOPFileChooser("raw_text_area");
        IOPFileFilter iOPFileFilter = new IOPFileFilter("Text Files");
        iOPFileFilter.setFilesOnly(true);
        iOPFileFilter.addExtension("txt");
        iOPFileChooser.setFileFilter(iOPFileFilter);
        int n = ((JFileChooser)iOPFileChooser).showOpenDialog(this.parent);
        if (n == 0) {
            try {
                stringArray = IO.file2Array(iOPFileChooser.getSelectedFile().getCanonicalPath(), true);
            }
            catch (Exception exception) {
                IO.err.println("DDialog. getEntriesFromFile() failed!");
            }
        }
        return stringArray;
    }

    public boolean setScope(String[] stringArray) {
        if (this.scope == null && stringArray != null) {
            this.scope = new Universe(stringArray);
            this.scope.name = SCOPE;
            this.scopePanel.setUniverse(SCOPE, this.scope);
            this.dish = new Universe(new String[0]);
            this.dish.name = DISH;
            this.dishPanel.setUniverse(DISH, this.dish);
            return true;
        }
        return false;
    }

    public boolean setScope(String[] stringArray, String[] stringArray2) {
        if (this.scope == null && stringArray != null && stringArray2 != null) {
            this.scope = new Universe(stringArray, stringArray2);
            this.scope.name = SCOPE;
            this.scopePanel.setUniverse(SCOPE, this.scope);
            this.dish = new Universe(new String[0]);
            this.dish.name = DISH;
            this.dishPanel.setUniverse(DISH, this.dish);
            return true;
        }
        return false;
    }

    private String[][] toArray(ArrayList<?>[] arrayListArray) {
        String[][] stringArray = new String[arrayListArray.length][];
        for (int i = 0; i < arrayListArray.length; ++i) {
            ArrayList<?> arrayList = arrayListArray[i];
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int j = 0; j < arrayList.size(); ++j) {
                Object e = arrayList.get(j);
                if (!(e instanceof String)) continue;
                arrayList2.add((String)e);
            }
            stringArray[i] = arrayList2.toArray(new String[arrayList2.size()]);
        }
        return stringArray;
    }

    public boolean setScope(String[] stringArray, ArrayList<?>[] arrayListArray) {
        if (this.scope == null && stringArray != null && arrayListArray != null) {
            String[][] stringArray2 = this.toArray(arrayListArray);
            this.scope = new Universe(stringArray, stringArray2);
            this.scope.name = SCOPE;
            this.scopePanel.setUniverse(SCOPE, this.scope);
            this.dish = new Universe(new String[0]);
            this.dish.name = DISH;
            this.dishPanel.setUniverse(DISH, this.dish);
            return true;
        }
        return false;
    }

    public static String[] getLocations(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.lastIndexOf(45);
            if (n == -1) continue;
            stringArray2[i] = string.substring(n + 1);
        }
        return stringArray2;
    }

    public boolean addTab(String string) {
        if (this.scope != null && this.dish != null) {
            this.scopePanel.addTab(string, SCOPE);
            this.dishPanel.addTab(string, DISH);
            return true;
        }
        return false;
    }

    public void classify(String string, String[] stringArray, String[] stringArray2) {
        this.scope.classify(string, stringArray, stringArray2);
    }

    public String add2Dish(String[] stringArray) {
        String string = null;
        if (this.scope != null && stringArray != null) {
            ArrayList<Urelement> arrayList = this.scope.intersect(stringArray);
            string = this.scope.basisAdd(arrayList);
            if (stringArray != null) {
                this.dish.fireDEvent(new DEvent(this.scope, arrayList, 1));
                this.scope.fireDEvent(new DEvent(this.scope, arrayList, 2));
            }
        }
        return string;
    }

    private void _fireUpdate() {
        if (this.scope != null) {
            DEvent dEvent = new DEvent(this.scope, 1);
            SEvent sEvent = new SEvent(dEvent);
            this.scope.fireSEvent(sEvent);
        }
    }

    public void fakeSpatialTab() {
        this.scope.createSpatial();
        this.addTab("Spatial");
    }

    public DDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.parent = frame;
        this.setLayout(new BorderLayout());
        this.dishPanel.addButtonAction(new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DDialog.this.dish != null && DDialog.this.scope != null) {
                    DDialog.this.scope.fireDEvent(new DEvent(DDialog.this.dish, 1, 1));
                    DDialog.this.dish.fireDEvent(new DEvent(DDialog.this.dish, 2, 1));
                }
            }
        });
        this.scopePanel.addToolbarAction(new AbstractAction(SCOPE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DDialog.this.scope != null) {
                    IO.err.println("Scope already set!");
                    return;
                }
                String[] stringArray = DDialog.this.getEntriesFromFile();
                if (!DDialog.this.setScope(stringArray)) {
                    IO.err.println("Setting scope failed!");
                } else {
                    DDialog.this._fireUpdate();
                }
            }
        });
        this.scopePanel.addButtonAction(new AbstractAction("Add"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DDialog.this.scope != null) {
                    DDialog.this.dish.fireDEvent(new DEvent(DDialog.this.scope, 1, 1));
                    DDialog.this.scope.fireDEvent(new DEvent(DDialog.this.scope, 2, 1));
                }
            }
        });
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this.dishPanel);
        jSplitPane.setRightComponent(this.scopePanel);
        jSplitPane.setPreferredSize(new Dimension(500, 600));
        jSplitPane.setDividerLocation(250);
        this.add((Component)jSplitPane, "Center");
        this.add((Component)this.makeButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    public void setOKClosure(Closure closure) {
        if (closure.getArity() != 2) {
            IO.err.println("DDialog.setOKClosure: closure arity not 2 -- " + closure);
        } else {
            this.oKClosure = closure;
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.uninitialized) {
            this._fireUpdate();
            this.uninitialized = false;
        }
        super.setVisible(bl);
    }

    private JPanel makeButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Dismiss");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DDialog.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DDialog.this.oKClosure != null) {
                    DDialog.this.oKClosure.applyClosure(DDialog.this, actionEvent);
                }
                DDialog.this.setVisible(false);
            }
        });
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton2);
        jPanel.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    public void createSpatial(Universe universe) {
        ArrayList<Urelement> arrayList = universe.universe;
        for (Urelement urelement : arrayList) {
            String string = urelement.toString();
            int n = string.lastIndexOf(45);
            if (n == -1) continue;
            String string2 = string.substring(n + 1);
            urelement.classify("Spatial", string2);
        }
    }

    private static void createAndShowGUI(String[] stringArray) {
        JFrame jFrame = new JFrame("DDialog Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setPreferredSize(new Dimension(100, 100));
        DDialog dDialog = new DDialog((Frame)jFrame, true);
        if (stringArray != null && stringArray.length >= 2) {
            String[] stringArray2 = IO.file2Array(stringArray[0], true);
            String[] stringArray3 = IO.file2Array(stringArray[1], true);
            if (stringArray2 != null) {
                dDialog.setScope(stringArray2, stringArray3);
                dDialog.scope.createSpatial();
                dDialog.addTab("Spatial");
            }
            if (stringArray.length > 2) {
                String string = dDialog.add2Dish(IO.file2Array(stringArray[2], true));
                IO.err.println("ddialog.add2Dish: " + string);
            }
        }
        jFrame.pack();
        jFrame.setVisible(true);
        dDialog.setVisible(true);
    }

    public static void test(String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DDialog.createAndShowGUI(null);
            }
        });
    }

    public static void main(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DDialog.createAndShowGUI(stringArray);
            }
        });
    }
}

