/*
 * Decompiled with CFR 0.152.
 */
package g2d.stats;

import g2d.jlambda.Attributable;
import g2d.stats.Statistics;

public class StatisticsImpl
implements Statistics {
    public static TimeUnit timeUnit = TimeUnit.MILLISECOND;
    public final String handle;
    private long startTime = -1L;
    private long stopTime = -1L;

    public StatisticsImpl(String string) {
        this.handle = string;
        try {
            Attributable.setUID(string, this);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private long getTime() {
        switch (timeUnit) {
            case SECOND: {
                return System.currentTimeMillis() / 1000L;
            }
            case MILLISECOND: {
                return System.currentTimeMillis();
            }
            case NANOSECOND: {
                return System.nanoTime();
            }
        }
        return System.currentTimeMillis();
    }

    @Override
    public void recordRunResult(Object object) {
        if (this.startTime < 0L) {
            this.startTime = this.getTime();
        }
    }

    @Override
    public boolean done() {
        this.stopTime = this.getTime();
        return true;
    }

    @Override
    public Attributable summary() {
        Attributable attributable = new Attributable();
        attributable.setAttribute("elapsed", new Long(this.stopTime - this.startTime));
        return attributable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.handle).append(":\n");
        this.summary().showAttributes(stringBuffer);
        return stringBuffer.toString();
    }

    public static enum TimeUnit {
        SECOND,
        MILLISECOND,
        NANOSECOND;

    }
}

