/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla.list;

import g2d.graph.IOPNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;

public class NodeListModel
extends AbstractListModel<IOPNode> {
    private List<IOPNode> data = new ArrayList<IOPNode>();

    public void setData(List<? extends IOPNode> list) {
        this.setData(list, true);
    }

    public void setData(List<? extends IOPNode> list, boolean bl) {
        int n = this.getSize() - 1;
        this.data.clear();
        if (n >= 0) {
            this.fireIntervalRemoved(this, 0, n);
        }
        this.data = list == null ? new ArrayList<IOPNode>() : new ArrayList<IOPNode>(list);
        if (bl) {
            Collections.sort(this.data, IOPNode.COMPARATOR);
        }
        if (this.getSize() > 0) {
            this.fireIntervalAdded(this, 0, this.getSize() - 1);
        }
    }

    public int indexOfName(String string, boolean bl, int n) {
        if (n < 0 || n > this.data.size()) {
            return -1;
        }
        ListIterator<IOPNode> listIterator = this.data.listIterator(n);
        while (listIterator.hasNext()) {
            String string2 = ((IOPNode)listIterator.next()).getLabel();
            if (!bl && string2.equalsIgnoreCase(string)) {
                return n;
            }
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOfCompletion(String string, int n) {
        if (string == null || string.equals("")) {
            return -1;
        }
        ListIterator<IOPNode> listIterator = this.data.listIterator(n);
        while (listIterator.hasNext()) {
            String string2 = listIterator.next().getLabel();
            for (String string3 : string2.split("[\\(:\\)]")) {
                if (!string3.toLowerCase().startsWith(string.toLowerCase())) continue;
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOfPattern(String string, boolean bl, int n) {
        if (n < 0 || n > this.data.size()) {
            return -1;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string);
        }
        catch (Exception exception) {
            return -1;
        }
        if (pattern != null) {
            ListIterator<IOPNode> listIterator = this.data.listIterator(n);
            while (listIterator.hasNext()) {
                String string2 = ((IOPNode)listIterator.next()).getLabel();
                Matcher matcher = pattern.matcher(string2);
                if (matcher.find()) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public IOPNode getElementAt(int n) {
        return n < this.data.size() ? this.data.get(n) : null;
    }

    public String[] forSaving() {
        int n = this.data.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (IOPNode iOPNode : this.data) {
            arrayList.add(iOPNode.longName);
        }
        return arrayList.toArray(new String[n]);
    }
}

