/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.glyph.BufferedGlyphList;
import g2d.graph.Dot;
import g2d.graph.GraphItem;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.graph.IOPSubgraph;
import g2d.graphviewer.NavPanel;
import g2d.netviewer.NetContainer;
import g2d.pla.PLAGraphPanel;
import g2d.pla.PLAUtils;
import g2d.pla.SEPanel;
import g2d.pla.ToolBar;
import g2d.pla.menus.CompareMenu;
import g2d.pla.menus.GraphMenu;
import g2d.swing.ExportMenu;
import g2d.swing.HierarchyMenu;
import g2d.tabwin.TabPanel;
import g2d.tabwin.menus.ViewMenu;
import g2d.toolbar.ToolButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PLAPanel
extends TabPanel
implements ChangeListener,
NetContainer {
    private final boolean allowsSelections;
    public IOPGraph graph;
    public final boolean displayable;
    public final PLAGraphPanel graphPanel;
    public final JScrollPane scrollGraph;
    public final NavPanel navPanel;
    public final SEPanel sePanel;
    public final JMenu viewMenu;
    public final JMenu hierarchyMenu;
    public final JMenu exportMenu;
    public final JMenu compareMenu;
    public final JMenu graphMenu;
    private static final String textContext = "In Context";
    private static final String ttipContext = "Layout graph according to original and show other nodes in context.";
    private static final String textDot = "DOT Layout";
    private static final String ttipDot = "Invoke dot to layout graph.";

    protected PLAPanel(IOPGraph iOPGraph, String string, String string2, boolean bl) {
        this(iOPGraph, string, string2, bl, true);
    }

    protected PLAPanel(IOPGraph iOPGraph, String string, String string2, boolean bl, boolean bl2) {
        super(string, string2);
        this.allowsSelections = bl;
        this.displayable = bl2;
        this.graphPanel = new PLAGraphPanel(this);
        this.scrollGraph = new JScrollPane(this.graphPanel);
        this.navPanel = new NavPanel(this.graphPanel);
        this.sePanel = new SEPanel(this);
        this.viewMenu = new ViewMenu(this);
        this.hierarchyMenu = new HierarchyMenu(new PLAUtils());
        this.exportMenu = new ExportMenu(this);
        this.graphMenu = new GraphMenu(this);
        this.compareMenu = new CompareMenu(this);
        this.addMenus();
        if (iOPGraph.getDisplayable()) {
            this.addToolBar();
            this.addWestPanel();
            this.addNorthEastPanel();
            this.addSouthEastPanel();
        } else {
            ToolBar toolBar = new ToolBar(this.graphPanel, this.displayable);
            this.noDisplay(toolBar, this.sePanel, iOPGraph.getGraphInfo());
        }
        this.setGraph(iOPGraph);
    }

    private void addMenus() {
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.hierarchyMenu);
        this.menuBar.add(this.exportMenu);
    }

    @Override
    public IOPGraph getGraph() {
        return this.graph;
    }

    public SEPanel getSEPanel() {
        return this.sePanel;
    }

    public NavPanel getNavPanel() {
        return this.navPanel;
    }

    @Override
    public PLAGraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    public boolean allowsSelections() {
        return this.allowsSelections;
    }

    @Override
    public void dispose() {
        super.dispose();
        PLAUtils.dispose(this.graph);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.graph.getDisplayable()) {
            Object object = changeEvent.getSource();
            if (object instanceof JViewport) {
                JViewport jViewport = (JViewport)changeEvent.getSource();
                Dimension dimension = jViewport.getExtentSize();
                Dimension dimension2 = jViewport.getViewSize();
                if (dimension2.width <= dimension.width && dimension2.height <= dimension.height) {
                    this.navPanel.setPorthole(null);
                    return;
                }
                this.navPanel.setPorthole(jViewport.getViewRect());
            } else if (object instanceof IOPGraph || object instanceof Dot || object instanceof GraphItem) {
                if (this.graph != null) {
                    this.graphPanel.checkSize();
                    if (object instanceof Dot || !this.graph.isLarge()) {
                        this.navPanel.setImage(this.graph.getBufferedImage());
                    }
                }
                this.sePanel.stateChanged(changeEvent);
            }
        }
    }

    public void setGraph(IOPGraph iOPGraph) {
        this.graph = iOPGraph;
        this.graphPanel.setGraph(iOPGraph);
        if (this.graph != null) {
            this.navPanel.setImage(iOPGraph.getBufferedImage());
        } else {
            this.navPanel.setImage(null);
        }
        this.sePanel.update(iOPGraph);
        this.stateChanged(new ChangeEvent(this.scrollGraph.getViewport()));
        this.repaint();
    }

    public void centerOn(IOPNode iOPNode) {
        if (this.graph != null) {
            this.graphPanel.centerOn(iOPNode);
        }
    }

    public void centerOnAndHighlight(IOPNode iOPNode) {
        if (this.graph != null) {
            this.graphPanel.removeLastSelection();
            this.graphPanel.highlight(iOPNode);
            this.graphPanel.centerOn(iOPNode.getBounds().getBounds());
        }
    }

    private void addToolBar() {
        ToolBar toolBar = new ToolBar(this.graphPanel, this.displayable);
        this.setToolBar(toolBar);
    }

    private void addWestPanel() {
        this.scrollGraph.setBackground(Color.white);
        this.scrollGraph.getViewport().setScrollMode(1);
        this.scrollGraph.getViewport().addChangeListener(this);
        this.setPanel(TabPanel.Panel.WEST, this.scrollGraph);
    }

    private void addNorthEastPanel() {
        final JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.navPanel, new GridBagConstraints());
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PLAPanel.this.navPanel.resizeThumb(jPanel.getSize());
            }
        });
        this.setPanel(TabPanel.Panel.NORTHEAST, jPanel);
    }

    private void addSouthEastPanel() {
        this.setPanel(TabPanel.Panel.SOUTHEAST, this.sePanel);
    }

    public ToolButton createLayoutButton(IOPGraph iOPGraph) {
        final IOPGraph iOPGraph2 = iOPGraph;
        final ToolButton toolButton = new ToolButton(textContext);
        toolButton.setToolTipText(ttipContext);
        toolButton.setEnabled(iOPGraph2 != null);
        toolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLAPanel.this.graphPanel.removeLastSelection();
                IOPGraph iOPGraph = PLAPanel.this.graphPanel.getGraph();
                if (iOPGraph != null && iOPGraph2 != null) {
                    String string = toolButton.getText();
                    if (PLAPanel.textDot.equals(string)) {
                        iOPGraph.doLayout(null);
                        toolButton.setText(PLAPanel.textContext);
                        toolButton.setToolTipText(PLAPanel.ttipContext);
                        PLAPanel.this.setGraph(iOPGraph);
                    } else {
                        iOPGraph.doLayout(iOPGraph2);
                        toolButton.setText(PLAPanel.textDot);
                        toolButton.setToolTipText(PLAPanel.ttipDot);
                        PLAPanel.this.setGraph(iOPGraph);
                    }
                    PLAPanel.this.graphPanel.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                } else {
                    toolButton.setSelected(false);
                    toolButton.setText(PLAPanel.textContext);
                    toolButton.setToolTipText(PLAPanel.ttipContext);
                }
            }
        });
        return toolButton;
    }

    public void resetAllSelections() {
        if (this.graph != null) {
            Collection<IOPNode> collection = this.graph.getNodesInCollection();
            for (IOPNode object2 : collection) {
                object2.setSelected(false);
                object2.setAttribute("status", "none");
                object2.updateFillColor();
            }
            Collection<IOPSubgraph> collection2 = this.graph.getSubgraphInCollection();
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                IOPSubgraph iOPSubgraph = (IOPSubgraph)iterator.next();
                iOPSubgraph.dehighlight();
                iOPSubgraph.setSelected(false);
            }
            this.graph.fireChange();
        }
        if (this.sePanel != null) {
            this.sePanel.resetAllSelections();
        }
        this.repaint();
    }

    public void repaint(String string) {
        if (this.graph != null && BufferedGlyphList.paintDebug) {
            System.err.println("PLAPanel.repaint(" + string + "): " + this.graph.paintCount);
        }
        super.repaint(1000L);
    }

    @Override
    public void repaint() {
        this.repaint("unknown");
    }
}

