/*
 * Decompiled with CFR 0.152.
 */
package g2d.pla;

import g2d.graph.IOPEdge;
import g2d.graph.IOPGraph;
import g2d.graph.IOPNode;
import g2d.pla.PLAGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class HideEdges {
    public static final String graphAttribute = "hiddenEdges";
    static final boolean DEBUG = false;
    final IOPGraph graph;
    final IOPGraph parent;
    final PLAGraph plaobj;
    ArrayList<IOPEdge> hiddenEdges;
    ArrayList<ArrayList<IOPEdge>> candidates;

    private ArrayList<IOPEdge> getCache(IOPGraph iOPGraph) {
        return iOPGraph != null ? (ArrayList)iOPGraph.getAttribute(graphAttribute) : null;
    }

    static final ArrayList<IOPEdge> getHiddenEdges(PLAGraph pLAGraph) {
        HideEdges hideEdges = new HideEdges(pLAGraph);
        return hideEdges.hiddenEdges;
    }

    private HideEdges(PLAGraph pLAGraph) {
        String string;
        long l = System.nanoTime();
        this.graph = pLAGraph.graph;
        this.parent = pLAGraph.parent;
        this.plaobj = pLAGraph;
        ArrayList<IOPEdge> arrayList = this.getCache(this.graph);
        if (arrayList != null) {
            this.hiddenEdges = arrayList;
            string = "using the cache";
        } else if (this.parent != null && (arrayList = this.getCache(this.parent)) != null) {
            this.hiddenEdges = new ArrayList<IOPEdge>(Arrays.asList(this.graph.getEdgesInArray()));
            this.hiddenEdges.retainAll(arrayList);
            this.graph.setAttribute(graphAttribute, this.hiddenEdges);
            string = "using the parents cache";
        } else {
            if (this.parent != null) {
                System.err.format("The parent of %s is %s and it has no hiddenEdges\n", this.graph, this.parent);
            }
            this.initFields();
            this.computeHiddenEdges(this.graph);
            string = "by computation";
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        if (this.graph.isLarge()) {
            System.err.format("g2d.pla.HideEdges hid %d edges, %s, and finished in %d milliseconds\n", this.hiddenEdges.size(), string, l3 / 1000000L);
        }
    }

    private void computeHiddenEdges(IOPGraph iOPGraph) {
        for (ArrayList<IOPEdge> arrayList : this.candidates) {
            this.addRedundantEdges(arrayList);
        }
    }

    private void initFields() {
        this.candidates = new ArrayList();
        this.hiddenEdges = new ArrayList();
        for (IOPNode iOPNode : this.plaobj.occurrences) {
            String string = iOPNode.id;
            List<IOPEdge> list = this.plaobj.occurrencesOut.get(string);
            ArrayList<IOPEdge> arrayList = new ArrayList<IOPEdge>();
            for (IOPEdge iOPEdge : this.plaobj.bidirectional) {
                if (!list.contains(iOPEdge)) continue;
                arrayList.add(iOPEdge);
            }
            if (arrayList.size() < 2) continue;
            this.candidates.add(arrayList);
        }
    }

    void addRedundantEdges(ArrayList<IOPEdge> arrayList) {
        ArrayList<ArrayList<IOPNode>> arrayList2 = this.findReachable(arrayList);
        this.findHides(arrayList, arrayList2);
    }

    ArrayList<ArrayList<IOPNode>> findReachable(ArrayList<IOPEdge> arrayList) {
        ArrayList<ArrayList<IOPNode>> arrayList2 = new ArrayList<ArrayList<IOPNode>>();
        for (IOPEdge iOPEdge : arrayList) {
            ArrayList<IOPNode> arrayList3 = new ArrayList<IOPNode>();
            ArrayList<IOPNode> arrayList4 = new ArrayList<IOPNode>();
            arrayList2.add(this.reachableRules(iOPEdge.getSink(), arrayList4, arrayList3));
        }
        return arrayList2;
    }

    ArrayList<IOPNode> _reachableRules(IOPNode iOPNode, ArrayList<IOPNode> arrayList, ArrayList<IOPNode> arrayList2) {
        List<IOPEdge> list = this.plaobj.rulesOut.get(iOPNode.id);
        ArrayList<IOPNode> arrayList3 = new ArrayList<IOPNode>();
        for (IOPEdge graphItem : list) {
            arrayList3.add(graphItem.getSink());
        }
        arrayList2.add(iOPNode);
        for (IOPNode iOPNode2 : arrayList3) {
            for (IOPEdge iOPEdge : this.plaobj.occurrencesOut.get(iOPNode2.id)) {
                IOPNode iOPNode3 = iOPEdge.getSink();
                if (arrayList2.contains(iOPNode3) || arrayList.contains(iOPNode3)) continue;
                arrayList.add(iOPNode3);
            }
        }
        if (arrayList.size() == 0) {
            return arrayList2;
        }
        iOPNode = arrayList.remove(0);
        return this.reachableRules(iOPNode, arrayList, arrayList2);
    }

    ArrayList<IOPNode> reachableRules(IOPNode iOPNode, ArrayList<IOPNode> arrayList, ArrayList<IOPNode> arrayList2) {
        while (true) {
            List<IOPEdge> list = this.plaobj.rulesOut.get(iOPNode.id);
            ArrayList<IOPNode> arrayList3 = new ArrayList<IOPNode>();
            for (IOPEdge iOPEdge : list) {
                arrayList3.add(iOPEdge.getSink());
            }
            arrayList2.add(iOPNode);
            for (IOPNode iOPNode2 : arrayList3) {
                for (IOPEdge iOPEdge : this.plaobj.occurrencesOut.get(iOPNode2.id)) {
                    IOPNode iOPNode3 = iOPEdge.getSink();
                    if (arrayList2.contains(iOPNode3) || arrayList.contains(iOPNode3)) continue;
                    arrayList.add(iOPNode3);
                }
            }
            if (arrayList.size() == 0) {
                return arrayList2;
            }
            iOPNode = arrayList.remove(0);
        }
    }

    void findHides(ArrayList<IOPEdge> arrayList, ArrayList<ArrayList<IOPNode>> arrayList2) {
        int n = arrayList2.size();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            ArrayList<IOPNode> arrayList5 = arrayList2.get(i);
            IOPNode iOPNode = arrayList5.get(0);
            if (this.findRule(arrayList2, iOPNode, n, i, 0)) {
                arrayList4.add(i);
                continue;
            }
            arrayList3.add(i);
        }
        ArrayList<ArrayList<IOPNode>> arrayList6 = new ArrayList<ArrayList<IOPNode>>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            arrayList6.add(arrayList2.get(n2));
        }
        int n3 = arrayList6.size();
        Iterator iterator2 = arrayList4.iterator();
        while (iterator2.hasNext()) {
            int n4 = (Integer)iterator2.next();
            if (!this.findList(arrayList6, arrayList2.get(n4).get(0), n3, 0)) continue;
            this.hiddenEdges.add(arrayList.get(n4));
        }
    }

    boolean findRule(ArrayList<ArrayList<IOPNode>> arrayList, IOPNode iOPNode, int n, int n2, int n3) {
        while (n3 < n) {
            if (n3 == n2) {
                ++n3;
                continue;
            }
            if (arrayList.get(n3).contains(iOPNode)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    boolean findList(ArrayList<ArrayList<IOPNode>> arrayList, IOPNode iOPNode, int n, int n2) {
        while (n2 < n) {
            if (arrayList.get(n2).contains(iOPNode)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

