/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.Reorderable;
import g2d.terms.Term;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;

class TermTableModel
extends AbstractTableModel
implements Reorderable {
    private boolean editable;
    private final String title;
    protected ArrayList<Term> terms = new ArrayList();

    public TermTableModel(AttackEditor attackEditor, String string, Collection<Term> collection, boolean bl) {
        this.editable = bl;
        this.title = string;
        if (collection != null) {
            this.terms.addAll(collection);
        }
    }

    @Override
    public int getRowCount() {
        return this.terms.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.terms.get(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Term.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.terms.set(n, (Term)object);
    }

    @Override
    public String getColumnName(int n) {
        return this.title;
    }

    public void addTerm(Term term) {
        this.terms.add(term);
        this.fireTableRowsUpdated(0, this.terms.size());
        this.fireTableStructureChanged();
    }

    public void deleteTerm(int n) {
        this.terms.remove(n);
        this.fireTableRowsUpdated(0, this.terms.size());
        this.fireTableStructureChanged();
    }

    public void clear() {
        this.terms.clear();
        this.fireTableRowsUpdated(0, this.terms.size());
        this.fireTableStructureChanged();
    }

    @Override
    public void reorder(int n, int n2) {
        if (n2 == n || n2 == n + 1) {
            return;
        }
        if (n2 > n) {
            Term term = this.terms.get(n);
            this.terms.add(n2, term);
            this.terms.remove(n);
        } else {
            Term term = this.terms.remove(n);
            this.terms.add(n2, term);
        }
        System.err.println("reorder: " + n + " to " + n2);
        this.fireTableRowsUpdated(0, this.terms.size());
        this.fireTableStructureChanged();
    }
}

