/*
 * Decompiled with CFR 0.152.
 */
package g2d.npa;

import g2d.npa.AttackEditor;
import g2d.npa.TableRowTransferHandler;
import g2d.npa.TermCellEditor;
import g2d.npa.TermTableModel;
import g2d.terms.Term;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DropMode;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class TermTable
extends JTable {
    private final AttackEditor editor;
    private final TermTableModel model;
    private final Term base;

    public TermTable(AttackEditor attackEditor, String string, Collection<Term> collection, Term term, boolean bl) {
        this.editor = attackEditor;
        this.base = term;
        this.model = new TermTableModel(attackEditor, string, collection, bl);
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(true);
        if (bl) {
            this.setDragEnabled(true);
            this.setDropMode(DropMode.INSERT_ROWS);
            this.setTransferHandler(new TableRowTransferHandler(this));
        }
        this.getTableHeader().setReorderingAllowed(false);
    }

    public TermTable(AttackEditor attackEditor, boolean bl) {
        this(attackEditor, "Terms", null, null, bl);
    }

    public TermTable(AttackEditor attackEditor) {
        this(attackEditor, "Terms", null, null, true);
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        return new TermCellEditor(this.editor, this.editor.syntax.attackAlgebra, this.model.terms.get(n));
    }

    public void clear() {
        this.model.clear();
    }

    public void setEditable(boolean bl) {
        this.model.setEditable(bl);
    }

    public void addTerm() {
        this.model.addTerm(this.base);
    }

    public void deleteTerm(int n) {
        this.model.deleteTerm(n);
    }

    public boolean isOK(String[] stringArray) {
        int n = this.model.terms.size();
        for (int i = 0; i < n; ++i) {
            Term term = this.model.terms.get(i);
            if (term.holeCount() <= 0) continue;
            stringArray[0] = "The term " + term + " in row " + (i + 1) + " still has unfilled holes";
            return false;
        }
        return true;
    }

    public ArrayList<Term> getTerms() {
        return new ArrayList<Term>(this.model.terms);
    }
}

